/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleUtils {
    private static final Logger logger = LoggerFactory.getLogger(HandleUtils.class);
    public static final String HANDLE_SERVER_URI = "http://hdl.handle.net/";
    public static final int REDIRECT_TIMEOUT = 30000;

    public URI resolveHandle(String resourceRef) throws URISyntaxException {
        if (resourceRef != null && resourceRef.length() > 0) {
            if (resourceRef.startsWith("hdl://")) {
                return new URI(resourceRef.replace("hdl://", HANDLE_SERVER_URI));
            }
            if (resourceRef.startsWith("hdl:")) {
                return new URI(resourceRef.replace("hdl:", HANDLE_SERVER_URI));
            }
            return new URI(resourceRef);
        }
        return null;
    }

    public URI resolveHandle(URI resourceURI) {
        if ("hdl".equals(resourceURI.getScheme())) {
            return URI.create(HANDLE_SERVER_URI + resourceURI.toString().replaceFirst("^hdl:", ""));
        }
        return resourceURI;
    }

    public URI followRedirect(URI handleURI) {
        if (handleURI.getScheme().startsWith("http")) {
            try {
                URLConnection uRLConnection = this.resolveHandle(handleURI).toURL().openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    logger.trace("Requesting {} to find possible redirect", (Object)handleURI);
                    ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(true);
                    ((HttpURLConnection)uRLConnection).setReadTimeout(30000);
                    uRLConnection.getInputStream().close();
                    URL resolvedUrl = uRLConnection.getURL();
                    URI resolvedUri = resolvedUrl.toURI();
                    if (logger.isDebugEnabled() && !resolvedUri.equals(handleURI)) {
                        logger.debug("Redirected: {} -> {}", (Object)handleURI, (Object)resolvedUri);
                    }
                    return resolvedUri;
                }
            }
            catch (URISyntaxException ex) {
                logger.warn("Could not convert URL to URI for {}: {}", (Object)handleURI, (Object)ex.getMessage());
                logger.info("Could not convert URL to URI", (Throwable)ex);
            }
            catch (ConnectException ex) {
                logger.warn("Connection to {} could not be established, could not check for a redirect (timeout is {}ms}): {}", new Object[]{handleURI, 30000, ex.getMessage()});
                logger.info("Connection could not be established while looking for redirect", (Throwable)ex);
            }
            catch (IOException ex) {
                logger.warn("Could not follow redirects for {}: {}", (Object)handleURI, (Object)ex.getMessage());
                logger.info("Could not follow redirects", (Throwable)ex);
            }
        }
        return handleURI;
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        new HandleUtils().followRedirect(URI.create("http://hdl.handle.net/1839/00-0000-0000-0001-53A6-F@format=cmdi"));
    }
}

