/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin.profiles;

import java.io.IOException;
import nl.mpi.arbil.clarin.profiles.CmdiProfileProvider;
import org.apache.commons.digester.Digester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CmdiProfileSchemaHeaderReader
implements CmdiProfileProvider {
    private static final Logger logger = LoggerFactory.getLogger(CmdiProfileSchemaHeaderReader.class);

    public CmdiProfileProvider.CmdiProfile getProfile(String profileUrl) {
        final CmdiProfileProvider.CmdiProfile profile = new CmdiProfileProvider.CmdiProfile();
        profile.href = profileUrl;
        profile.name = this.getNameFromUrl(profileUrl);
        Digester digester = new Digester();
        digester.push(new Object(){

            public void setInfo(String id, String name, String description) {
                profile.name = name;
                profile.description = description;
                profile.id = id;
            }
        });
        digester.addCallMethod("xs:schema/xs:annotation/xs:appinfo/ann:Header", "setInfo", 3);
        digester.addCallParam("xs:schema/xs:annotation/xs:appinfo/ann:Header/ann:ID", 0);
        digester.addCallParam("xs:schema/xs:annotation/xs:appinfo/ann:Header/ann:Name", 1);
        digester.addCallParam("xs:schema/xs:annotation/xs:appinfo/ann:Header/ann:Description", 2);
        try {
            digester.parse(profileUrl);
        }
        catch (IOException ex) {
            logger.warn("IOException while reading CMDI profile header", (Throwable)ex);
            profile.description = "Could not read profile details. See error log for more information";
        }
        catch (SAXException ex) {
            logger.warn("SAXException while reading CMDI profile header", (Throwable)ex);
            profile.description = "Could not read profile details. See error log for more information";
        }
        return profile;
    }

    private String getNameFromUrl(String profileUrl) {
        String customName = profileUrl.replaceAll("[/.]xsd$", "");
        if (customName.contains("/")) {
            customName = customName.substring(customName.lastIndexOf("/") + 1);
        }
        return customName;
    }
}

