/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.clarin.profiles.CmdiProfileProvider;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.clarin.profiles.CmdiProfileSchemaHeaderReader;
import nl.mpi.arbil.clarin.profiles.CmdiTemplate;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.userstorage.ArbilConfiguration;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.DownloadAbortFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTemplateManager {
    private static final Logger logger = LoggerFactory.getLogger(ArbilTemplateManager.class);
    public static final String CLARIN_PREFIX = "clarin:";
    public static final String CUSTOM_PREFIX = "custom:";
    private static final String PREFIX_REGEX = "^(clarin|custom):(\"(.*)\":)?(.*)$";
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^(clarin|custom):(\"(.*)\":)?(.*)$");
    private final CmdiProfileSchemaHeaderReader headerReader = new CmdiProfileSchemaHeaderReader();
    private static SessionStorage sessionStorage;
    private ArbilConfiguration applicationConfiguration = new ArbilConfiguration();
    private static ArbilTemplateManager singleInstance;
    private Hashtable<String, ArbilTemplate> templatesHashTable;
    private String[] builtInTemplates2 = new String[]{"Default", "Sign Language", "Language and Genetics"};
    private final Map<String, Object> cmdiLoadingState = new HashMap<String, Object>();

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static synchronized ArbilTemplateManager getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilTemplateManager();
        }
        return singleInstance;
    }

    public static Matcher getTemplateStringMatcher(String templateString) {
        return PREFIX_PATTERN.matcher(templateString);
    }

    public File createTemplate(String selectedTemplate) {
        if (selectedTemplate.length() == 0) {
            return null;
        }
        if (Arrays.binarySearch(this.builtInTemplates2, selectedTemplate) > -1) {
            return null;
        }
        File selectedTemplateFile = this.getTemplateFile(selectedTemplate);
        selectedTemplateFile.getParentFile().mkdir();
        sessionStorage.saveRemoteResource(MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/template.xml"), selectedTemplateFile, null, true, false, new DownloadAbortFlag(), null);
        File componentsDirectory = new File(selectedTemplateFile.getParentFile(), "components");
        componentsDirectory.mkdir();
        sessionStorage.saveRemoteResource(MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/default.xml"), new File(componentsDirectory, "default.xml"), null, true, false, new DownloadAbortFlag(), null);
        File examplesDirectory = new File(selectedTemplateFile.getParentFile(), "example-components");
        if (!examplesDirectory.mkdir()) {
            logger.error("Could not create example components directory: {}");
        }
        for (String[] pathString : ArbilTemplateManager.getSingleInstance().getTemplate((String)this.builtInTemplates2[0]).templatesArray) {
            sessionStorage.saveRemoteResource(MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/" + pathString[0]), new File(examplesDirectory, pathString[0]), null, true, false, new DownloadAbortFlag(), null);
        }
        sessionStorage.saveRemoteResource(MetadataReader.class.getResource("/nl/mpi/arbil/resources/xsl/imdi-viewer.xsl"), new File(selectedTemplateFile.getParentFile(), "example-format.xsl"), null, true, false, new DownloadAbortFlag(), null);
        return selectedTemplateFile;
    }

    public File getTemplateFile(String currentTemplate) {
        File currentTemplateFile = new File(this.getTemplateDirectory().getAbsolutePath() + File.separatorChar + currentTemplate + File.separatorChar + "template.xml");
        return currentTemplateFile;
    }

    public File getDefaultComponentOfTemplate(String currentTemplate) {
        File currentTemplateFile = new File(this.getTemplateDirectory().getAbsolutePath() + File.separatorChar + currentTemplate + File.separatorChar + "components" + File.separatorChar + "default.xml");
        return currentTemplateFile;
    }

    public File getTemplateDirectory() {
        return new File(sessionStorage.getProjectDirectory(), "templates");
    }

    public void addCustomProfile(String profileLocation) {
        CmdiProfileProvider.CmdiProfile profile = this.headerReader.getProfile(profileLocation);
        String templateString = String.format("%s\"%s\":%s", CUSTOM_PREFIX, profile.name, profileLocation);
        this.addSelectedTemplates(templateString);
    }

    public void addSelectedTemplates(String templateString) {
        ArrayList<String> selectedTemplates = new ArrayList<String>();
        try {
            selectedTemplates.addAll(Arrays.asList(this.loadSelectedTemplates()));
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError("No selectedTemplates file, will create one now.", e);
        }
        if (!selectedTemplates.contains(templateString)) {
            selectedTemplates.add(templateString);
        }
        try {
            this.saveSelectedTemplates(selectedTemplates);
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError("Could not crate new selectedTemplates file.", ex);
        }
    }

    private String[] loadSelectedTemplates() throws IOException {
        return sessionStorage.loadStringArray("selectedTemplates");
    }

    private void saveSelectedTemplates(ArrayList<String> selectedTamplates) throws IOException {
        sessionStorage.saveStringArray("selectedTemplates", selectedTamplates.toArray(new String[0]));
    }

    public void removeSelectedTemplates(String templateString) {
        ArrayList<String> selectedTamplates = new ArrayList<String>();
        try {
            selectedTamplates.addAll(Arrays.asList(this.loadSelectedTemplates()));
            while (selectedTamplates.contains(templateString)) {
                selectedTamplates.remove(templateString);
            }
            this.saveSelectedTemplates(selectedTamplates);
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError("Could not load or create selectedTemplates file.", ex);
        }
    }

    public List<String> getCMDIProfileHrefs() {
        ArrayList<String> profilesToReload = new ArrayList<String>();
        for (String templateString : this.getSelectedTemplates()) {
            Matcher matcher = ArbilTemplateManager.getTemplateStringMatcher(templateString);
            if (!matcher.matches()) continue;
            String xsdHref = matcher.group(4);
            profilesToReload.add(xsdHref);
        }
        return profilesToReload;
    }

    public List<String> getSelectedTemplates() {
        ArrayList<String> selectedTamplates = new ArrayList<String>();
        try {
            selectedTamplates.addAll(Arrays.asList(this.loadSelectedTemplates()));
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError("No selectedTemplates file, will create one now.", e);
            this.addDefaultImdiTemplates();
        }
        return selectedTamplates;
    }

    public void addDefaultImdiTemplates() {
        this.addSelectedTemplates("builtin:METATRANSCRIPT.Corpus.xml");
        this.addSelectedTemplates("builtin:METATRANSCRIPT.Catalogue.xml");
        this.addSelectedTemplates("builtin:METATRANSCRIPT.Session.xml");
    }

    public void removeDefaultImdiTemplates() {
        this.removeSelectedTemplates("builtin:METATRANSCRIPT.Corpus.xml");
        this.removeSelectedTemplates("builtin:METATRANSCRIPT.Catalogue.xml");
        this.removeSelectedTemplates("builtin:METATRANSCRIPT.Session.xml");
    }

    private MenuItemData createMenuItemForTemplate(String location) {
        ArbilIcons arbilIcons = ArbilIcons.getSingleInstance();
        MenuItemData menuItem = new MenuItemData();
        menuItem.type = MenuItemData.Type.IMDI;
        if (location.startsWith("builtin:")) {
            String currentString = location.substring("builtin:".length());
            return this.getMenuItemDataForBuiltinTemplate(currentString, menuItem, arbilIcons);
        }
        if (location.startsWith("template:")) {
            String currentString;
            menuItem.menuText = currentString = location.substring("template:".length());
            menuItem.menuAction = currentString;
            menuItem.menuToolTip = currentString;
            menuItem.menuIcon = arbilIcons.sessionColorIcon;
        } else if (location.startsWith(CUSTOM_PREFIX)) {
            menuItem.type = MenuItemData.Type.CMDI;
            Matcher matcher = ArbilTemplateManager.getTemplateStringMatcher(location);
            if (matcher.find()) {
                String profileName;
                String profileUrl = matcher.group(4);
                menuItem.menuText = profileName = ArbilTemplateManager.getCustomProfileName(matcher);
                menuItem.menuAction = profileUrl;
                menuItem.menuToolTip = profileUrl;
            } else {
                menuItem.menuText = location;
            }
            menuItem.menuIcon = ArbilIcons.clarinIcon;
        } else if (location.startsWith(CLARIN_PREFIX)) {
            menuItem.type = MenuItemData.Type.CMDI;
            String currentString = location.substring(CLARIN_PREFIX.length());
            CmdiProfileProvider.CmdiProfile cmdiProfile = CmdiProfileReader.getSingleInstance().getProfile(currentString);
            if (cmdiProfile == null) {
                menuItem.menuText = "<unknown>";
                menuItem.menuAction = "<unknown>";
                menuItem.menuToolTip = currentString;
            } else {
                menuItem.menuText = cmdiProfile.name;
                menuItem.menuAction = cmdiProfile.getXsdHref();
                menuItem.menuToolTip = cmdiProfile.description;
            }
            menuItem.menuIcon = ArbilIcons.clarinIcon;
        } else {
            BugCatcherManager.getBugCatcher().logError("Unknown template location type in " + location, null);
        }
        return menuItem;
    }

    public static String getCustomProfileName(Matcher matcher) {
        String customName = matcher.group(3);
        if (customName == null && (customName = matcher.group(4).replaceAll("[/.]xsd$", "")).contains("/")) {
            customName = customName.substring(customName.lastIndexOf("/") + 1);
        }
        return customName;
    }

    private MenuItemData getMenuItemDataForBuiltinTemplate(String currentString, MenuItemData menuItem, ArbilIcons arbilIcons) {
        for (String[] currentTemplateName : ArbilTemplateManager.getSingleInstance().getTemplate(null).rootTemplatesArray) {
            if (!currentString.equals(currentTemplateName[0])) continue;
            menuItem.menuText = currentTemplateName[1];
            menuItem.menuAction = "." + currentTemplateName[0].replaceFirst("\\.xml$", "");
            menuItem.menuToolTip = currentTemplateName[1];
            menuItem.menuIcon = menuItem.menuText.contains("Corpus") ? arbilIcons.corpusnodeColorIcon : (menuItem.menuText.contains("Catalogue") ? arbilIcons.catalogueColorIcon : arbilIcons.sessionColorIcon);
            return menuItem;
        }
        BugCatcherManager.getBugCatcher().logError("Could not find builtin template location " + currentString, null);
        return null;
    }

    public MenuItemData[] getSelectedTemplatesMenuItems() {
        String[] locationsArray = null;
        try {
            locationsArray = this.loadSelectedTemplates();
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        if (locationsArray == null || locationsArray.length == 0) {
            try {
                this.addDefaultImdiTemplates();
                locationsArray = this.loadSelectedTemplates();
            }
            catch (IOException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        if (locationsArray == null) {
            return new MenuItemData[0];
        }
        ArrayList<MenuItemData> returnArray = new ArrayList<MenuItemData>(locationsArray.length);
        for (int insertableCounter = 0; insertableCounter < locationsArray.length; ++insertableCounter) {
            String templateLocation = locationsArray[insertableCounter];
            MenuItemData menuItemData = this.createMenuItemForTemplate(templateLocation);
            if (menuItemData == null) continue;
            returnArray.add(menuItemData);
        }
        Collections.sort(returnArray, new Comparator<MenuItemData>(){

            @Override
            public int compare(MenuItemData firstItem, MenuItemData secondItem) {
                return firstItem.menuText.compareToIgnoreCase(secondItem.menuText);
            }
        });
        return returnArray.toArray(new MenuItemData[0]);
    }

    public String[] getAvailableTemplates() {
        Object[] templatesList;
        File templatesDir = this.getTemplateDirectory();
        if (!templatesDir.exists() && !templatesDir.mkdir()) {
            logger.error("Could not create template directory: {}", (Object)templatesDir);
        }
        ArrayList<String> templateList = new ArrayList<String>();
        for (String string : templatesList = templatesDir.list()) {
            if (!this.getTemplateFile(string).exists()) continue;
            templateList.add(string);
        }
        templatesList = templateList.toArray(new String[0]);
        Arrays.sort(templatesList);
        return templatesList;
    }

    private ArbilTemplateManager() {
        this.templatesHashTable = new Hashtable();
    }

    public ArbilTemplate getDefaultTemplate() {
        return this.getTemplate(this.builtInTemplates2[0]);
    }

    public ArbilTemplate getCmdiTemplate(String nameSpaceString) {
        if (nameSpaceString != null) {
            try {
                ArbilTemplate template = this.waitForCmdiTemplateProfileLoading(nameSpaceString);
                if (template == null) {
                    template = this.loadCmdiTemplateProfile(nameSpaceString);
                }
                return template;
            }
            catch (InterruptedException iEx) {
                BugCatcherManager.getBugCatcher().logError("Interrupted while waiting for CMDI profile to load", iEx);
                return null;
            }
        }
        logger.error("Name space URL not provided, cannot load the CMDI template, please check the XML file and ensure that the name space is specified.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmdiTemplate waitForCmdiTemplateProfileLoading(String nameSpaceString) throws InterruptedException {
        Map<String, Object> map = this.cmdiLoadingState;
        synchronized (map) {
            while (this.cmdiLoadingState.containsKey(nameSpaceString)) {
                this.cmdiLoadingState.wait();
            }
            CmdiTemplate cmdiTemplate = (CmdiTemplate)this.templatesHashTable.get(nameSpaceString);
            if (cmdiTemplate != null) {
                return cmdiTemplate;
            }
            this.cmdiLoadingState.put(nameSpaceString, new Object());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadCmdiTemplates() {
        Map<String, Object> map = this.cmdiLoadingState;
        synchronized (map) {
            this.templatesHashTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArbilTemplate loadCmdiTemplateProfile(String nameSpaceString) {
        try {
            CmdiTemplate cmdiTemplate = new CmdiTemplate(sessionStorage, this.applicationConfiguration.isVerbatimXmlTreeStructure());
            cmdiTemplate.loadTemplate(nameSpaceString, CmdiProfileReader.getSingleInstance());
            cmdiTemplate.startLoadingDatacategoryDescriptions();
            this.templatesHashTable.put(nameSpaceString, cmdiTemplate);
            CmdiTemplate cmdiTemplate2 = cmdiTemplate;
            return cmdiTemplate2;
        }
        finally {
            Map<String, Object> map = this.cmdiLoadingState;
            synchronized (map) {
                this.cmdiLoadingState.remove(nameSpaceString);
                this.cmdiLoadingState.notifyAll();
            }
        }
    }

    public ArbilTemplate getTemplate(String templateName) {
        if (templateName == null || templateName.length() < 1) {
            return this.getDefaultTemplate();
        }
        if (!this.templatesHashTable.containsKey(templateName)) {
            ArbilTemplate returnTemplate = new ArbilTemplate(sessionStorage);
            if (returnTemplate.readTemplate(this.getTemplateFile(templateName), templateName)) {
                this.templatesHashTable.put(templateName, returnTemplate);
                return returnTemplate;
            }
            return this.getDefaultTemplate();
        }
        return this.templatesHashTable.get(templateName);
    }

    public void setApplicationConfiguration(ArbilConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    static {
        singleInstance = null;
    }

    public static class MenuItemData {
        public Type type;
        public String menuText;
        public String menuAction;
        public String menuToolTip;
        public ImageIcon menuIcon;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            IMDI,
            CMDI,
            OTHER;

        }
    }
}

