/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.table.DefaultTableModel;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.util.MessageDialogHandler;

public class ArbilFieldViewTableModel
extends DefaultTableModel {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private ArbilTableModel imdiTableModel;
    private static MessageDialogHandler dialogHandler;
    Class[] types = new Class[]{String.class, Boolean.class, Boolean.class, String.class};
    private int showOnlyEnabledCount = -1;
    public static final int FIELD_NAME_COLUMN = 0;
    public static final int SHOW_ONLY_COLUMN = 1;
    public static final int HIDE_COLUMN = 2;
    public static final int WIDTH_COLUMN = 3;

    public static void setMessageDialogHandler(MessageDialogHandler dialogHandlerInstance) {
        dialogHandler = dialogHandlerInstance;
    }

    public ArbilFieldViewTableModel(ArbilTableModel localImdiTableModel) {
        this.imdiTableModel = localImdiTableModel;
        this.setColumnIdentifiers(new String[]{widgets.getString("FIELD_VIEW_TABLE_COLUMN NAME"), widgets.getString("FIELD_VIEW_TABLE_SHOW ONLY"), widgets.getString("FIELD_VIEW_TABLE_HIDE"), widgets.getString("FIELD_VIEW_TABLE_COLUMN WIDTH")});
        ArbilFieldView currentView = this.imdiTableModel.getFieldView();
        if (currentView != null) {
            Enumeration knownColumnNames = currentView.getKnownColumns();
            while (knownColumnNames.hasMoreElements()) {
                String currentFieldName = knownColumnNames.nextElement().toString();
                this.addRow(new Object[]{currentFieldName, currentView.isShowOnlyColumn(currentFieldName), currentView.isHiddenColumn(currentFieldName), this.widthToString(currentView.getColumnWidth(currentFieldName))});
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 2) {
            if (this.showOnlyEnabledCount < 0) {
                this.showOnlyEnabledCount = 0;
                for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                    if (!this.getValueAt(rowCounter, 1).equals(true)) continue;
                    ++this.showOnlyEnabledCount;
                }
            }
            return this.showOnlyEnabledCount == 0;
        }
        return column == 1 || column == 2 || column == 3;
    }

    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.showOnlyEnabledCount = -1;
        boolean booleanState = Boolean.TRUE.equals(aValue);
        String targetColumnName = this.getValueAt(row, 0).toString();
        switch (column) {
            case 1: {
                if (booleanState) {
                    this.imdiTableModel.getFieldView().addShowOnlyColumn(targetColumnName);
                    break;
                }
                this.imdiTableModel.getFieldView().removeShowOnlyColumn(targetColumnName);
                break;
            }
            case 2: {
                if (booleanState) {
                    this.imdiTableModel.getFieldView().addHiddenColumn(targetColumnName);
                    break;
                }
                this.imdiTableModel.getFieldView().removeHiddenColumn(targetColumnName);
                break;
            }
            case 3: {
                String intString;
                if (aValue != null && aValue instanceof String && (intString = ((String)aValue).trim()).length() > 0) {
                    try {
                        Integer width = Integer.parseInt((String)aValue);
                        this.imdiTableModel.setPreferredColumnWidth(targetColumnName, width);
                    }
                    catch (NumberFormatException ex) {
                        dialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("FIELD_VIEW_TABLE_INVALID WIDTH FOR COLUMN {0}"), targetColumnName), widgets.getString("COLUMN WIDTH INVALID"));
                    }
                    break;
                }
                this.imdiTableModel.setPreferredColumnWidth(targetColumnName, null);
            }
        }
        this.imdiTableModel.requestReloadTableData();
        this.fireTableStructureChanged();
    }

    private String widthToString(Integer width) {
        if (width == null) {
            return "";
        }
        return String.valueOf(width);
    }
}

