/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.ui.ArbilHelp;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ArbilHyperlinkListener
implements HyperlinkListener {
    private static final Logger logger = LoggerFactory.getLogger(ArbilHyperlinkListener.class);
    private static SessionStorage sessionStorage;
    private static TreeHelper treeHelper;
    private static WindowManager windowManager;
    private static MessageDialogHandler dialogHandler;
    private static DataNodeLoader dataNodeLoader;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public static void setMessageDialogHandler(MessageDialogHandler dialogHandlerInstance) {
        dialogHandler = dialogHandlerInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)evt.getSource();
            if (evt.getDescription().startsWith("arbilscript:")) {
                try {
                    String[] commandsArray;
                    ArbilDataNode currentImdiObject = null;
                    String arbilscriptString = evt.getDescription().substring("arbilscript:".length());
                    logger.debug("acting on arbilscript: {}", (Object)arbilscriptString);
                    for (String commandString : commandsArray = arbilscriptString.split("&")) {
                        logger.debug("commandString: {}", (Object)commandString);
                        if (commandString.startsWith("add=")) {
                            String nodeTypeString = commandString.substring("add=".length());
                            logger.debug("nodeTypeString: {}", (Object)nodeTypeString);
                            currentImdiObject = this.addNode(currentImdiObject, nodeTypeString, "Wizard Corpus", null, null, null);
                        }
                        if (!commandString.startsWith("set=")) continue;
                        String[] fieldCommand = commandString.substring("set=".length()).split(":");
                        logger.debug("set: {}", (Object)(fieldCommand[0] + " = " + fieldCommand[1]));
                        this.setField(currentImdiObject, fieldCommand[0], fieldCommand[1]);
                    }
                    for (int i = 0; i < pane.getComponentCount(); ++i) {
                        Container c = (Container)pane.getComponent(i);
                        logger.debug("Component count {}", (Object)c.getComponentCount());
                        Component swingComponentOfHTMLInputType = c.getComponent(0);
                        logger.debug(swingComponentOfHTMLInputType.getClass().getName());
                        if (swingComponentOfHTMLInputType instanceof JTextField) {
                            JTextField tf = (JTextField)swingComponentOfHTMLInputType;
                            logger.debug(tf.getName());
                            logger.debug(tf.getText());
                            logger.debug("{}", (Object)tf.getAction());
                            logger.debug(swingComponentOfHTMLInputType.getName());
                            logger.debug(swingComponentOfHTMLInputType.getName());
                            logger.debug(swingComponentOfHTMLInputType.getName());
                            String formCommandString = swingComponentOfHTMLInputType.getName();
                            logger.debug("formCommandString: {}", (Object)formCommandString);
                            if (formCommandString == null || !formCommandString.startsWith("arbilscript:set=")) continue;
                            String nodeTypeString = formCommandString.substring("arbilscript:set=".length());
                            logger.debug("nodeTypeString: {}", (Object)nodeTypeString);
                            currentImdiObject = this.addNode(currentImdiObject, nodeTypeString, tf.getText(), null, null, null);
                            continue;
                        }
                        if (!(swingComponentOfHTMLInputType instanceof JButton)) continue;
                    }
                }
                catch (ArbilMetadataException exception) {
                    dialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                }
            } else if (evt.getURL() != null) {
                try {
                    if (ArbilHelp.getArbilHelpInstance().showHelpItem(evt.getURL())) {
                        return;
                    }
                }
                catch (IOException ioEx) {
                    BugCatcherManager.getBugCatcher().logError(ioEx);
                }
                catch (SAXException saxEx) {
                    BugCatcherManager.getBugCatcher().logError(saxEx);
                }
                windowManager.openUrlWindowOnce(evt.getURL().toString(), evt.getURL());
            }
        }
    }

    private void setField(ArbilDataNode currentImdiObject, String fieldPath, String FieldValue) {
        for (ArbilField[] currentField : currentImdiObject.getFields().values()) {
            if (!currentField[0].getFullXmlPath().endsWith(fieldPath)) continue;
            currentField[0].setFieldValue(FieldValue, true, true);
        }
    }

    private ArbilDataNode addNode(ArbilDataNode parentNode, String nodeType, String nodeTypeDisplayName, String targetXmlPath, URI resourceUri, String mimeType) throws ArbilMetadataException {
        ArbilDataNode addedImdiObject;
        logger.debug("wizard add node: {}", (Object)nodeType);
        logger.debug("adding into: {}", (Object)parentNode);
        if (parentNode == null) {
            URI targetFileURI = sessionStorage.getNewArbilFileName(sessionStorage.getProjectWorkingDirectory(), nodeType);
            targetFileURI = MetadataReader.getSingleInstance().addFromTemplate(new File(targetFileURI), nodeType);
            addedImdiObject = dataNodeLoader.getArbilDataNode(null, targetFileURI);
            treeHelper.addLocation(targetFileURI);
            treeHelper.applyRootLocations();
        } else {
            parentNode.saveChangesToCache(true);
            addedImdiObject = dataNodeLoader.getArbilDataNode(null, new MetadataBuilder().addChildNode(parentNode, nodeType, targetXmlPath, resourceUri, mimeType));
        }
        addedImdiObject.waitTillLoaded();
        windowManager.openFloatingTableOnce(new ArbilDataNode[]{addedImdiObject}, nodeTypeDisplayName);
        return addedImdiObject;
    }
}

