/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ArbilVersion;
import nl.mpi.arbil.clarin.HandleUtils;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.importexport.ArbilToHtmlConverter;
import nl.mpi.arbil.ui.ArbilDragDrop;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.ui.ArbilHelp;
import nl.mpi.arbil.ui.ArbilHyperlinkListener;
import nl.mpi.arbil.ui.ArbilNodeSearchPanel;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilSubnodesScrollPane;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTaskStatusBar;
import nl.mpi.arbil.ui.ArbilWindowComponent;
import nl.mpi.arbil.ui.ArbilWindowState;
import nl.mpi.arbil.ui.HtmlViewPane;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizard;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.arbil.util.task.ArbilTaskListener;
import nl.mpi.flap.plugin.PluginArbilTable;
import nl.mpi.flap.plugin.PluginArbilTableModel;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginWidgetFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilWindowManager
implements MessageDialogHandler,
WindowManager,
PluginWidgetFactory {
    private static final Logger logger = LoggerFactory.getLogger(ArbilWindowManager.class);
    public static final int FONT_SCALE_DEFAULT = 1;
    public static final float FONT_SCALE_STEP = 0.1f;
    private Hashtable<String, Component[]> windowList = new Hashtable();
    private Hashtable windowStatesHashtable;
    private JDesktopPane desktopPane;
    private JFrame linorgFrame;
    private ArbilTaskStatusBar statusBar;
    private static final int defaultWindowX = 50;
    private static final int defaultWindowY = 50;
    private static final int nextWindowWidth = 800;
    private static final int nextWindowHeight = 600;
    private int nextWindowX = 50;
    private int nextWindowY = 50;
    private float fontScale = 1.0f;
    private Hashtable<String, String> messageDialogQueue = new Hashtable();
    private boolean messagesCanBeShown = false;
    boolean showMessageThreadrunning = false;
    private Collection<ArbilTaskListener> taskListeners = new HashSet<ArbilTaskListener>();
    private ApplicationVersionManager versionManager;
    private ImageBoxRenderer imageBoxRenderer;
    private JMenu windowMenu;
    private SessionStorage sessionStorage;
    private TreeHelper treeHelper;
    private DataNodeLoader dataNodeLoader;
    private TableController tableController;
    private ArbilDragDrop dragDrop;

    public void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        this.versionManager = versionManagerInstance;
    }

    public void setSessionStorage(SessionStorage sessionStorageInstance) {
        this.sessionStorage = sessionStorageInstance;
    }

    public void setTreeHelper(TreeHelper treeHelperInstance) {
        this.treeHelper = treeHelperInstance;
    }

    public void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        this.dataNodeLoader = dataNodeLoaderInstance;
    }

    public void setImageBoxRenderer(ImageBoxRenderer imageBoxRenderer) {
        this.imageBoxRenderer = imageBoxRenderer;
    }

    public void setTableController(TableController tableController) {
        this.tableController = tableController;
    }

    public void setDragDrop(ArbilDragDrop dragDrop) {
        this.dragDrop = dragDrop;
        dragDrop.setTransferHandlerOnComponent(this.desktopPane);
    }

    public void setWindowMenu(JMenu windowMenu) {
        this.windowMenu = windowMenu;
    }

    public ArbilWindowManager() {
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(new Color(204, 204, 204));
    }

    public void setMessagesCanBeShown(boolean messagesCanBeShown) {
        this.messagesCanBeShown = messagesCanBeShown;
    }

    public void loadGuiState(JFrame linorgFrameLocal, ArbilTaskStatusBar statusBar) {
        this.linorgFrame = linorgFrameLocal;
        this.statusBar = statusBar;
        try {
            int screenDeviceCount;
            this.setStatusBarVisible(this.sessionStorage.loadBoolean("showStatusBar", true));
            this.windowStatesHashtable = (Hashtable)this.sessionStorage.loadObject("windowStates");
            Object linorgFrameBounds = this.windowStatesHashtable.get("linorgFrameBounds");
            if (linorgFrameBounds != null) {
                Rectangle savedBounds = (Rectangle)linorgFrameBounds;
                if (savedBounds.getHeight() > 100.0 && savedBounds.getWidth() > 100.0) {
                    this.getMainFrame().setBounds(savedBounds);
                } else {
                    this.getMainFrame().setBounds(0, 0, 800, 600);
                }
            }
            if (this.windowStatesHashtable.containsKey("ScreenDeviceCount") && (screenDeviceCount = ((Integer)this.windowStatesHashtable.get("ScreenDeviceCount")).intValue()) > GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length) {
                this.getMainFrame().setLocationRelativeTo(null);
                Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (linorgFrameBounds instanceof Rectangle && ((Rectangle)linorgFrameBounds).intersects(new Rectangle(screenDimension))) {
                    this.getMainFrame().setBounds(((Rectangle)linorgFrameBounds).intersection(new Rectangle(screenDimension)));
                } else {
                    this.getMainFrame().setBounds(0, 0, 800, 600);
                    this.getMainFrame().setLocationRelativeTo(null);
                }
            }
        }
        catch (Exception ex) {
            logger.info("setting default windowStates");
            logger.debug("load windowStates failed: ", (Throwable)ex);
            this.windowStatesHashtable = new Hashtable();
            this.getMainFrame().setBounds(0, 0, 800, 600);
            this.getMainFrame().setLocationRelativeTo(null);
            this.getMainFrame().setExtendedState(6);
        }
        this.loadSplitPlanes(this.getMainFrame().getContentPane().getComponent(0));
    }

    public void openAboutPage() {
        ArbilVersion appVersion = (ArbilVersion)this.versionManager.getApplicationVersion();
        String messageString = MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("ABOUTBOXTEXT"), appVersion.currentMajor, appVersion.currentMinor, appVersion.currentRevision, appVersion.lastCommitDate, appVersion.compileDate, System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), appVersion.getCopyrightYear());
        JTextArea textComponent = new JTextArea();
        textComponent.setText(messageString);
        textComponent.setEditable(false);
        textComponent.setOpaque(false);
        textComponent.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JButton licenseButton = new JButton(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("DISPLAY LICENSE"));
        licenseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArbilWindowManager.this.showLicenseWindow();
            }
        });
        JButton closeButton = new JButton(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("CLOSE"));
        final JDialog aboutDialog = this.createModalDialog(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("ABOUT {0}"), appVersion.applicationTitle), textComponent, null, licenseButton, closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                aboutDialog.dispose();
            }
        });
        aboutDialog.setVisible(true);
    }

    private void showLicenseWindow() {
        try {
            HtmlViewPane licensePane = new HtmlViewPane(this.getClass().getResource("/nl/mpi/arbil/resources/html/license/gpl2.html"));
            JButton closeButton = new JButton(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("CLOSE"));
            final JDialog licenseDialog = this.createModalDialog(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("LICENSE"), licensePane.createScrollPane(), new Dimension(800, 600), closeButton);
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    licenseDialog.dispose();
                }
            });
            licenseDialog.setVisible(true);
        }
        catch (IOException ioEx) {
            this.addMessageDialogToQueue(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("ERROR WHILE TRYING TO SHOW LICENSE. SEE ERROR LOG FOR DETAILS."), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("ERROR"));
            BugCatcherManager.getBugCatcher().logError(ioEx);
        }
    }

    @Override
    public void offerUserToSaveChanges() throws Exception {
        if (this.dataNodeLoader.nodesNeedSave()) {
            if (0 == JOptionPane.showConfirmDialog(this.getMainFrame(), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("THERE ARE UNSAVED CHANGES.SAVE NOW?"), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("SAVE CHANGES"), 2, -1)) {
                this.dataNodeLoader.saveNodesNeedingSave(true);
            } else {
                throw new Exception("user canceled save action");
            }
        }
    }

    @Override
    public File showEmptyExportDirectoryDialogue(String titleText) {
        boolean fileSelectDone = false;
        while (!fileSelectDone) {
            File[] selectedFiles = this.showFileSelectBox(titleText + ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString(" DESTINATION DIRECTORY"), true, false, null, PluginDialogHandler.DialogueType.custom, null);
            if (selectedFiles != null && selectedFiles.length > 0) {
                File destinationDirectory = selectedFiles[0];
                boolean mkdirsOkay = true;
                if (destinationDirectory != null && !destinationDirectory.exists()) {
                    mkdirsOkay = destinationDirectory.mkdirs();
                }
                if (destinationDirectory == null || !mkdirsOkay || !destinationDirectory.exists()) {
                    JOptionPane.showMessageDialog(this.getMainFrame(), MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("THE EXPORT DIRECTORY {0} DOES NOT EXIST.PLEASE SELECT OR CREATE A DIRECTORY."), destinationDirectory), titleText, -1);
                    continue;
                }
                if (!destinationDirectory.exists()) continue;
                if (destinationDirectory.list().length == 0) {
                    fileSelectDone = true;
                    return destinationDirectory;
                }
                if (!this.showConfirmDialogBox(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("THE SELECTED EXPORT DIRECTORY IS NOT EMPTY. ON EXPORT, YOU WILL HAVE THE CHOICE TO EITHER OVERRIDE OR CREATE DUPLICATES OF ANY PRESENT FILES.DO YOU WANT TO CONTINUE?"), titleText)) continue;
                return destinationDirectory;
            }
            fileSelectDone = true;
        }
        return null;
    }

    @Override
    public File[] showMetadataFileSelectBox(String titleText, boolean multipleSelect) {
        HashMap<String, FileFilter> fileFilterMap = new HashMap<String, FileFilter>(2);
        fileFilterMap.put(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("METADATA FILES"), new FileFilter(){

            public boolean accept(File selectedFile) {
                if (selectedFile.isDirectory()) {
                    return true;
                }
                if (selectedFile.exists() && !selectedFile.isDirectory()) {
                    String fileNameLowerCase = selectedFile.getName().toLowerCase();
                    if (fileNameLowerCase.endsWith(".cmdi")) {
                        return true;
                    }
                    if (fileNameLowerCase.endsWith(".imdi")) {
                        return true;
                    }
                }
                return false;
            }

            public String getDescription() {
                return ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("METADATA FILES");
            }
        });
        return this.showFileSelectBox(titleText, false, multipleSelect, fileFilterMap, PluginDialogHandler.DialogueType.open, null);
    }

    @Override
    public File[] showDirectorySelectBox(String titleText, boolean multipleSelect) {
        HashMap<String, FileFilter> fileFilterMap = new HashMap<String, FileFilter>(2);
        FileFilter imdiFileFilter = new FileFilter(){

            public String getDescription() {
                return ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("DIRECTORIES");
            }

            public boolean accept(File selectedFile) {
                return selectedFile.exists() && selectedFile.isDirectory();
            }
        };
        fileFilterMap.put(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("DIRECTORIES"), imdiFileFilter);
        return this.showFileSelectBox(titleText, true, multipleSelect, fileFilterMap, PluginDialogHandler.DialogueType.custom, null);
    }

    public File[] showFileSelectBox(String titleText, boolean directorySelectOnly, boolean multipleSelect, Map<String, FileFilter> fileFilterMap, PluginDialogHandler.DialogueType dialogueType, JComponent customAccessory) {
        File[] returnFile;
        int showDialogResult;
        File workingDirectory = null;
        String workingDirectoryPathString = this.sessionStorage.loadString("fileSelect." + titleText);
        workingDirectory = workingDirectoryPathString == null ? new File(System.getProperty("user.home")) : new File(workingDirectoryPathString);
        JFileChooser fileChooser = this.createFileChooser(fileFilterMap);
        if (directorySelectOnly) {
            fileChooser.setFileSelectionMode(1);
        } else {
            fileChooser.setFileSelectionMode(0);
        }
        fileChooser.setCurrentDirectory(workingDirectory);
        fileChooser.setMultiSelectionEnabled(multipleSelect);
        if (customAccessory != null) {
            fileChooser.setAccessory(customAccessory);
        }
        switch (dialogueType) {
            case open: {
                fileChooser.setDialogTitle(titleText);
                showDialogResult = fileChooser.showOpenDialog(this.getMainFrame());
                break;
            }
            case save: {
                fileChooser.setDialogTitle(titleText);
                showDialogResult = fileChooser.showSaveDialog(this.getMainFrame());
                break;
            }
            default: {
                showDialogResult = fileChooser.showDialog(this.getMainFrame(), titleText);
            }
        }
        if (0 == showDialogResult) {
            returnFile = fileChooser.getSelectedFiles();
            if (returnFile.length == 0) {
                returnFile = new File[]{fileChooser.getSelectedFile()};
            }
            this.storeSelectedMetadataFileFilter(fileFilterMap, fileChooser);
        } else {
            returnFile = null;
        }
        if (returnFile != null && returnFile.length == 1 && !returnFile[0].exists() && returnFile[0].getName().equals(returnFile[0].getParentFile().getName())) {
            returnFile[0] = returnFile[0].getParentFile();
        }
        File lastUsedWorkingDirectory = fileChooser.getCurrentDirectory();
        this.sessionStorage.saveString("fileSelect." + titleText, lastUsedWorkingDirectory.getAbsolutePath());
        return returnFile;
    }

    private JFileChooser createFileChooser(Map<String, FileFilter> fileFilterMap) {
        JFileChooser fileChooser = new JFileChooser();
        if (fileFilterMap != null) {
            for (FileFilter filter : fileFilterMap.values()) {
                fileChooser.addChoosableFileFilter(filter);
            }
            String lastFileFilter = this.sessionStorage.loadString("metadataFileFilter");
            if (lastFileFilter != null && fileFilterMap.containsKey(lastFileFilter)) {
                fileChooser.setFileFilter(fileFilterMap.get(lastFileFilter));
            }
        }
        return fileChooser;
    }

    private void storeSelectedMetadataFileFilter(Map<String, FileFilter> fileFilterMap, JFileChooser fileChooser) {
        FileFilter selectedFilter = fileChooser.getFileFilter();
        if (selectedFilter != null && fileFilterMap != null && fileFilterMap.containsValue(selectedFilter)) {
            for (Map.Entry<String, FileFilter> filterEntry : fileFilterMap.entrySet()) {
                if (filterEntry.getValue() != selectedFilter) continue;
                this.sessionStorage.saveString("metadataFileFilter", filterEntry.getKey());
                return;
            }
        }
    }

    public boolean showConfirmDialogBox(String messageString, String messageTitle) {
        if (messageTitle == null) {
            messageTitle = "Arbil";
        }
        return 0 == JOptionPane.showConfirmDialog(this.getMainFrame(), messageString, messageTitle, 2, -1);
    }

    public void addMessageDialogToQueue(String messageString, String messageTitle) {
        String currentMessage;
        if (messageTitle == null) {
            messageTitle = this.versionManager.getApplicationVersion().applicationTitle;
        }
        if ((currentMessage = this.messageDialogQueue.get(messageTitle)) != null) {
            messageString = messageString + "\n-------------------------------\n" + currentMessage;
        }
        this.messageDialogQueue.put(messageTitle, messageString);
        this.showMessageDialogQueue();
    }

    private void applyWindowDefaults(JInternalFrame currentInternalFrame) {
        int tempWindowWidth = this.desktopPane.getWidth() > 800 ? 800 : this.desktopPane.getWidth() - 50;
        int tempWindowHeight = this.desktopPane.getHeight() > 600 ? 600 : this.desktopPane.getHeight() - 50;
        if (tempWindowHeight < 100) {
            tempWindowHeight = 100;
        }
        currentInternalFrame.setSize(tempWindowWidth, tempWindowHeight);
        currentInternalFrame.setClosable(true);
        currentInternalFrame.setIconifiable(true);
        currentInternalFrame.setMaximizable(true);
        currentInternalFrame.setResizable(true);
        currentInternalFrame.setVisible(true);
        currentInternalFrame.setLocation(this.nextWindowX, this.nextWindowY);
        this.nextWindowX += Math.max(10, currentInternalFrame.getInsets().left);
        this.nextWindowY += Math.max(10, currentInternalFrame.getInsets().top - 10);
        if (this.nextWindowX + tempWindowWidth > this.desktopPane.getWidth()) {
            this.nextWindowX = 0;
        }
        if (this.nextWindowY + tempWindowHeight > this.desktopPane.getHeight()) {
            this.nextWindowY = 0;
        }
    }

    private synchronized void showMessageDialogQueue() {
        if (!this.showMessageThreadrunning) {
            new Thread("showMessageThread"){

                public void run() {
                    try {
                        6.sleep(100L);
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                    ArbilWindowManager.this.showMessageThreadrunning = true;
                    if (ArbilWindowManager.this.messagesCanBeShown) {
                        while (ArbilWindowManager.this.messageDialogQueue.size() > 0) {
                            final String messageTitle = (String)ArbilWindowManager.this.messageDialogQueue.keys().nextElement();
                            final String messageText = (String)ArbilWindowManager.this.messageDialogQueue.remove(messageTitle);
                            if (messageText == null) continue;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(ArbilWindowManager.this.getMainFrame(), messageText, messageTitle, -1);
                                }
                            });
                        }
                    }
                    ArbilWindowManager.this.showMessageThreadrunning = false;
                }
            }.start();
        }
    }

    public void showSetupWizardIfFirstRun() {
        if (!this.treeHelper.locationsHaveBeenAdded() && !"yes".equals(this.sessionStorage.loadString("wizardHasRun"))) {
            this.sessionStorage.saveString("wizardHasRun", "yes");
            new ArbilSetupWizard(this.getMainFrame()).showModalDialog();
        }
    }

    public void openIntroductionPage() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilWindowManager.this.initWindows();
                if (!ArbilWindowManager.this.treeHelper.locationsHaveBeenAdded()) {
                    logger.debug("no local locations found, showing help window");
                    try {
                        ArbilHelp helpComponent = ArbilHelp.getArbilHelpInstance();
                        if (null == ArbilWindowManager.this.focusWindow(ArbilHelp.helpWindowTitle)) {
                            ArbilWindowManager.this.createWindow(ArbilHelp.helpWindowTitle, helpComponent);
                        }
                        helpComponent.setCurrentPage("IMDI", ArbilHelp.INTRODUCTION_PAGE);
                    }
                    catch (IOException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                    catch (SAXException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
                ArbilWindowManager.this.startKeyListener();
                ArbilWindowManager.this.setMessagesCanBeShown(true);
                ArbilWindowManager.this.showMessageDialogQueue();
            }
        });
    }

    private void initWindows() {
        try {
            Hashtable windowListHashtable = (Hashtable)this.sessionStorage.loadObject("openWindows");
            Enumeration windowNamesEnum = windowListHashtable.keys();
            while (windowNamesEnum.hasMoreElements()) {
                ArbilWindowState windowState;
                final String currentWindowName = windowNamesEnum.nextElement().toString();
                logger.debug("currentWindowName: {}", (Object)currentWindowName);
                Object windowStateObject = windowListHashtable.get(currentWindowName);
                if (windowStateObject instanceof Vector) {
                    windowState = new ArbilWindowState();
                    windowState.currentNodes = (Vector)windowStateObject;
                } else if (windowStateObject instanceof ArbilWindowState) {
                    windowState = (ArbilWindowState)windowStateObject;
                } else {
                    throw new Exception("Unknown window state format");
                }
                if (windowState.currentNodes == null) continue;
                final ArbilDataNode[] imdiObjectsArray = new ArbilDataNode[windowState.currentNodes.size()];
                for (int arrayCounter = 0; arrayCounter < imdiObjectsArray.length; ++arrayCounter) {
                    try {
                        imdiObjectsArray[arrayCounter] = this.dataNodeLoader.getArbilDataNode(null, new URI(windowState.currentNodes.elementAt(arrayCounter).toString()));
                        continue;
                    }
                    catch (URISyntaxException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
                final Component[] window = new Component[1];
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (windowState.windowType == ArbilWindowState.ArbilWindowType.nodeTable) {
                            ArbilWindowManager.this.openFloatingTableGetModel(imdiObjectsArray, currentWindowName, window, windowState.fieldView);
                        } else if (windowState.windowType == ArbilWindowState.ArbilWindowType.subnodesPanel) {
                            ArbilWindowManager.this.openFloatingSubnodesWindowOnce(imdiObjectsArray[0], currentWindowName, window);
                        }
                        if (window[0] != null) {
                            if (windowState.size != null) {
                                window[0].setSize(windowState.size);
                            }
                            if (windowState.location != null) {
                                window[0].setLocation(ArbilWindowManager.this.fixLocation(windowState.location));
                            }
                        }
                    }
                });
            }
            logger.debug("done loading windowStates");
        }
        catch (Exception ex) {
            this.windowStatesHashtable = new Hashtable();
            logger.warn("load windowStates failed");
            logger.debug("load windowStates failed: ", (Throwable)ex);
        }
    }

    public void loadSplitPlanes(Component targetComponent) {
        if (targetComponent instanceof JSplitPane) {
            logger.debug("loadSplitPlanes: {}", (Object)targetComponent.getName());
            Object linorgSplitPosition = this.windowStatesHashtable.get(targetComponent.getName());
            if (linorgSplitPosition instanceof Integer) {
                logger.trace("{}: {}", (Object)targetComponent.getName(), linorgSplitPosition);
                ((JSplitPane)targetComponent).setDividerLocation((Integer)linorgSplitPosition);
            } else if (targetComponent.getName().equals("rightSplitPane")) {
                ((JSplitPane)targetComponent).setDividerLocation(150);
            } else {
                ((JSplitPane)targetComponent).setDividerLocation(200);
            }
            for (Component childComponent : ((JSplitPane)targetComponent).getComponents()) {
                this.loadSplitPlanes(childComponent);
            }
        }
        if (targetComponent instanceof JPanel) {
            for (Component childComponent : ((JPanel)targetComponent).getComponents()) {
                this.loadSplitPlanes(childComponent);
            }
        }
    }

    public void saveSplitPlanes(Component targetComponent) {
        if (targetComponent instanceof JSplitPane) {
            logger.debug("saveSplitPlanes: {}", (Object)targetComponent.getName());
            this.windowStatesHashtable.put(targetComponent.getName(), ((JSplitPane)targetComponent).getDividerLocation());
            for (Component childComponent : ((JSplitPane)targetComponent).getComponents()) {
                this.saveSplitPlanes(childComponent);
            }
        }
        if (targetComponent instanceof JPanel) {
            for (Component childComponent : ((JPanel)targetComponent).getComponents()) {
                this.saveSplitPlanes(childComponent);
            }
        }
    }

    public void resetWindows() {
        this.nextWindowX = 50;
        this.nextWindowY = 50;
        Enumeration<String> windowNamesEnum = this.windowList.keys();
        while (windowNamesEnum.hasMoreElements()) {
            String currentWindowName = windowNamesEnum.nextElement().toString();
            logger.debug("currentWindowName: {}", (Object)currentWindowName);
            Component windowObject = this.windowList.get(currentWindowName)[0];
            if (windowObject == null) continue;
            this.applyWindowDefaults((JInternalFrame)windowObject);
        }
    }

    @Override
    public void saveWindowStates() {
        try {
            this.windowStatesHashtable.put("linorgFrameBounds", this.getMainFrame().getBounds());
            this.windowStatesHashtable.put("ScreenDeviceCount", GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length);
            this.windowStatesHashtable.put("linorgFrameExtendedState", this.getMainFrame().getExtendedState());
            this.saveSplitPlanes(this.getMainFrame().getContentPane().getComponent(0));
            this.sessionStorage.saveObject(this.windowStatesHashtable, "windowStates");
            Hashtable<String, ArbilWindowState> windowListHashtable = new Hashtable<String, ArbilWindowState>();
            Enumeration<String> windowNamesEnum = this.windowList.keys();
            while (windowNamesEnum.hasMoreElements()) {
                ArbilWindowState windowState = new ArbilWindowState();
                String currentWindowName = windowNamesEnum.nextElement().toString();
                logger.debug("currentWindowName: {}", (Object)currentWindowName);
                Component windowObject = this.windowList.get(currentWindowName)[0];
                try {
                    if (windowObject == null) continue;
                    windowState.location = ((JInternalFrame)windowObject).getLocation();
                    windowState.size = ((JInternalFrame)windowObject).getSize();
                    Component currentComponent = ((JInternalFrame)windowObject).getContentPane().getComponent(0);
                    if (currentComponent != null) {
                        if (currentComponent instanceof ArbilSplitPanel) {
                            windowState.windowType = ArbilWindowState.ArbilWindowType.nodeTable;
                            if (0 < ((ArbilSplitPanel)currentComponent).arbilTable.getRowCount()) {
                                Vector<String> currentNodesVector;
                                ArbilTable table = ((ArbilSplitPanel)currentComponent).arbilTable;
                                table.updateStoredColumnWidths();
                                windowState.fieldView = table.getArbilTableModel().getFieldView();
                                windowState.currentNodes = currentNodesVector = new Vector<String>(Arrays.asList(table.getArbilTableModel().getArbilDataNodesURLs()));
                                logger.debug("saved");
                            }
                        } else if (currentComponent instanceof ArbilSubnodesScrollPane) {
                            windowState.windowType = ArbilWindowState.ArbilWindowType.subnodesPanel;
                            Vector<String> nodeVector = new Vector<String>(1);
                            nodeVector.add(((ArbilSubnodesScrollPane)currentComponent).getDataNode().getUrlString());
                            windowState.currentNodes = nodeVector;
                        }
                    }
                    windowListHashtable.put(currentWindowName, windowState);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
            this.sessionStorage.saveObject(windowListHashtable, "openWindows");
            logger.debug("saved windowStates");
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    private String addWindowToList(String windowName, final JInternalFrame windowFrame) {
        int instanceCount = 0;
        String currentWindowName = windowName;
        while (this.windowList.containsKey(currentWindowName)) {
            currentWindowName = windowName + "(" + ++instanceCount + ")";
        }
        JMenuItem windowMenuItem = new JMenuItem();
        windowMenuItem.setText(currentWindowName);
        windowMenuItem.setName(currentWindowName);
        windowFrame.setName(currentWindowName);
        windowMenuItem.setActionCommand(currentWindowName);
        windowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilWindowManager.this.focusWindow(evt.getActionCommand());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        windowFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                String windowName = e.getInternalFrame().getName();
                logger.debug("Closing window: {}", (Object)windowName);
                Component[] windowAndMenu = (Component[])ArbilWindowManager.this.windowList.get(windowName);
                if (ArbilWindowManager.this.windowMenu != null && windowAndMenu != null) {
                    ArbilWindowManager.this.windowMenu.remove(windowAndMenu[1]);
                }
                for (Component childComponent : windowFrame.getContentPane().getComponents()) {
                    if (!(childComponent instanceof ArbilWindowComponent)) continue;
                    ((ArbilWindowComponent)((Object)childComponent)).arbilWindowClosed();
                }
                ArbilWindowManager.this.windowList.remove(windowName);
                super.internalFrameClosed(e);
            }
        });
        this.windowList.put(currentWindowName, new Component[]{windowFrame, windowMenuItem});
        if (this.windowMenu != null) {
            this.windowMenu.add(windowMenuItem);
        }
        return currentWindowName;
    }

    public void stopEditingInCurrentWindow() {
        for (Component focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); focusedComponent != null; focusedComponent = focusedComponent.getParent()) {
            TableCellEditor editor;
            if (focusedComponent instanceof ArbilLongFieldEditor) {
                ((ArbilLongFieldEditor)focusedComponent).storeChanges();
                continue;
            }
            if (!(focusedComponent instanceof JTable) || (editor = ((JTable)focusedComponent).getCellEditor()) == null) continue;
            editor.stopCellEditing();
        }
    }

    @Override
    public void closeAllWindows() {
        for (JInternalFrame focusedWindow : this.desktopPane.getAllFrames()) {
            if (focusedWindow == null) continue;
            String windowName = focusedWindow.getName();
            Component[] windowAndMenu = this.windowList.get(windowName);
            if (windowAndMenu != null && this.windowMenu != null) {
                this.windowMenu.remove(windowAndMenu[1]);
            }
            this.windowList.remove(windowName);
            this.desktopPane.remove(focusedWindow);
        }
        this.desktopPane.repaint();
    }

    public JInternalFrame focusWindow(String windowName) {
        if (this.windowList.containsKey(windowName)) {
            Component windowObject = this.windowList.get(windowName)[0];
            try {
                if (windowObject != null) {
                    ((JInternalFrame)windowObject).setIcon(false);
                    ((JInternalFrame)windowObject).setSelected(true);
                    return (JInternalFrame)windowObject;
                }
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        return null;
    }

    private void startKeyListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent e) {
                int keyCode;
                KeyEvent keyEvent;
                if (e instanceof KeyEvent && e.getID() == 402 && !this.isKeyboardRepeat(keyEvent = (KeyEvent)e, keyCode = keyEvent.getKeyCode())) {
                    if ((keyEvent.isMetaDown() || keyEvent.isControlDown()) && keyCode == 87) {
                        if (keyEvent.isShiftDown()) {
                            ArbilWindowManager.this.closeWindows(ArbilWindowManager.this.getDesktopPane().getAllFrames());
                        } else {
                            ArbilWindowManager.this.closeWindows(new JInternalFrame[]{ArbilWindowManager.this.getDesktopPane().getSelectedFrame()});
                        }
                    } else if (keyCode == 9 && keyEvent.isControlDown()) {
                        try {
                            int targetLayerInt;
                            JInternalFrame[] allWindows = ArbilWindowManager.this.getDesktopPane().getAllFrames();
                            if (keyEvent.isShiftDown()) {
                                allWindows[0].moveToBack();
                                targetLayerInt = 1;
                            } else {
                                targetLayerInt = allWindows.length - 1;
                            }
                            allWindows[targetLayerInt].setIcon(false);
                            allWindows[targetLayerInt].setSelected(true);
                        }
                        catch (Exception ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                    }
                }
            }

            private boolean isKeyboardRepeat(KeyEvent keyEvent, int keyCode) {
                KeyEvent nextPress = (KeyEvent)Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(401);
                return nextPress != null && nextPress.getWhen() == keyEvent.getWhen() && nextPress.getKeyCode() == keyCode;
            }
        }, 8L);
    }

    public void resetFontScale() {
        this.changeFontScale(1.0f - this.fontScale);
    }

    public void changeFontScale(float diff) {
        this.fontScale = Math.max(this.fontScale + diff, 1.0f);
        logger.debug("fontScale: {}", (Object)Float.valueOf(this.fontScale));
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = defaults.get(key);
            if (value == null || !(value instanceof Font)) continue;
            UIManager.put(key, null);
            Font font = UIManager.getFont(key);
            if (font == null) continue;
            float size = font.getSize2D();
            UIManager.put(key, new FontUIResource(font.deriveFont(size * this.fontScale)));
        }
        SwingUtilities.updateComponentTreeUI(this.getDesktopPane().getParent().getParent());
    }

    private void closeWindows(JInternalFrame[] windowsToClose) {
        for (JInternalFrame focusedWindow : windowsToClose) {
            if (focusedWindow == null) continue;
            String windowName = focusedWindow.getName();
            Component[] windowAndMenu = this.windowList.get(windowName);
            if (windowAndMenu != null && this.windowMenu != null) {
                this.windowMenu.remove(windowAndMenu[1]);
            }
            this.windowList.remove(windowName);
            this.getDesktopPane().remove(focusedWindow);
            try {
                JInternalFrame topMostWindow;
                JInternalFrame[] allWindows = this.getDesktopPane().getAllFrames();
                if (allWindows.length <= 0 || (topMostWindow = allWindows[0]) == null) continue;
                logger.debug("topMostWindow: {}", (Object)topMostWindow);
                topMostWindow.setIcon(false);
                topMostWindow.setSelected(true);
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        this.getDesktopPane().repaint();
    }

    public JDialog createModalDialog(String title, Component contentsComponent, Dimension size, JButton ... buttons) {
        JDialog dialog = new JDialog(this.linorgFrame, title, true);
        dialog.setDefaultCloseOperation(2);
        dialog.setLayout(new BorderLayout());
        dialog.add(contentsComponent, "Center");
        dialog.setTitle(title);
        dialog.setName(title);
        dialog.setLocationRelativeTo(this.linorgFrame);
        if (buttons.length > 0) {
            JPanel buttonPanel = new JPanel(new FlowLayout(4));
            for (JButton button : buttons) {
                buttonPanel.add(button);
            }
            dialog.add((Component)buttonPanel, "South");
        }
        if (size != null) {
            dialog.setSize(size);
        } else {
            dialog.pack();
        }
        return dialog;
    }

    public JInternalFrame createWindow(String windowTitle, Component contentsComponent) {
        JInternalFrame currentInternalFrame = new JInternalFrame();
        currentInternalFrame.setLayout(new BorderLayout());
        currentInternalFrame.add(contentsComponent, "Center");
        windowTitle = this.addWindowToList(windowTitle, currentInternalFrame);
        currentInternalFrame.setTitle(windowTitle);
        currentInternalFrame.setToolTipText(windowTitle);
        currentInternalFrame.setName(windowTitle);
        this.applyWindowDefaults(currentInternalFrame);
        this.desktopPane.add((Component)currentInternalFrame, 0);
        try {
            currentInternalFrame.setSelected(true);
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        currentInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameDeactivated(InternalFrameEvent e) {
                this.fixLocation(e.getInternalFrame());
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                this.fixLocation(e.getInternalFrame());
            }

            private void fixLocation(JInternalFrame frame) {
                if (frame.getLocation().getY() < 0.0) {
                    frame.setLocation(new Point((int)frame.getLocation().getX(), 0));
                }
            }
        });
        return currentInternalFrame;
    }

    @Override
    public void openUrlWindowOnce(final String frameTitle, final URL locationUrl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JEditorPane htmlDisplay = new JEditorPane();
                htmlDisplay.setEditable(false);
                htmlDisplay.setContentType("text/html");
                try {
                    htmlDisplay.setPage(locationUrl);
                    htmlDisplay.addHyperlinkListener(new ArbilHyperlinkListener());
                }
                catch (Exception ex) {
                    logger.error("Error while adding text contents to window", (Throwable)ex);
                }
                JInternalFrame existingWindow = ArbilWindowManager.this.focusWindow(frameTitle);
                if (existingWindow == null) {
                    JScrollPane jScrollPane6 = new JScrollPane();
                    jScrollPane6.setViewportView(htmlDisplay);
                    ArbilWindowManager.this.createWindow(frameTitle, jScrollPane6);
                } else {
                    ((JScrollPane)existingWindow.getContentPane().getComponent(0)).setViewportView(htmlDisplay);
                }
            }
        });
    }

    @Override
    public void openSearchTable(final ArbilNode[] selectedNodes, final String frameTitle) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilTableModel resultsTableModel = new ArbilTableModel(ArbilWindowManager.this.imageBoxRenderer);
                resultsTableModel.setForceHorizontalView(true);
                ArbilTable arbilTable = new ArbilTable(resultsTableModel, ArbilWindowManager.this.tableController, frameTitle);
                arbilTable.setAllowNodeDrop(false);
                ArbilSplitPanel tablePanel = new ArbilSplitPanel(ArbilWindowManager.this.sessionStorage, ArbilWindowManager.this.treeHelper, ArbilWindowManager.this.dragDrop, arbilTable);
                JInternalFrame searchFrame = ArbilWindowManager.this.createWindow(frameTitle, tablePanel);
                ArbilNodeSearchPanel searchPanel = new ArbilNodeSearchPanel(searchFrame, arbilTable, selectedNodes);
                searchFrame.add((Component)searchPanel, "North");
                tablePanel.setSplitDisplay();
                tablePanel.addFocusListener(searchFrame);
                searchFrame.pack();
            }
        });
    }

    public PluginArbilTable createTable(PluginArbilTableModel pluginArbilTableModel, String tableName) {
        return new ArbilTable((ArbilTableModel)pluginArbilTableModel, this.tableController, tableName);
    }

    public PluginArbilTableModel createTableModel() {
        return new ArbilTableModel(null);
    }

    @Override
    public void openFloatingTableOnce(final URI[] rowNodesArray, final String frameTitle) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilWindowManager.this.openFloatingTableOnceGetModel(rowNodesArray, frameTitle);
            }
        });
    }

    @Override
    public void openFloatingTableOnce(final ArbilDataNode[] rowNodesArray, final String frameTitle) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilWindowManager.this.openFloatingTableOnceGetModel(rowNodesArray, frameTitle);
            }
        });
    }

    @Override
    public void openFloatingTable(final ArbilDataNode[] rowNodesArray, final String frameTitle) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilWindowManager.this.openFloatingTableGetModel(rowNodesArray, frameTitle, null, null);
            }
        });
    }

    @Override
    public ArbilTableModel openFloatingTableOnceGetModel(URI[] rowNodesArray, String frameTitle) {
        ArbilDataNode[] tableNodes = new ArbilDataNode[rowNodesArray.length];
        ArrayList<String> fieldPathsToHighlight = new ArrayList<String>();
        for (int arrayCounter = 0; arrayCounter < rowNodesArray.length; ++arrayCounter) {
            try {
                String parentNodeFragment;
                if (rowNodesArray[arrayCounter] == null) continue;
                ArbilDataNode parentNode = this.dataNodeLoader.getArbilDataNode(null, new URI(rowNodesArray[arrayCounter].toString().split("#")[0]));
                String fieldPath = rowNodesArray[arrayCounter].getFragment();
                if (parentNode.nodeTemplate == null) {
                    logger.error("nodeTemplate null in: {}", (Object)parentNode.getUrlString());
                    parentNodeFragment = "";
                } else {
                    parentNodeFragment = parentNode.nodeTemplate.getParentOfField(fieldPath);
                }
                URI targetNode = parentNodeFragment.length() > 0 ? new URI(rowNodesArray[arrayCounter].toString().split("#")[0] + "#" + parentNodeFragment) : new URI(rowNodesArray[arrayCounter].toString().split("#")[0]);
                tableNodes[arrayCounter] = this.dataNodeLoader.getArbilDataNode(null, targetNode);
                fieldPathsToHighlight.add(fieldPath);
                continue;
            }
            catch (URISyntaxException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        ArbilTableModel targetTableModel = this.openFloatingTableOnceGetModel(tableNodes, frameTitle);
        targetTableModel.highlightMatchingFieldPaths(fieldPathsToHighlight.toArray(new String[0]));
        return targetTableModel;
    }

    @Override
    public ArbilTableModel openAllChildNodesInFloatingTableOnce(URI[] rowNodesArray, String frameTitle) {
        HashSet<ArbilDataNode> tableNodes = new HashSet<ArbilDataNode>();
        for (int arrayCounter = 0; arrayCounter < rowNodesArray.length; ++arrayCounter) {
            ArbilDataNode currentNode = this.dataNodeLoader.getArbilDataNode(null, rowNodesArray[arrayCounter]);
            tableNodes.add(currentNode);
            for (ArbilDataNode currentChildNode : currentNode.getAllChildren()) {
                tableNodes.add(currentChildNode);
            }
        }
        return this.openFloatingTableOnceGetModel(tableNodes.toArray(new ArbilDataNode[0]), frameTitle);
    }

    public ArbilTableModel openFloatingTableOnceGetModel(ArbilDataNode[] rowNodesArray, String frameTitle) {
        if (rowNodesArray.length == 1 && rowNodesArray[0] != null && rowNodesArray[0].isInfoLink) {
            try {
                if (rowNodesArray[0].getUrlString().toLowerCase().endsWith(".html") || rowNodesArray[0].getUrlString().toLowerCase().endsWith(".txt")) {
                    this.openUrlWindowOnce(rowNodesArray[0].toString(), rowNodesArray[0].getURI().toURL());
                    return null;
                }
            }
            catch (MalformedURLException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
        }
        for (Component[] currentWindow : (Component[][])this.windowList.values().toArray((T[])new Component[0][])) {
            for (Component childComponent : ((JInternalFrame)currentWindow[0]).getContentPane().getComponents()) {
                ArbilTableModel currentTableModel;
                if (!(childComponent instanceof ArbilSplitPanel) || (currentTableModel = ((ArbilSplitPanel)childComponent).arbilTable.getArbilTableModel()).getArbilDataNodeCount() != rowNodesArray.length) continue;
                boolean tableMatches = true;
                for (ArbilDataNode currentItem : rowNodesArray) {
                    if (currentTableModel.containsArbilDataNode(currentItem)) continue;
                    tableMatches = false;
                    break;
                }
                if (!tableMatches) continue;
                try {
                    ((JInternalFrame)currentWindow[0]).setIcon(false);
                    ((JInternalFrame)currentWindow[0]).setSelected(true);
                    return currentTableModel;
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        }
        return this.openFloatingTableGetModel(rowNodesArray, frameTitle, null, null);
    }

    private ArbilTableModel openFloatingTableGetModel(ArbilDataNode[] rowNodesArray, String frameTitle, Component[] window, ArbilFieldView fieldView) {
        if (frameTitle == null) {
            frameTitle = rowNodesArray.length == 1 ? rowNodesArray[0].toString() : ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("SELECTION");
        }
        ArbilTableModel arbilTableModel = fieldView == null ? new ArbilTableModel(this.imageBoxRenderer) : new ArbilTableModel(fieldView, this.imageBoxRenderer);
        ArbilTable arbilTable = new ArbilTable(arbilTableModel, this.tableController, frameTitle);
        ArbilSplitPanel arbilSplitPanel = new ArbilSplitPanel(this.sessionStorage, this.treeHelper, this.dragDrop, arbilTable);
        arbilTableModel.addArbilDataNodes(rowNodesArray);
        arbilSplitPanel.setSplitDisplay();
        JInternalFrame tableFrame = this.createWindow(frameTitle, arbilSplitPanel);
        arbilSplitPanel.addFocusListener(tableFrame);
        if (window != null && window.length > 0) {
            window[0] = tableFrame;
        }
        return arbilTableModel;
    }

    @Override
    public void openFloatingSubnodesWindows(ArbilDataNode[] arbilDataNodes) {
        for (ArbilDataNode arbilDataNode : arbilDataNodes) {
            this.openFloatingSubnodesWindowOnce(arbilDataNode, arbilDataNode.toString(), null);
        }
    }

    private void openFloatingSubnodesWindowOnce(final ArbilDataNode arbilDataNode, final String frameTitle, final Component[] window) {
        for (final String currentWindowName : this.windowList.keySet()) {
            final Component[] currentWindow = this.windowList.get(currentWindowName);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (Component childComponent : ((JInternalFrame)currentWindow[0]).getContentPane().getComponents()) {
                        if (!(childComponent instanceof ArbilSubnodesScrollPane) || !((ArbilSubnodesScrollPane)childComponent).getDataNode().equals(arbilDataNode)) continue;
                        ArbilWindowManager.this.focusWindow(currentWindowName);
                        return;
                    }
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilSubnodesScrollPane scrollPane = new ArbilSubnodesScrollPane(arbilDataNode, ArbilWindowManager.this.tableController, ArbilWindowManager.this.imageBoxRenderer);
                JInternalFrame tableFrame = ArbilWindowManager.this.createWindow(frameTitle, scrollPane);
                tableFrame.addInternalFrameListener(scrollPane.getInternalFrameListener());
                if (window != null && window.length > 0) {
                    window[0] = tableFrame;
                }
            }
        });
    }

    @Override
    public boolean openFileInExternalApplication(URI nodeUri) {
        boolean result;
        block19: {
            result = false;
            boolean awtDesktopFound = false;
            URI targetUri = new HandleUtils().resolveHandle(nodeUri);
            try {
                Class.forName("java.awt.Desktop");
                awtDesktopFound = true;
            }
            catch (ClassNotFoundException cnfE) {
                awtDesktopFound = false;
                logger.debug("java.awt.Desktop class not found");
            }
            if (awtDesktopFound) {
                try {
                    if (targetUri.getScheme().toLowerCase().equals("file")) {
                        File targetFile = new File(targetUri);
                        Desktop.getDesktop().open(targetFile);
                    } else {
                        Desktop.getDesktop().browse(targetUri);
                    }
                    result = true;
                }
                catch (MalformedURLException muE) {
                    BugCatcherManager.getBugCatcher().logError("awtDesktopFound", muE);
                    this.addMessageDialogToQueue(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("FAILED TO FIND THE FILE: {0}"), muE.getMessage()), "Open In External Application");
                }
                catch (IOException ioE) {
                    BugCatcherManager.getBugCatcher().logError("awtDesktopFound", ioE);
                    if (targetUri.getScheme().equalsIgnoreCase("file")) {
                        if (this.showConfirmDialogBox(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("FAILED TO OPEN THE FILE. PLEASE CHECK THAT IT IS ACCESSIBLE AND HAS AN APPLICATION ASSOCIATED WITH IT.DO YOU WANT TO OPEN THE PARENT DIRECTORY?"), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("OPEN IN EXTERNAL APPLICATION"))) {
                            this.openFileInExternalApplication(new File(targetUri).getParentFile().toURI());
                        }
                        break block19;
                    }
                    this.addMessageDialogToQueue(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("FAILED TO OPEN THE REMOTE LOCATION: {0}"), ioE.getMessage()), "Open In External Application");
                }
            } else {
                String osNameString = null;
                try {
                    osNameString = System.getProperty("os.name").toLowerCase();
                    String fileString = ArbilDataNode.isUriLocal(targetUri) ? new File(targetUri).getAbsolutePath() : targetUri.toString();
                    Process launchedProcess = null;
                    if (osNameString.indexOf("windows") != -1 || osNameString.indexOf("nt") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", fileString});
                    }
                    if (osNameString.equals("windows 95") || osNameString.equals("windows 98")) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"command.com", "/C", "start", fileString});
                    }
                    if (osNameString.indexOf("mac") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"open", fileString});
                    }
                    if (osNameString.indexOf("linux") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"gnome-open", fileString});
                    }
                    if (launchedProcess != null) {
                        String line;
                        BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
                        while ((line = errorStreamReader.readLine()) != null) {
                            this.addMessageDialogToQueue(line, ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("OPEN IN EXTERNAL APPLICATION"));
                            logger.debug("Launched process error stream: \"{}\"", (Object)line);
                        }
                        result = true;
                    }
                }
                catch (Exception e) {
                    BugCatcherManager.getBugCatcher().logError(osNameString, e);
                }
            }
        }
        return result;
    }

    @Override
    public void openImdiXmlWindow(Object userObject, boolean formatXml, boolean launchInBrowser) {
        block11: {
            if (userObject instanceof ArbilDataNode) {
                if (((ArbilDataNode)userObject).getNeedsSaveToDisk(false)) {
                    if (0 == this.showDialogBox(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("THE NODE MUST BE SAVED FIRST.SAVE NOW?"), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("VIEW IMDI XML"), 2, -1)) {
                        ((ArbilDataNode)userObject).saveChangesToCache(true);
                    } else {
                        return;
                    }
                }
                URI nodeUri = new HandleUtils().resolveHandle(((ArbilDataNode)userObject).getURI());
                logger.debug("openImdiXmlWindow: " + nodeUri);
                String nodeName = ((ArbilDataNode)userObject).toString();
                if (formatXml) {
                    try {
                        File tempHtmlFile = new ArbilToHtmlConverter().convertToHtml((ArbilDataNode)userObject);
                        if (!launchInBrowser) {
                            this.openUrlWindowOnce(nodeName + ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString(" FORMATTED"), tempHtmlFile.toURL());
                            break block11;
                        }
                        this.openFileInExternalApplication(tempHtmlFile.toURI());
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                } else {
                    try {
                        this.openUrlWindowOnce(nodeName + "-xml", nodeUri.toURL());
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            }
        }
    }

    public int showDialogBox(String message, String title, int optionType, int messageType) {
        return JOptionPane.showConfirmDialog(this.getMainFrame(), message, title, optionType, messageType);
    }

    @Override
    public MessageDialogHandler.DialogBoxResult showDialogBoxRememberChoice(String message, String title, int optionType, int messageType) {
        JCheckBox rememberChoiceBox = new JCheckBox(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("REMEMBER MY CHOICE"));
        Object[] messageArray = new Object[]{message, rememberChoiceBox};
        int result = JOptionPane.showConfirmDialog(this.getMainFrame(), messageArray, title, optionType, messageType);
        return new MessageDialogHandler.DialogBoxResult(result, rememberChoiceBox.isSelected());
    }

    public int showDialogBox(String message, String title, int optionType, int messageType, Object[] options, Object initialValue) {
        return JOptionPane.showOptionDialog(this.getMainFrame(), message, title, optionType, messageType, null, options, initialValue);
    }

    @Override
    public ProgressMonitor newProgressMonitor(Object message, String note, int min, int max) {
        return new ProgressMonitor(this.desktopPane, message, note, min, max);
    }

    @Override
    public JFrame getMainFrame() {
        return this.linorgFrame;
    }

    @Override
    public boolean askUserToSaveChanges(String entityName) {
        return this.showConfirmDialogBox(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("THIS ACTION WILL SAVE ALL PENDING CHANGES ON {0} TO DISK. CONTINUE?"), entityName), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("SAVE TO DISK?"));
    }

    private Point fixLocation(Point location) {
        if (location.getY() < 0.0) {
            location.move((int)location.getX(), Math.max(0, (int)location.getY()));
        }
        return location;
    }

    public void setStatusBarVisible(boolean visible) {
        this.statusBar.setVisible(visible);
    }

    public boolean getStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public synchronized Collection<ArbilTaskListener> getTaskListeners() {
        return this.taskListeners;
    }

    public synchronized void addTaskListener(ArbilTaskListener taskListener) {
        this.taskListeners.add(taskListener);
    }

    public Component getCurrentFrameComponent() {
        Container frameContentPane;
        JInternalFrame selectedFrame = this.getDesktopPane().getSelectedFrame();
        if (selectedFrame != null && (frameContentPane = selectedFrame.getContentPane()).getComponentCount() > 0) {
            return frameContentPane.getComponent(0);
        }
        return null;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }
}

