/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.clarin.profiles.CmdiProfileProvider;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.TemplateDialogue;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.flap.plugin.PluginDialogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiProfilesPanel
extends JPanel {
    private final JDialog parentFrame;
    private static WindowManager windowManager;
    private static MessageDialogHandler dialogHandler;
    private static final ResourceBundle widgets;
    private JPanel clarinPanel;
    private JPanel profileReloadPanel;
    private JProgressBar profileReloadProgressBar;
    protected JCheckBox profileSelectionCheckBox;
    private JScrollPane clarinScrollPane;
    private JButton reloadListButton;
    private JButton reloadProfilesButton;
    private JButton downloadAllButton;
    private JTextArea profileInstructionsArea;
    private boolean firstLoad = true;

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public static void setMessageDialogHandler(MessageDialogHandler dialogHandlerInstance) {
        dialogHandler = dialogHandlerInstance;
    }

    public CmdiProfilesPanel(JDialog parentFrameLocal) {
        this.parentFrame = parentFrameLocal;
        this.profileReloadPanel = new JPanel();
        this.profileReloadProgressBar = new JProgressBar();
        this.clarinScrollPane = new JScrollPane();
        this.profileSelectionCheckBox = new JCheckBox();
        this.reloadListButton = new JButton();
        this.reloadProfilesButton = new JButton();
        this.downloadAllButton = new JButton();
        this.clarinPanel = new JPanel();
        JPanel profileReloadTopPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.profileReloadPanel.setLayout(new BorderLayout());
        this.profileReloadPanel.setAlignmentX(2.0f);
        profileReloadTopPanel.setLayout(new BoxLayout(profileReloadTopPanel, 2));
        this.reloadListButton.setText(widgets.getString("PROFILES_REFRESH LIST"));
        this.reloadListButton.setToolTipText(widgets.getString("DOWNLOAD THE LATEST CLARIN PROFILES"));
        this.reloadListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.reloadListButtonActionPerformed(evt);
            }
        });
        this.reloadProfilesButton.setText(widgets.getString("PROFILES_RELOAD SELECTION"));
        this.reloadProfilesButton.setToolTipText(widgets.getString("CLEAR CACHED COPIES AND RE-DOWNLOAD THE SELECTED PROFILES"));
        this.reloadProfilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.reloadProfilesButtonActionPerformed(evt);
            }
        });
        this.downloadAllButton.setText(widgets.getString("PROFILES_DOWNLOAD ALL"));
        this.downloadAllButton.setToolTipText(widgets.getString("PROFILES_DOWNLOAD ALL PROFILES FOR OFFLINE USE (INCLUDING UNSELECTED PROFILES)"));
        this.downloadAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.downloadAllButtonActionPerformed(evt);
            }
        });
        this.profileSelectionCheckBox.setText(widgets.getString("ONLY LOAD PROFILES SELECTED FOR MANUAL EDITING"));
        this.profileSelectionCheckBox.setSelected(CmdiProfileReader.getSingleInstance().getSelection() == CmdiProfileReader.ProfileSelection.SELECTED);
        profileReloadTopPanel.add(this.reloadListButton);
        profileReloadTopPanel.add(this.reloadProfilesButton);
        profileReloadTopPanel.add(this.downloadAllButton);
        profileReloadTopPanel.add(this.profileReloadProgressBar);
        this.profileReloadPanel.add((Component)profileReloadTopPanel, "Center");
        this.profileReloadPanel.add((Component)this.profileSelectionCheckBox, "South");
        this.add((Component)this.profileReloadPanel, "Last");
        this.clarinScrollPane.setViewportView(this.clarinPanel);
        this.add((Component)this.clarinScrollPane, "Center");
        this.profileInstructionsArea = new JTextArea(widgets.getString("PROFILES SELECTED BELOW WILL BECOME AVAILABLE IN THE 'ADD' MENU OF THE LOCAL CORPUS. BY DEFAULT, ONLY SELECTED PROFILES WILL BE DOWNLOADED FOR OFFLINE USE."));
        this.profileInstructionsArea.setEditable(false);
        this.profileInstructionsArea.setLineWrap(true);
        this.profileInstructionsArea.setWrapStyleWord(true);
        this.profileInstructionsArea.setOpaque(false);
        JPanel profilesTopButtonsPanel = new JPanel();
        profilesTopButtonsPanel.setLayout(new BoxLayout(profilesTopButtonsPanel, 2));
        JButton addButton = new JButton();
        addButton.setText(widgets.getString("PROFILES_ADD URL"));
        addButton.setToolTipText(widgets.getString("PROFILES_ADD A PROFILE URL TO THE LIST"));
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String newDirectoryName = JOptionPane.showInputDialog(windowManager.getMainFrame(), widgets.getString("ENTER THE PROFILE URL"), widgets.getString("ADD PROFILE"), -1, null, null, null).toString();
                ArbilTemplateManager.getSingleInstance().addCustomProfile(newDirectoryName);
                CmdiProfilesPanel.this.populateList();
            }
        });
        profilesTopButtonsPanel.add(addButton);
        JButton browseButton = new JButton();
        browseButton.setText(widgets.getString("PROFILES_ADD FILE"));
        browseButton.setToolTipText(widgets.getString("BROWSE FOR LOCAL PROFILES"));
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (File selectedFile : dialogHandler.showFileSelectBox(widgets.getString("SELECT PROFILE"), false, true, null, PluginDialogHandler.DialogueType.open, null)) {
                    ArbilTemplateManager.getSingleInstance().addCustomProfile(selectedFile.toURI().toString());
                }
                CmdiProfilesPanel.this.populateList();
            }
        });
        profilesTopButtonsPanel.add(browseButton);
        JPanel profilesTopPanel = new JPanel();
        profilesTopPanel.setLayout(new BoxLayout(profilesTopPanel, 1));
        this.profileInstructionsArea.setAlignmentX(0.0f);
        profilesTopButtonsPanel.setAlignmentX(0.0f);
        profilesTopPanel.add(this.profileInstructionsArea);
        profilesTopPanel.add(profilesTopButtonsPanel);
        this.add((Component)profilesTopPanel, "First");
    }

    public void downloadProfiles(boolean forceUpdate) {
        this.loadProfiles(forceUpdate, true);
    }

    public void loadProfileDescriptions(boolean forceUpdate) {
        this.loadProfiles(forceUpdate, false);
    }

    public void setInstructionsVisible(boolean visible) {
        this.profileInstructionsArea.setVisible(visible);
    }

    private void showProgressBar(boolean show) {
        this.reloadListButton.setVisible(!show);
        this.reloadProfilesButton.setVisible(!show);
        this.downloadAllButton.setVisible(!show);
        this.profileSelectionCheckBox.setEnabled(!show);
        this.profileReloadProgressBar.setVisible(show);
    }

    private void loadProfiles(final boolean forceUpdate, final boolean updateProfilesCache) {
        CmdiProfileReader.getSingleInstance().setSelection(this.profileSelectionCheckBox.isSelected() ? CmdiProfileReader.ProfileSelection.SELECTED : CmdiProfileReader.ProfileSelection.ALL);
        this.clarinPanel.removeAll();
        this.clarinPanel.add(new JTextField(widgets.getString("PROFILES_LOADING, PLEASE WAIT...")));
        this.showProgressBar(true);
        this.doLayout();
        new Thread(widgets.getString("PROFILES_LOADPROFILES")){

            public void run() {
                CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
                if (updateProfilesCache) {
                    cmdiProfileReader.refreshProfilesAndUpdateCache(CmdiProfilesPanel.this.profileReloadProgressBar, forceUpdate);
                } else {
                    cmdiProfileReader.refreshProfiles(forceUpdate);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CmdiProfilesPanel.this.showProgressBar(false);
                        CmdiProfilesPanel.this.populateList();
                        CmdiProfilesPanel.this.doLayout();
                    }
                });
            }
        }.start();
    }

    private void reloadListButtonActionPerformed(ActionEvent evt) {
        this.loadProfileDescriptions(true);
    }

    private void reloadProfilesButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CmdiProfilesPanel.this.showProgressBar(true);
                CmdiProfilesPanel.this.profileReloadProgressBar.setIndeterminate(true);
                CmdiProfilesPanel.this.profileReloadProgressBar.setString("");
                CmdiProfilesPanel.this.doLayout();
            }
        });
        new Thread(){

            public void run() {
                final List<String> profilesToReload = ArbilTemplateManager.getSingleInstance().getCMDIProfileHrefs();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CmdiProfilesPanel.this.profileReloadProgressBar.setIndeterminate(false);
                        CmdiProfilesPanel.this.profileReloadProgressBar.setMinimum(0);
                        CmdiProfilesPanel.this.profileReloadProgressBar.setMaximum(profilesToReload.size() + 1);
                        CmdiProfilesPanel.this.profileReloadProgressBar.setValue(1);
                    }
                });
                for (String xsdHref : profilesToReload) {
                    CmdiProfileReader.getSingleInstance().storeProfileInCache(xsdHref, 0);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CmdiProfilesPanel.this.profileReloadProgressBar.setValue(CmdiProfilesPanel.this.profileReloadProgressBar.getValue() + 1);
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CmdiProfilesPanel.this.profileReloadProgressBar.setValue(0);
                        CmdiProfilesPanel.this.showProgressBar(false);
                        CmdiProfilesPanel.this.doLayout();
                        dialogHandler.addMessageDialogToQueue(widgets.getString("THE PROFILES HAVE BEEN RE-DOWNLOADED. YOU NEED TO RESTART ARBIL IN ORDER TO APPLY ANY CHANGES."), widgets.getString("RESTART ARBIL"));
                    }
                });
            }
        }.start();
    }

    private void downloadAllButtonActionPerformed(ActionEvent evt) {
        this.downloadProfiles(true);
    }

    public synchronized void populateList() {
        this.populateProfilesList();
        if (this.firstLoad) {
            this.parentFrame.pack();
            TemplateDialogue.setDialogHeight(this.parentFrame, windowManager);
            this.firstLoad = false;
        }
    }

    protected void populateProfilesList() {
        List<String> selectedTemplates = ArbilTemplateManager.getSingleInstance().getSelectedTemplates();
        ArrayList<JCheckBox> checkBoxArray = new ArrayList<JCheckBox>();
        CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
        this.populateWithPublicProfiles(cmdiProfileReader, selectedTemplates, checkBoxArray);
        this.populateWithCustomProfiles(cmdiProfileReader, selectedTemplates, checkBoxArray);
        TemplateDialogue.addSorted(this.clarinPanel, checkBoxArray);
    }

    private void populateWithPublicProfiles(CmdiProfileReader cmdiProfileReader, List<String> selectedTemplates, List<JCheckBox> checkBoxArray) {
        for (CmdiProfileProvider.CmdiProfile currentCmdiProfile : cmdiProfileReader.cmdiProfileArray) {
            String templateId = "clarin:" + currentCmdiProfile.getXsdHref();
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(currentCmdiProfile.name);
            clarinProfileCheckBox.setName(currentCmdiProfile.name);
            clarinProfileCheckBox.setActionCommand(templateId);
            clarinProfileCheckBox.setSelected(selectedTemplates.contains(templateId));
            clarinProfileCheckBox.setToolTipText(currentCmdiProfile.description);
            clarinProfileCheckBox.addActionListener(TemplateDialogue.templateSelectionListener);
            clarinProfileCheckBox.addActionListener(new DownloadSchemaActionListener(clarinProfileCheckBox, cmdiProfileReader, currentCmdiProfile.getXsdHref()));
            checkBoxArray.add(clarinProfileCheckBox);
        }
    }

    private void populateWithCustomProfiles(CmdiProfileReader cmdiProfileReader, List<String> selectedTemplates, List<JCheckBox> checkBoxArray) {
        for (String currentSelectedProfile : selectedTemplates) {
            Matcher matcher = ArbilTemplateManager.getTemplateStringMatcher(currentSelectedProfile);
            if (!matcher.matches() || !currentSelectedProfile.startsWith("custom:")) continue;
            String profileName = ArbilTemplateManager.getCustomProfileName(matcher);
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(profileName);
            clarinProfileCheckBox.setName(profileName);
            clarinProfileCheckBox.setActionCommand(currentSelectedProfile);
            clarinProfileCheckBox.setSelected(true);
            clarinProfileCheckBox.setToolTipText(widgets.getString("CUSTOM PROFILE"));
            clarinProfileCheckBox.addActionListener(TemplateDialogue.templateSelectionListener);
            clarinProfileCheckBox.addActionListener(new DownloadSchemaActionListener(clarinProfileCheckBox, cmdiProfileReader, matcher.group(4)));
            checkBoxArray.add(clarinProfileCheckBox);
        }
    }

    static {
        widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    }

    private static class DownloadSchemaActionListener
    implements ActionListener {
        private CmdiProfileReader reader;
        private String url;
        private JCheckBox checkBox;

        public DownloadSchemaActionListener(JCheckBox clarinProfileCheckBox, CmdiProfileReader reader, String url) {
            this.reader = reader;
            this.url = url;
            this.checkBox = clarinProfileCheckBox;
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(){

                public void run() {
                    if (DownloadSchemaActionListener.this.checkBox.isSelected()) {
                        DownloadSchemaActionListener.this.reader.storeProfileInCache(DownloadSchemaActionListener.this.url, 0);
                    }
                }
            }.start();
        }
    }
}

