/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.arbil.util.WindowManager;

public class PreviewSplitPanel
extends JSplitPane {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private final WindowManager windowManager;
    private final TableController tableController;
    private ArbilTable previewTable = null;
    private boolean previewTableShown = false;
    private JScrollPane rightScrollPane;
    private JLabel previewHiddenColumnLabel;
    private JPanel previewPanel;
    private Container parentComponent;

    public PreviewSplitPanel(WindowManager windowManager, TableController tableController) {
        this.windowManager = windowManager;
        this.tableController = tableController;
        this.setDividerSize(5);
        this.setOrientation(0);
        this.setName("rightSplitPane");
        this.previewHiddenColumnLabel = new JLabel(" ");
        this.previewTable = new ArbilTable(new ArbilTableModel(null), tableController, widgets.getString("PANEL_PREVIEW"));
        this.previewTable.getArbilTableModel().setHiddenColumnsLabel(this.previewHiddenColumnLabel);
        this.initCopyPaste();
        this.rightScrollPane = new JScrollPane(this.previewTable);
        this.previewPanel = new JPanel(new BorderLayout());
        this.previewPanel.add((Component)this.rightScrollPane, "Center");
        this.previewPanel.add((Component)this.previewHiddenColumnLabel, "South");
    }

    private void initCopyPaste() {
        this.previewTable.setDragEnabled(false);
        this.previewTable.setTransferHandler(new TransferHandler(){

            public boolean importData(JComponent comp, Transferable t) {
                if (comp instanceof ArbilTable) {
                    PreviewSplitPanel.this.tableController.pasteIntoSelectedTableRowsFromClipBoard((ArbilTable)comp);
                }
                return false;
            }

            public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
                if (comp instanceof ArbilTable) {
                    PreviewSplitPanel.this.tableController.copySelectedTableRowsToClipBoard((ArbilTable)comp);
                }
            }
        });
    }

    public void setPreviewPanel(boolean showPreview) {
        TableCellEditor currentCellEditor;
        JComponent selectedComponent;
        if (this.parentComponent == null) {
            this.parentComponent = this.getParent();
        }
        if (!showPreview) {
            this.parentComponent.remove(this);
            selectedComponent = ((ArbilWindowManager)this.windowManager).getDesktopPane();
            currentCellEditor = this.previewTable.getCellEditor();
            if (currentCellEditor != null) {
                currentCellEditor.stopCellEditing();
            }
            this.previewTable.getArbilTableModel().removeAllArbilDataNodeRows();
        } else {
            this.remove(((ArbilWindowManager)this.windowManager).getDesktopPane());
            this.setDividerLocation(0.25);
            this.setTopComponent(this.previewPanel);
            this.setBottomComponent(((ArbilWindowManager)this.windowManager).getDesktopPane());
            currentCellEditor = this.previewTable.getCellEditor();
            if (currentCellEditor != null) {
                currentCellEditor.stopCellEditing();
            }
            this.previewTable.getArbilTableModel().removeAllArbilDataNodeRows();
            selectedComponent = this;
        }
        if (this.parentComponent instanceof JSplitPane) {
            int parentDividerLocation = ((JSplitPane)this.parentComponent).getDividerLocation();
            ((JSplitPane)this.parentComponent).setBottomComponent(selectedComponent);
            ((JSplitPane)this.parentComponent).setDividerLocation(parentDividerLocation);
        } else {
            this.parentComponent.add(selectedComponent);
        }
        this.previewTableShown = showPreview;
    }

    public boolean isPreviewTableShown() {
        return this.previewTableShown;
    }

    public ArbilTable getPreviewTable() {
        return this.previewTable;
    }
}

