/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import nl.mpi.arbil.ui.wizard.ArbilWizardContent;
import nl.mpi.arbil.ui.wizard.ArbilWizardModel;

public abstract class ArbilWizard {
    private JDialog wizardDialog;
    private JPanel wizardContentPanel;
    private CardLayout wizardContentPanelLayout;
    private JButton previousButton;
    private JButton nextButton;
    private JButton cancelButton;
    private JButton finishButton;
    private final Frame owner;
    private final ArbilWizardModel model;
    private static final String NEXT_ACTION = "wizard_action_next";
    private static final String PREVIOUS_ACTION = "wizard_action_previous";
    private static final String CANCEL_ACTION = "wizard_action_cancel";
    private static final String FINISH_ACTION = "wizard_action_finish";
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private ActionListener buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(ArbilWizard.PREVIOUS_ACTION)) {
                ArbilWizard.this.doPrevious();
            } else if (e.getActionCommand().equals(ArbilWizard.NEXT_ACTION)) {
                ArbilWizard.this.doNext();
            } else if (e.getActionCommand().equals(ArbilWizard.FINISH_ACTION)) {
                ArbilWizard.this.doFinish();
            } else if (e.getActionCommand().equals(ArbilWizard.CANCEL_ACTION)) {
                ArbilWizard.this.doCancel();
            }
        }
    };

    public ArbilWizard() {
        this(null);
    }

    public ArbilWizard(Frame owner) {
        this.owner = owner;
        this.initDialog();
        this.model = new ArbilWizardModel();
    }

    public void showDialog() {
        this.showDialog(false);
    }

    public void showModalDialog() {
        this.showDialog(true);
    }

    private void showDialog(boolean modal) {
        this.refreshContent();
        if (this.owner != null) {
            this.wizardDialog.setLocationRelativeTo(this.owner);
        }
        this.wizardDialog.setModal(modal);
        this.wizardDialog.setVisible(true);
    }

    public void refreshContent() {
        Object id = this.model.getCurrentId();
        if (id != null) {
            ArbilWizardContent content = this.model.getCurrent();
            this.previousButton.setEnabled(content.getPrevious() != null);
            this.nextButton.setVisible(content.getNext() != null);
            this.finishButton.setVisible(content.getNext() == null);
            content.beforeShow();
            content.refresh();
            this.wizardContentPanelLayout.show(this.wizardContentPanel, id.toString());
        }
        this.wizardDialog.pack();
    }

    public void addContent(Object id, ArbilWizardContent content) {
        this.wizardContentPanel.add((Component)content.getContent(), id.toString());
        this.model.addContent(id, content);
    }

    public void setCurrent(Object id) {
        this.model.setCurrent(id);
        this.refreshContent();
    }

    private void initDialog() {
        this.wizardContentPanel = new JPanel();
        this.wizardContentPanelLayout = new CardLayout();
        this.wizardContentPanel.setLayout(this.wizardContentPanelLayout);
        this.wizardContentPanel.setBackground(Color.WHITE);
        JPanel buttonsPanel = new JPanel(new FlowLayout(4));
        buttonsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 2, 0, 2), BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY)));
        buttonsPanel.setBackground(Color.WHITE);
        this.previousButton = new JButton(widgets.getString("PREVIOUS"));
        this.previousButton.setActionCommand(PREVIOUS_ACTION);
        this.previousButton.addActionListener(this.buttonListener);
        buttonsPanel.add(this.previousButton);
        this.nextButton = new JButton(widgets.getString("NEXT"));
        this.nextButton.setActionCommand(NEXT_ACTION);
        this.nextButton.addActionListener(this.buttonListener);
        buttonsPanel.add(this.nextButton);
        this.finishButton = new JButton(widgets.getString("FINISH"));
        this.finishButton.setActionCommand(FINISH_ACTION);
        this.finishButton.addActionListener(this.buttonListener);
        buttonsPanel.add(this.finishButton);
        this.cancelButton = new JButton(widgets.getString("CANCEL"));
        this.cancelButton.setActionCommand(CANCEL_ACTION);
        this.cancelButton.addActionListener(this.buttonListener);
        buttonsPanel.add(this.cancelButton);
        this.wizardDialog = this.owner != null ? new JDialog(this.owner) : new JDialog();
        this.wizardDialog.setTitle(widgets.getString("ARBIL WIZARD"));
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        this.wizardDialog.getContentPane().setBackground(Color.WHITE);
        this.wizardDialog.getContentPane().add((Component)this.wizardContentPanel, "Center");
        this.wizardDialog.getContentPane().add((Component)buttonsPanel, "South");
        this.wizardDialog.setDefaultCloseOperation(0);
        this.wizardDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ArbilWizard.this.doCancel();
            }
        });
    }

    protected void doNext() {
        if (this.model.getCurrent() != null && !this.model.getCurrent().beforeNext()) {
            return;
        }
        this.model.next();
        this.refreshContent();
    }

    protected void doPrevious() {
        if (this.model.getCurrent() != null && !this.model.getCurrent().beforePrevious()) {
            return;
        }
        this.model.previous();
        this.refreshContent();
    }

    protected boolean doFinish() {
        if (this.onFinish()) {
            this.wizardDialog.dispose();
            return true;
        }
        return false;
    }

    protected boolean doCancel() {
        if (this.onCancel()) {
            this.wizardDialog.dispose();
            return true;
        }
        return false;
    }

    protected JDialog getWizardDialog() {
        return this.wizardDialog;
    }

    protected abstract boolean onFinish();

    protected abstract boolean onCancel();
}

