/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindata;

import javax.xml.bind.annotation.XmlAttribute;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityRelation;

public class RelationTypeDefinition {
    @XmlAttribute(name="name", namespace="http://mpi.nl/tla/kin")
    private String displayName;
    @XmlAttribute(name="type", namespace="http://mpi.nl/tla/kin")
    private DataTypes.RelationType[] relationType;
    @XmlAttribute(name="dcr", namespace="http://mpi.nl/tla/kin")
    private String dataCategory;
    @XmlAttribute(name="colour", namespace="http://mpi.nl/tla/kin")
    private String lineColour;
    @XmlAttribute(name="width", namespace="http://mpi.nl/tla/kin")
    private int lineWidth;
    @XmlAttribute(name="dash", namespace="http://mpi.nl/tla/kin")
    private int lineDash = 0;
    @XmlAttribute(name="orientation", namespace="http://mpi.nl/tla/kin")
    private CurveLineOrientation curveLineOrientation = CurveLineOrientation.horizontal;

    public RelationTypeDefinition() {
    }

    public RelationTypeDefinition(String displayName, String dataCategory, DataTypes.RelationType[] relationType, String lineColour, int lineWidth, int lineDash, CurveLineOrientation curveLineOrientation) {
        this.displayName = displayName;
        this.relationType = relationType;
        this.dataCategory = dataCategory;
        this.lineColour = lineColour;
        this.lineWidth = lineWidth;
        this.lineDash = lineDash;
        this.curveLineOrientation = curveLineOrientation;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLineColour() {
        return this.lineColour;
    }

    public int getLineDash() {
        return this.lineDash;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public String getDataCategory() {
        return this.dataCategory;
    }

    public DataTypes.RelationType[] getRelationType() {
        return this.relationType;
    }

    public CurveLineOrientation getCurveLineOrientation() {
        return this.curveLineOrientation;
    }

    public boolean matchesType(EntityRelation entityRelation) {
        if (entityRelation == null) {
            return false;
        }
        if (this.dataCategory == null ? entityRelation.dcrType != null : !this.dataCategory.equals(entityRelation.dcrType)) {
            return false;
        }
        if (this.relationType == null) {
            if (entityRelation.getRelationType() != null) {
                return false;
            }
        } else {
            boolean foundType = false;
            DataTypes.RelationType entityRelationType = entityRelation.getRelationType();
            DataTypes.RelationType entityRelationOppositeType = DataTypes.getOpposingRelationType(entityRelation.getRelationType());
            for (DataTypes.RelationType currentType : this.relationType) {
                if (!currentType.equals((Object)entityRelationType) && !currentType.equals((Object)entityRelationOppositeType)) continue;
                foundType = true;
            }
            if (!foundType) {
                return false;
            }
        }
        return !(this.displayName == null ? entityRelation.customType != null : !this.displayName.equals(entityRelation.customType));
    }

    public static enum CurveLineOrientation {
        horizontal,
        vertical;

    }
}

