/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.util.ArrayList;
import java.util.Arrays;
import nl.mpi.arbil.clarin.profiles.CmdiProfileProvider;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.kindocument.CmdiTransformer;
import nl.mpi.kinnate.kindocument.KinXsdException;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.entityprofiles.CmdiProfileSelectionPanel;
import nl.mpi.kinnate.ui.entityprofiles.ProfileRecord;

public class ProfileManager {
    private final SessionStorage sessionStorage;
    private final ProjectRecord projectRecord;
    private final MessageDialogHandler dialogHandler;
    private GraphPanel graphPanel;
    private CmdiProfileSelectionPanel cmdiProfileSelectionPanel;
    private final ArrayList<CmdiProfileProvider.CmdiProfile> cmdiProfileArray = new ArrayList();

    public ProfileManager(SessionStorage sessionStorage, ProjectRecord projectRecord, MessageDialogHandler dialogHandler) {
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.projectRecord = projectRecord;
    }

    public void loadProfiles(final boolean forceUpdate, final CmdiProfileSelectionPanel cmdiProfileSelectionPanel, final GraphPanel graphPanel) {
        this.cmdiProfileSelectionPanel = cmdiProfileSelectionPanel;
        this.graphPanel = graphPanel;
        CmdiProfileReader.getSingleInstance().setSelection(CmdiProfileReader.ProfileSelection.ALL);
        cmdiProfileSelectionPanel.setProfileManager(this);
        cmdiProfileSelectionPanel.setStatus(false, "Loading, please wait...", false);
        new Thread("loadProfiles"){

            @Override
            public void run() {
                ArrayList<String> problemProfiles = new ArrayList<String>();
                for (ProfileRecord profileRecord : graphPanel.dataStoreSvg.selectedProfiles) {
                    cmdiProfileSelectionPanel.setStatus(false, "Loading: " + profileRecord.profileName + ", please wait...", false);
                    try {
                        ProfileManager.this.preloadProfile(profileRecord.profileId, forceUpdate);
                    }
                    catch (KinXsdException exception) {
                        problemProfiles.add(profileRecord.profileId);
                        BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    }
                }
                cmdiProfileSelectionPanel.setStatus(false, "Loading the profile list from the server, please wait...", false);
                CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
                cmdiProfileReader.refreshProfiles(forceUpdate);
                ArrayList<ProfileRecord> selectedProfiles = new ArrayList<ProfileRecord>(Arrays.asList(graphPanel.dataStoreSvg.selectedProfiles));
                for (CmdiProfileProvider.CmdiProfile currentProfile : cmdiProfileReader.cmdiProfileArray) {
                    for (ProfileRecord profileRecord : selectedProfiles.toArray(new ProfileRecord[0])) {
                        if (!profileRecord.profileId.equals(currentProfile.id)) continue;
                        selectedProfiles.remove(profileRecord);
                    }
                }
                ProfileManager.this.cmdiProfileArray.addAll(cmdiProfileReader.cmdiProfileArray);
                for (ProfileRecord profileRecord : selectedProfiles) {
                    CmdiProfileProvider.CmdiProfile cmdiProfile = new CmdiProfileProvider.CmdiProfile();
                    cmdiProfile.id = profileRecord.profileId;
                    cmdiProfile.name = profileRecord.profileName;
                    String unpublished_Profile = "Unpublished Profile";
                    cmdiProfile.description = "Unpublished Profile";
                    cmdiProfile.creatorName = "Unpublished Profile";
                    cmdiProfile.href = "Unpublished Profile";
                    cmdiProfile.registrationDate = "------------";
                    ProfileManager.this.cmdiProfileArray.add(0, cmdiProfile);
                }
                cmdiProfileSelectionPanel.setProfileManager(ProfileManager.this);
                if (!problemProfiles.isEmpty()) {
                    cmdiProfileSelectionPanel.setStatus(true, "There were " + problemProfiles.size() + " selected profiles that could not be retrieved", true);
                } else {
                    cmdiProfileSelectionPanel.setStatus(true, "", false);
                }
            }
        }.start();
    }

    private void preloadProfile(String profileId, boolean forceUpdate) throws KinXsdException {
        new CmdiTransformer(this.sessionStorage).getXsd(profileId, this.projectRecord, forceUpdate);
    }

    public void addProfileSelection(final String profileId, final String profileName) {
        new Thread("addProfileSelection"){

            @Override
            public void run() {
                try {
                    ProfileManager.this.cmdiProfileSelectionPanel.setStatus(false, "Loading, please wait...", false);
                    ProfileManager.this.preloadProfile(profileId, false);
                    ArrayList<ProfileRecord> selectedProfiles = new ArrayList<ProfileRecord>(Arrays.asList(((ProfileManager)ProfileManager.this).graphPanel.dataStoreSvg.selectedProfiles));
                    selectedProfiles.add(new ProfileRecord(profileName, profileId));
                    ((ProfileManager)ProfileManager.this).graphPanel.dataStoreSvg.selectedProfiles = selectedProfiles.toArray(new ProfileRecord[0]);
                    ProfileManager.this.graphPanel.setRequiresSave();
                }
                catch (KinXsdException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    ProfileManager.this.dialogHandler.addMessageDialogToQueue("The selected profile (" + profileName + ") could not be loaded.", "Profile Selection Error");
                }
                ProfileManager.this.cmdiProfileSelectionPanel.setStatus(true, "", false);
            }
        }.start();
    }

    public void removeProfileSelection(String profileId) {
        ArrayList<ProfileRecord> selectedProfiles = new ArrayList<ProfileRecord>();
        for (ProfileRecord profileRecord : this.graphPanel.dataStoreSvg.selectedProfiles) {
            if (profileRecord.profileId.equals(profileId)) continue;
            selectedProfiles.add(profileRecord);
        }
        this.graphPanel.dataStoreSvg.selectedProfiles = selectedProfiles.toArray(new ProfileRecord[0]);
        this.graphPanel.setRequiresSave();
    }

    public boolean profileIsSelected(String profileId) {
        for (ProfileRecord profileRecord : this.graphPanel.dataStoreSvg.selectedProfiles) {
            if (!profileRecord.profileId.equals(profileId)) continue;
            return true;
        }
        return false;
    }

    public int getProfileCount() {
        return this.cmdiProfileArray.size();
    }

    public CmdiProfileProvider.CmdiProfile getProfileAt(int index) {
        return this.cmdiProfileArray.get(index);
    }
}

