/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.util.ArrayList;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.OldFormatException;
import nl.mpi.kinnate.svg.relationlines.RelationRecord;
import nl.mpi.kinnate.svg.relationlines.RelationRecordTable;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class RelationSvg {
    private MessageDialogHandler dialogHandler;

    public RelationSvg(MessageDialogHandler dialogHandler) {
        this.dialogHandler = dialogHandler;
    }

    private void addUseNode(SVGDocument doc, String svgNameSpace, Element targetGroup, String targetDefId) {
        String useNodeId = targetDefId + "use";
        Element useNodeOld = doc.getElementById(useNodeId);
        if (useNodeOld != null) {
            useNodeOld.getParentNode().removeChild(useNodeOld);
        }
        Element useNode = doc.createElementNS(svgNameSpace, "use");
        useNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + targetDefId);
        useNode.setAttribute("id", useNodeId);
        targetGroup.appendChild(useNode);
    }

    public void createRelationElements(GraphPanel graphPanel, RelationRecordTable relationRecords, Element relationGroupNode) throws OldFormatException {
        relationRecords.adjustLines(graphPanel);
        for (RelationRecord relationRecord : relationRecords.getAllRecords()) {
            Element groupNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "g");
            groupNode.setAttribute("id", relationRecord.idString);
            Element defsNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "defs");
            boolean addedRelationLine = false;
            Element linkLine = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "path");
            linkLine.setAttribute("d", relationRecord.getPathPointsString());
            if (relationRecord.lineDash > 0) {
                linkLine.setAttribute("stroke-dasharray", Integer.toString(relationRecord.lineDash));
                linkLine.setAttribute("stroke-dashoffset", "0");
            }
            linkLine.setAttribute("fill", "none");
            if (relationRecord.lineColour != null) {
                linkLine.setAttribute("stroke", relationRecord.lineColour);
            } else {
                linkLine.setAttribute("stroke", "grey");
            }
            linkLine.setAttribute("stroke-width", Integer.toString(relationRecord.lineWidth));
            linkLine.setAttribute("id", relationRecord.lineIdString);
            if (relationRecord.directedRelation.equals((Object)DataTypes.RelationType.directedout)) {
                int lineMarkerOffset = 30 - relationRecord.lineWidth * 9;
                if (lineMarkerOffset < 0) {
                    lineMarkerOffset = 0;
                }
                Element startMarker = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "marker");
                String startMarkerId = relationRecord.lineIdString + "StartMarker";
                startMarker.setAttribute("id", startMarkerId);
                startMarker.setAttribute("fill", linkLine.getAttribute("stroke"));
                startMarker.setAttribute("orient", "auto");
                startMarker.setAttribute("viewBox", "0 0 12 12");
                startMarker.setAttribute("refX", Integer.toString(-lineMarkerOffset));
                startMarker.setAttribute("refY", "6");
                startMarker.setAttribute("markerWidth", "3");
                startMarker.setAttribute("markerHeight", "3");
                Element startMarkerNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "use");
                startMarkerNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#StartMarker");
                startMarker.appendChild(startMarkerNode);
                defsNode.appendChild(startMarker);
                Element endMarker = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "marker");
                String endMarkerId = relationRecord.lineIdString + "EndMarker";
                endMarker.setAttribute("id", endMarkerId);
                endMarker.setAttribute("fill", linkLine.getAttribute("stroke"));
                endMarker.setAttribute("viewBox", "0 0 10 10");
                endMarker.setAttribute("refX", Integer.toString(lineMarkerOffset + 10));
                endMarker.setAttribute("refY", "5");
                endMarker.setAttribute("markerUnits", "strokeWidth");
                endMarker.setAttribute("markerWidth", "4");
                endMarker.setAttribute("markerHeight", "3");
                endMarker.setAttribute("orient", "auto");
                Element endMarkerNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "use");
                endMarkerNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#EndMarker");
                endMarker.appendChild(endMarkerNode);
                defsNode.appendChild(endMarker);
                linkLine.setAttribute("marker-start", "url(#" + startMarkerId + ")");
                linkLine.setAttribute("marker-end", "url(#" + endMarkerId + ")");
            }
            if (relationRecord.directedRelation.equals((Object)DataTypes.RelationType.directedin)) {
                throw new UnsupportedOperationException("Directed relations should be drawn in one direction.");
            }
            defsNode.appendChild(linkLine);
            addedRelationLine = true;
            groupNode.appendChild(defsNode);
            if (addedRelationLine) {
                this.addUseNode(graphPanel.doc, graphPanel.svgNameSpace, groupNode, relationRecord.lineIdString);
            }
            relationGroupNode.appendChild(groupNode);
        }
    }

    public void updateRelationLines(GraphPanel graphPanel, RelationRecordTable relationRecords, ArrayList<UniqueIdentifier> draggedNodeIds, int hSpacing, int vSpacing) throws OldFormatException {
        if (relationRecords == null) {
            return;
        }
        relationRecords.adjustLines(graphPanel);
        Element relationGroup = graphPanel.doc.getElementById("RelationGroup");
        for (Node currentChild = relationGroup.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            RelationRecord relationRecord;
            Node idAttrubite;
            String lineElementId;
            Element relationLineElement;
            if (!"g".equals(currentChild.getLocalName()) || (relationLineElement = graphPanel.doc.getElementById(lineElementId = (idAttrubite = currentChild.getAttributes().getNamedItem("id")).getNodeValue() + "Line")) == null) continue;
            if ("polyline".equals(relationLineElement.getLocalName())) {
                relationRecord = relationRecords.getRecord(lineElementId);
                relationLineElement.setAttribute("points", relationRecord.getPathPointsString());
            }
            if ("path".equals(relationLineElement.getLocalName())) {
                relationRecord = relationRecords.getRecord(lineElementId);
                relationLineElement.setAttribute("d", relationRecord.getPathPointsString());
            }
            this.addUseNode(graphPanel.doc, graphPanel.svgNameSpace, (Element)currentChild, lineElementId);
        }
    }
}

