/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class ImportSamplesFileMenu
extends JMenu
implements ActionListener {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    private AbstractDiagramManager diagramWindowManager;
    private MessageDialogHandler dialogHandler;
    private Component parentComponent;

    public ImportSamplesFileMenu(AbstractDiagramManager diagramWindowManager, MessageDialogHandler dialogHandler, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.dialogHandler = dialogHandler;
        this.addSampleToMenu(menus.getString("GEDCOM SIMPLE FILE (SMALL SAMPLE OF THREE INDIVIDUALS)"), "/gedcomsamples/wiki-test-ged.ged");
        this.addSampleToMenu(menus.getString("GEDCOM TORTURE FILE (ONLY FOR TESTING GEDOM COMPLIANCE)"), "/TestGED/TGC55C.ged");
        this.addSampleToMenu(menus.getString("EUROPEAN ROYALTY (ROYAL92.GED)"), "/gedcomsamples/royal92.ged");
    }

    private void addSampleToMenu(String menuText, String sampleFileString) {
        JMenuItem currentMenuItem = new JMenuItem(menuText);
        currentMenuItem.setActionCommand(sampleFileString);
        currentMenuItem.addActionListener(this);
        this.add(currentMenuItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SavePanel currentSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
        try {
            if (currentSavePanel instanceof KinDiagramPanel) {
                KinDiagramPanel diagramPanel = (KinDiagramPanel)currentSavePanel;
                this.diagramWindowManager.openJarImportPanel(e.getActionCommand(), diagramPanel, diagramPanel.getEntityCollection());
            } else {
                this.dialogHandler.addMessageDialogToQueue("Cannot import into this type of window\n" + e.getActionCommand(), "Import Sample Data");
            }
        }
        catch (ImportException exception1) {
            this.dialogHandler.addMessageDialogToQueue(exception1.getMessage() + "\n" + e.getActionCommand(), "Import Sample Data");
        }
    }
}

