/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.kintypeeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.kintypeeditor.ArrayListCellRenderer;
import nl.mpi.kinnate.ui.kintypeeditor.CheckBoxRenderer;
import nl.mpi.kinnate.ui.kintypeeditor.KinTypeTableModel;

public class KinTypeDefinitions
extends JPanel {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Widgets");

    public KinTypeDefinitions(String panelName, SavePanel savePanel, DataStoreSvg dataStoreSvg) {
        this.setName(panelName);
        this.setLayout(new BorderLayout());
        JButton deleteButton = new JButton(widgets.getString("DELETE SELECTED"));
        KinTypeTableModel kinTypeTableModel = new KinTypeTableModel(savePanel, dataStoreSvg, deleteButton);
        JTable kinTypeTable = new JTable(kinTypeTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                JComponent preparedRenderer = (JComponent)super.prepareRenderer(renderer, row, column);
                if (row == this.getRowCount() - 1 && column != this.getColumnCount() - 1) {
                    preparedRenderer.setBorder(new MatteBorder(1, 1, 1, 1, Color.lightGray));
                }
                return preparedRenderer;
            }
        };
        TableColumn columnRelationType = kinTypeTable.getColumnModel().getColumn(1);
        JComboBox<Object> relationTypeComboBox = new JComboBox<Object>(kinTypeTableModel.getValueRangeAt(1).toArray());
        CheckBoxRenderer relationTypeCheckBoxRenderer = new CheckBoxRenderer(kinTypeTableModel, relationTypeComboBox);
        relationTypeComboBox.addActionListener(relationTypeCheckBoxRenderer);
        relationTypeComboBox.setRenderer(relationTypeCheckBoxRenderer);
        columnRelationType.setCellEditor(relationTypeCheckBoxRenderer);
        columnRelationType.setCellRenderer(new ArrayListCellRenderer());
        TableColumn columnSymbolType = kinTypeTable.getColumnModel().getColumn(2);
        JComboBox<Object> symbolTypeComboBox = new JComboBox<Object>(kinTypeTableModel.getValueRangeAt(2).toArray());
        CheckBoxRenderer symbolTypeCheckBoxRenderer = new CheckBoxRenderer(kinTypeTableModel, symbolTypeComboBox);
        symbolTypeComboBox.addActionListener(symbolTypeCheckBoxRenderer);
        symbolTypeComboBox.setRenderer(symbolTypeCheckBoxRenderer);
        columnSymbolType.setCellEditor(symbolTypeCheckBoxRenderer);
        columnSymbolType.setCellRenderer(new ArrayListCellRenderer());
        this.add((Component)new JScrollPane(kinTypeTable), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)deleteButton, "First");
        this.add((Component)buttonPanel, "After");
    }
}

