/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class DocumentNewMenu
extends JMenu
implements ActionListener {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    private final AbstractDiagramManager diagramWindowManager;
    private final Component parentComponent;
    private final MessageDialogHandler dialogHandler;

    public DocumentNewMenu(AbstractDiagramManager diagramWindowManager, Component parentComponent, MessageDialogHandler dialogHandler) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.dialogHandler = dialogHandler;
        for (DocumentType documentType : DocumentType.values()) {
            JMenuItem menuItem = new JMenuItem(documentType.getDisplayName());
            menuItem.setActionCommand(documentType.name());
            menuItem.addActionListener(this);
            this.add(menuItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentType documentType = DocumentType.valueOf(e.getActionCommand());
        Dimension parentSize = this.parentComponent.getSize();
        Point parentLocation = this.parentComponent.getLocation();
        int offset = 10;
        Rectangle windowRectangle = new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset);
        try {
            SavePanel savePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
            ProjectRecord projectRecord = savePanel.getGraphPanel().dataStoreSvg.projectRecord;
            this.diagramWindowManager.newDiagram(documentType, projectRecord, windowRectangle);
        }
        catch (EntityServiceException entityServiceException) {
            this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO OPEN DIAGRAM: {0}"), entityServiceException.getMessage()), "Open Diagram Error");
        }
    }

    static /* synthetic */ ResourceBundle access$000() {
        return menus;
    }

    public static enum DocumentType {
        Simple(DocumentNewMenu.access$000().getString("STANDARD DIAGRAM (CURRENT PROJECT)")),
        Freeform(DocumentNewMenu.access$000().getString("FREEFORM DIAGRAM (TRANSIENT)")),
        KinTerms(DocumentNewMenu.access$000().getString("KIN TERMS DIAGRAM (TRANSIENT)")),
        Query(DocumentNewMenu.access$000().getString("QUERY DIAGRAM (CURRENT PROJECT)")),
        ArchiveLinker(DocumentNewMenu.access$000().getString("ARCHIVE DATA LINKER (CURRENT PROJECT)"));

        private String displayName;

        private DocumentType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

