/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.corpusstructure.ArchiveAccessContext;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.ArchiveObjectsDBWrite;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.CorpusStructureDBImpl;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.corpusstructure.UpdateInProgressException;
import nl.mpi.util.Checksum;
import nl.mpi.util.DBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveObjectsDBWriteImpl
extends CorpusStructureDBImpl
implements ArchiveObjectsDB,
ArchiveObjectsDBWrite,
CorpusStructureDB {
    private static Logger logger = LoggerFactory.getLogger(ArchiveObjectsDBWriteImpl.class);
    private boolean iAmTheUpdater = false;
    private boolean updateInProgress = true;
    private static boolean useExistingNodeIds = true;
    private HashSet knownGroups = new HashSet();
    private static boolean bootstrapMode = false;
    private PreparedStatement newObjectInArchiveObjectsSTM = null;
    private PreparedStatement newObjectWithIdInArchiveObjectsSTM = null;
    private PreparedStatement updateFileInfoInArchiveObjectsSTM = null;
    private PreparedStatement selectPIDForArchiveObjectsSTM = null;
    private PreparedStatement updatePIDInArchiveObjectsSTM = null;
    private PreparedStatement moveObjectInArchiveObjectsSTM = null;
    private PreparedStatement updateAccessInfoInArchiveObjectsSTM = null;
    private PreparedStatement updateCrawlTimeInArchiveObjectsSTM = null;
    private PreparedStatement updateChecksumInArchiveObjectsSTM = null;
    private PreparedStatement deleteObjectInArchiveObjectsSTM = null;
    private PreparedStatement getIdFromOldArchiveObjectsSTM = null;

    protected boolean isBootstrapMode() {
        return bootstrapMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveObjectsDBWriteImpl(String dbname, boolean bootstrapMode, String user, String passwd) throws UpdateInProgressException {
        super(new Exception());
        Object object = staticSyncFlag;
        synchronized (object) {
            boolean myUseExistingNodeIds;
            this.db = new DBConnection(dbname, user, passwd, "CorpusStructureDBWriteImpl:constructor");
            if (this.db == null) {
                logger.error("constructor: NULL DB connection!");
                this.status = false;
                return;
            }
            if (!this.db.getStatus()) {
                logger.error("constructor: ERROR creating DB connection: " + this.db.getMessage());
                this.status = false;
                this.db.close();
                return;
            }
            this.updateInProgress = this.checkUpdateInProgressLock(bootstrapMode);
            if (bootstrapMode && this.updateInProgress) {
                logger.error("constructor: ERROR: attempt to use bootstrap mode more than once at a time");
                this.status = false;
                this.db.close();
                this.db = null;
                return;
            }
            HashSet tableNames = this.getTableNames();
            if (tableNames.contains("ARCHIVEOBJECTS")) {
                logger.info("Existing ARCHIVEOBJECTS table found, will preserve existing node IDs.");
                myUseExistingNodeIds = true;
            } else {
                logger.info("No ARCHIVEOBJECTS table found, no existing node IDs, will generate all new node IDs.");
                myUseExistingNodeIds = false;
                if (!bootstrapMode) {
                    logger.error("To create a new ARCHIVEOBJECTS table, bootstrap mode must be used");
                    this.status = false;
                    this.db.close();
                    this.db = null;
                    return;
                }
            }
            ArchiveObjectsDBWriteImpl.incrementInstance();
            this.status = this.db.getStatus();
            if (!this.status) {
                logger.error("ERROR creating DB for " + dbname);
                this.db.close();
                this.db = null;
                return;
            }
            ArchiveObjectsDBWriteImpl.setStaticParameters(myUseExistingNodeIds, dbname, bootstrapMode);
            if (bootstrapMode) {
                this.iAmTheUpdater = true;
                logger.info("dropping old temp tables, if any");
                this.setTmpTableNames();
                this.dropTmpTables();
                logger.info("creating tables and indexes");
                this.createTables();
                this.createIndexes(true);
            }
            try {
                this.initArchiveAccessRoots();
            }
            catch (MalformedURLException murle) {
                this.close();
                logger.error("Failed to init AccessRoots, expect horrible failure! " + murle, (Throwable)murle);
                throw new RuntimeException("Failed to init AccessRoots, expect horrible failure! " + murle);
            }
            logger.info("creating prepared statements");
            this.initPreparedStatements();
            if (user == null || user.equals("imdiArchive")) {
                logger.warn("Username " + user + " suggests that all write access will fail!");
            }
        }
    }

    private static synchronized void setStaticParameters(boolean myUseExistingNodeIds, String myDbName, boolean myBootstrapMode) {
        if (!myDbName.equals(ArchiveObjectsDBWriteImpl.getDbName()) && ArchiveObjectsDBWriteImpl.getDbName() != null) {
            logger.error("DB Name updated from: '" + ArchiveObjectsDBWriteImpl.getDbName() + "' to: '" + myDbName + "'");
        }
        if (myBootstrapMode != bootstrapMode) {
            logger.error((myBootstrapMode ? "Entering" : "Leaving") + " bootstrap mode!");
        }
        if (myUseExistingNodeIds != useExistingNodeIds) {
            logger.error((myUseExistingNodeIds ? "Starting" : "Stopping") + " to use existing Node IDs (as listed in ARCHIVEOBJECTS table).");
        }
        useExistingNodeIds = myUseExistingNodeIds;
        ArchiveObjectsDBWriteImpl.updateDbName(myDbName);
        bootstrapMode = myBootstrapMode;
    }

    protected List<String> getTables(boolean withGroups) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS());
        tables.add(ArchiveObjectsDBWriteImpl.getCORPUSNODES());
        tables.add(ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE());
        if (withGroups) {
            tables.add("accessgroups");
        }
        return Collections.unmodifiableList(tables);
    }

    @Override
    protected synchronized void initPreparedStatements() {
        super.initPreparedStatements();
        try {
            this.newObjectInArchiveObjectsSTM = this.db.getConnection().prepareStatement("INSERT INTO " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( " + "URL, CRAWLTIME, ONSITE, SIZE, CHECKSUM, FILETIME, READRIGHTS, WRITERIGHTS, PID, ACCESSLEVEL ) " + "VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
            this.newObjectWithIdInArchiveObjectsSTM = this.db.getConnection().prepareStatement("INSERT INTO " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( NODEID, " + "URL, CRAWLTIME, ONSITE, SIZE, CHECKSUM, FILETIME, READRIGHTS, WRITERIGHTS, PID, ACCESSLEVEL ) " + "VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
            this.updateFileInfoInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " SET SIZE = ?, FILETIME = ? WHERE NODEID = ?");
            this.updatePIDInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " SET PID = ? WHERE NODEID = ?");
            this.selectPIDForArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT PID FROM " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            this.moveObjectInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " SET URL = ? WHERE NODEID = ?");
            this.updateAccessInfoInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " SET READRIGHTS = ?, WRITERIGHTS = ?, ACCESSLEVEL = ? " + " WHERE NODEID = ? AND ((READRIGHTS <> ?) OR (WRITERIGHTS <> ?) OR (ACCESSLEVEL IS NULL OR ACCESSLEVEL <> ?))");
            this.updateCrawlTimeInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " SET CRAWLTIME = ? WHERE NODEID = ?");
            this.updateChecksumInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " SET CHECKSUM = ? WHERE NODEID = ?");
            this.deleteObjectInArchiveObjectsSTM = this.db.getConnection().prepareStatement("DELETE FROM " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " WHERE NODEID = ?");
            try {
                this.getIdFromOldArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT NODEID FROM ARCHIVEOBJECTS WHERE URL = ?");
            }
            catch (SQLException sqle) {
                logger.debug("initPreparedStatements: No ARCHIVEOBJECTS yet");
            }
        }
        catch (SQLException sqle) {
            logger.error("initPreparedStatements: SQL error: " + sqle, (Throwable)sqle);
            this.status = false;
        }
    }

    @Override
    protected synchronized void closePreparedStatements() {
        super.closePreparedStatements();
        try {
            if (this.newObjectInArchiveObjectsSTM != null) {
                this.newObjectInArchiveObjectsSTM.close();
            }
            if (this.newObjectWithIdInArchiveObjectsSTM != null) {
                this.newObjectWithIdInArchiveObjectsSTM.close();
            }
            if (this.updateFileInfoInArchiveObjectsSTM != null) {
                this.updateFileInfoInArchiveObjectsSTM.close();
            }
            if (this.updatePIDInArchiveObjectsSTM != null) {
                this.updatePIDInArchiveObjectsSTM.close();
            }
            if (this.selectPIDForArchiveObjectsSTM != null) {
                this.selectPIDForArchiveObjectsSTM.close();
            }
            if (this.moveObjectInArchiveObjectsSTM != null) {
                this.moveObjectInArchiveObjectsSTM.close();
            }
            if (this.updateAccessInfoInArchiveObjectsSTM != null) {
                this.updateAccessInfoInArchiveObjectsSTM.close();
            }
            if (this.updateCrawlTimeInArchiveObjectsSTM != null) {
                this.updateCrawlTimeInArchiveObjectsSTM.close();
            }
            if (this.updateChecksumInArchiveObjectsSTM != null) {
                this.updateChecksumInArchiveObjectsSTM.close();
            }
            if (this.deleteObjectInArchiveObjectsSTM != null) {
                this.deleteObjectInArchiveObjectsSTM.close();
            }
            if (this.getIdFromOldArchiveObjectsSTM != null) {
                this.getIdFromOldArchiveObjectsSTM.close();
            }
        }
        catch (SQLException sqle) {
            logger.error("closePreparedStatements: SQL error: " + sqle, (Throwable)sqle);
        }
        this.updateFileInfoInArchiveObjectsSTM = null;
        this.moveObjectInArchiveObjectsSTM = null;
        this.updateAccessInfoInArchiveObjectsSTM = null;
        this.updatePIDInArchiveObjectsSTM = null;
        this.selectPIDForArchiveObjectsSTM = null;
        this.updateCrawlTimeInArchiveObjectsSTM = null;
        this.updateChecksumInArchiveObjectsSTM = null;
        this.deleteObjectInArchiveObjectsSTM = null;
        this.getIdFromOldArchiveObjectsSTM = null;
    }

    private synchronized void setTmpTableNames() {
        if (ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS().startsWith("TMP")) {
            logger.error("Duplicate setTmpTableNames call!");
            this.panic("setTmpTableNames TWICE");
        }
        ArchiveObjectsDBWriteImpl.setARCHIVEOBJECTS("TMP" + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS());
        ArchiveObjectsDBWriteImpl.setCORPUSNODES("TMP" + ArchiveObjectsDBWriteImpl.getCORPUSNODES());
        ArchiveObjectsDBWriteImpl.setCORPUSSTRUCTURE("TMP" + ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE());
    }

    private synchronized void unsetTmpTableNames() {
        if (!ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS().startsWith("TMP")) {
            logger.error("Duplicate unsetTmpTableNames call!");
            this.panic("unsetTmpTableNames TWICE");
        }
        ArchiveObjectsDBWriteImpl.setARCHIVEOBJECTS(ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS().substring(3));
        ArchiveObjectsDBWriteImpl.setCORPUSNODES(ArchiveObjectsDBWriteImpl.getCORPUSNODES().substring(3));
        ArchiveObjectsDBWriteImpl.setCORPUSSTRUCTURE(ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE().substring(3));
        logger.info("unsetTmpTableNames: Re-preparing all prepared statements");
        this.closePreparedStatements();
        this.initPreparedStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTables() throws UpdateInProgressException {
        if (!this.statusLog("createTables")) {
            return false;
        }
        long lastIssuedNodeIdInExistingTable = -1L;
        if (useExistingNodeIds && (lastIssuedNodeIdInExistingTable = this.getLastIssuedNodeIdInExistingTable()) == -1L) {
            useExistingNodeIds = false;
            logger.error("createTables: could not determine highest existing node id, disabled useExistingNodeIds again");
        }
        long startNodeId = lastIssuedNodeIdInExistingTable + 1L;
        String[] tableCreateCmd = new String[this.getTables(true).size()];
        String primaryKey = "";
        if (this.db.dbType == 2) {
            primaryKey = " PRIMARY KEY";
        }
        String varcharType = "VARCHAR";
        if (this.db.dbType == 2) {
            varcharType = "VARCHAR(1024)";
        }
        if (this.db.dbType == 1) {
            primaryKey = "";
            tableCreateCmd[0] = "CREATE " + this.db.tableType + " TABLE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( " + "NODEID INTEGER DEFAULT NEXTVAL('" + "NODEID_SEQ" + "')" + primaryKey + ", ";
        } else {
            tableCreateCmd[0] = "CREATE " + this.db.tableType + " TABLE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + "( " + "NODEID INTEGER GENERATED BY DEFAULT AS " + "IDENTITY (START WITH " + startNodeId + ")" + primaryKey + ", ";
        }
        tableCreateCmd[0] = tableCreateCmd[0] + "URL " + varcharType + " NOT NULL, " + "CRAWLTIME TIMESTAMP NOT NULL, " + "ONSITE BOOLEAN DEFAULT TRUE, " + "SIZE BIGINT, " + "CHECKSUM " + varcharType + ", " + "FILETIME TIMESTAMP, " + "READRIGHTS " + varcharType + " NOT NULL, " + "WRITERIGHTS " + varcharType + " NOT NULL, " + "PID " + varcharType + ", " + "ACCESSLEVEL INTEGER) ";
        tableCreateCmd[1] = "CREATE " + this.db.tableType + " TABLE " + ArchiveObjectsDBWriteImpl.getCORPUSNODES() + "( " + "NODEID INTEGER" + primaryKey + ", " + "NODETYPE INTEGER NOT NULL, " + "FORMAT " + varcharType + " , " + "NAME " + varcharType + " , " + "TITLE " + varcharType + " " + " )";
        tableCreateCmd[2] = "CREATE " + this.db.tableType + " TABLE " + ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE() + "( " + "NODEID INTEGER NOT NULL, " + "CANONICAL BOOLEAN DEFAULT FALSE, " + "VALID BOOLEAN DEFAULT TRUE, ";
        for (int i = 0; i < 3; ++i) {
            tableCreateCmd[2] = tableCreateCmd[2] + "VPATH" + i + " INTEGER DEFAULT NULL, ";
        }
        tableCreateCmd[2] = tableCreateCmd[2] + "VPATH " + varcharType + " " + ")";
        tableCreateCmd[3] = "CREATE " + this.db.tableType + " TABLE " + "accessgroups" + "( " + "MD5 " + varcharType + " NOT NULL PRIMARY KEY, ACLSTRING " + varcharType + " NOT NULL )";
        Statement statement = null;
        try {
            statement = this.db.getConnection().createStatement();
            if (this.db.dbType == 1 && !useExistingNodeIds) {
                try {
                    statement.execute("CREATE SEQUENCE NODEID_SEQ MINVALUE 0 START " + startNodeId);
                    logger.info("createTables: created new sequenceNODEID_SEQ, start value: " + startNodeId);
                }
                catch (SQLException sqle) {
                    logger.warn("createTables: tried to create new sequence but failed, error: " + sqle);
                }
            }
            int i = 0;
            for (String table : this.getTables(true)) {
                try {
                    logger.debug("## createTables: Executing" + i + ": " + tableCreateCmd[i]);
                    statement.execute(tableCreateCmd[i]);
                    statement.execute("GRANT SELECT ON " + table + " TO PUBLIC");
                    logger.debug("createTables: Created table: " + table);
                }
                catch (SQLException sqle) {
                    logger.error("createTables: Error creating table: " + table + " error: " + sqle);
                    this.status = false;
                }
                ++i;
            }
            statement.execute("INSERT INTO accessgroups (MD5, ACLSTRING) VALUES ('nobody', 'nobody' )");
            statement.execute("INSERT INTO accessgroups (MD5, ACLSTRING) VALUES ('cleared', 'cleared' )");
            statement.execute("INSERT INTO accessgroups (MD5, ACLSTRING) VALUES ('everybody', 'everybody' )");
            statement.execute("INSERT INTO accessgroups (MD5, ACLSTRING) VALUES ('anyAuthenticatedUser', 'anyAuthenticatedUser' )");
            logger.debug("createTables: stored identity mapping for AccessInfo constants in accessgroups");
        }
        catch (SQLException sqle) {
            logger.error("createTables: unexpected SQL error: " + sqle, (Throwable)sqle);
            this.status = false;
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.warn("createTables: close statement failed: " + sqle);
                }
            }
            statement = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropOldTables() {
        if (!this.statusLog("dropOldTables")) {
            return false;
        }
        HashSet tableNames = this.getTableNames();
        Statement statement = null;
        try {
            statement = this.db.getConnection().createStatement();
            for (String name : this.getTables(false)) {
                if (name.startsWith("TMP")) {
                    name = name.substring(3);
                }
                if (tableNames != null && tableNames.contains(name)) {
                    try {
                        statement.execute("DROP TABLE " + name);
                        logger.debug("dropOldTables: dropped table: " + name);
                    }
                    catch (SQLException sqle) {
                        logger.error("dropOldTables: Error dropping table: " + name + ", SQL exception: " + sqle);
                    }
                    continue;
                }
                logger.warn("dropOldTables: table not dropped as it did not exist anyway: " + name);
            }
        }
        catch (SQLException sqle) {
            logger.error("dropOldTables: unexpected SQL exception: " + sqle, (Throwable)sqle);
            this.status = false;
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.warn("dropOldTables: close statement failed: " + sqle);
                }
            }
            statement = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyOldArchiveObjects() {
        if (!this.statusLog("copyOldArchiveObjects")) {
            return;
        }
        HashSet tableNames = this.getTableNames();
        Statement statement = null;
        String command = "INSERT INTO TMPARCHIVEOBJECTS ( nodeid, url, crawltime, onsite, size, checksum, filetime, readrights, writerights ) SELECT nodeid, url, crawltime, onsite, size, checksum, filetime, readrights, writerights FROM ARCHIVEOBJECTS WHERE NOT nodeid IN ( SELECT nodeid FROM TMPARCHIVEOBJECTS )";
        int updatedRows = 0;
        try {
            statement = this.db.getConnection().createStatement();
            if (tableNames != null && tableNames.contains("ARCHIVEOBJECTS")) {
                logger.info("copyOldArchiveObjects: will copy data from archiveobjects to tmparchiveobjects");
                updatedRows = statement.executeUpdate(command);
                if (updatedRows == 0) {
                    logger.info("copyOldArchiveObjects: Old archiveobjects table did not contain any information about objects other than those touched in the current crawler run!");
                } else {
                    logger.info("copyOldArchiveObjects: preserved data about " + updatedRows + " objects from old archiveobjects table (current crawler run did not touch those).");
                }
            } else {
                logger.info("No previous version of ARCHIVEOBJECTS table found, cannot copy data about old objects!");
            }
        }
        catch (SQLException sqle) {
            logger.error("copyOldArchiveObjects: SQL exception: " + sqle + " command: " + command);
            this.status = false;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.warn("copyOldArchiveObjects: close statement failed: " + sqle);
                }
            }
            statement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteArchiveObjectsTable(int key) {
        if (!this.statusLog("deleteArchiveObjectsTable")) {
            return;
        }
        if (key != 42) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.db.getConnection().createStatement();
            try {
                statement.execute("DROP TABLE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS());
                logger.info("deleteArchiveObjectsTable: dropped table: " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS());
            }
            catch (SQLException sqle) {
                logger.error("deleteArchiveObjectsTable: could not drop table " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " error: " + sqle);
            }
            if (this.db.dbType == 1) {
                try {
                    statement.execute("DROP SEQUENCE NODEID_SEQ");
                    logger.info("deleteArchiveObjectsTable: dropped sequence: NODEID_SEQ");
                }
                catch (SQLException sqle) {
                    logger.error("deleteArchiveObjectsTable: could not drop sequence NODEID_SEQ error: " + sqle);
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("deleteArchiveObjectsTable: unexpected SQL error: " + sqle, (Throwable)sqle);
            this.status = false;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.warn("deleteArchiveObjectsTable: close statement failed: " + sqle);
                }
            }
            statement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTmpTables() {
        if (!this.statusLog("dropTmpTables")) {
            return;
        }
        HashSet tableNames = this.getTableNames();
        Statement statement = null;
        try {
            statement = this.db.getConnection().createStatement();
            logger.info("dropTmpTables: dropping tmp tables");
            for (String name : this.getTables(false)) {
                if (!name.startsWith("TMP")) {
                    name = "TMP" + name;
                }
                if (tableNames != null && tableNames.contains(name)) {
                    try {
                        statement.execute("DROP TABLE " + name);
                        logger.debug("dropTmpTables: old tmp table dropped: " + name);
                    }
                    catch (SQLException sqle) {
                        logger.error("dropTmpTables: error dropping table: " + name + " SQL error: " + sqle);
                    }
                    continue;
                }
                logger.debug("dropTmpTables: table did not exist: " + name);
            }
        }
        catch (SQLException sqle) {
            logger.error("dropTmpTables: unexpected SQL error: " + sqle, (Throwable)sqle);
            this.status = false;
            return;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.warn("dropTmpTables: close statement failed: " + sqle);
                }
            }
            statement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexes(boolean temp) {
        Statement statement = null;
        logger.info("createIndexes: " + (temp ? "temp" : "final"));
        try {
            statement = this.db.getConnection().createStatement();
            if (this.db.dbType == 1) {
                if (temp) {
                    statement.execute("CREATE UNIQUE INDEX BOOTSTRAP_NODEID_AO_IDX ON " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( NODEID )");
                    statement.execute("CREATE UNIQUE INDEX BOOTSTRAP_NODEID_CN_IDX ON " + ArchiveObjectsDBWriteImpl.getCORPUSNODES() + " ( NODEID )");
                } else {
                    statement.execute("ALTER TABLE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ADD CONSTRAINT " + "PK_" + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " PRIMARY KEY (NODEID)");
                    statement.execute("ALTER TABLE " + ArchiveObjectsDBWriteImpl.getCORPUSNODES() + " ADD CONSTRAINT " + "PK_" + ArchiveObjectsDBWriteImpl.getCORPUSNODES() + " PRIMARY KEY (NODEID)");
                }
            }
            statement.execute("CREATE UNIQUE INDEX " + (temp ? "BOOTSTRAP_" : "") + "URL_AO_IDX ON " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( URL )");
            statement.execute("CREATE INDEX " + (temp ? "BOOTSTRAP_" : "") + "PID_AO_IDX ON " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( PID )");
            if (!temp) {
                statement.execute("CREATE INDEX CRAWLTIME_AO_IDX ON " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( CRAWLTIME )");
                statement.execute("CREATE INDEX FILETIME_AO_IDX ON " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( FILETIME )");
                statement.execute("CREATE INDEX CHECKSUM_AO_IDX ON " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( CHECKSUM )");
                statement.execute("CREATE INDEX READRIGHTS_AO_IDX ON " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ( READRIGHTS )");
            }
            statement.execute("CREATE INDEX " + (temp ? "BOOTSTRAP_" : "") + "NODEID_CS_IDX ON " + ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE() + " ( NODEID )");
            statement.execute("CREATE INDEX " + (temp ? "BOOTSTRAP_" : "") + "VPATH_CS_IDX ON " + ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE() + " ( VPATH )");
            if (this.db.dbType == 1) {
                statement.execute("CREATE INDEX " + (temp ? "BOOTSTRAP_" : "") + "VPATH_CS_IDX_LIKE ON " + ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE() + " ( VPATH varchar_pattern_ops )");
            }
            for (int i = 0; i < 3; ++i) {
                if (temp) continue;
                statement.execute("CREATE INDEX VPATH" + i + "_CS_IDX ON " + ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE() + " ( VPATH" + i + " )");
            }
            if (!temp) {
                statement.execute("CREATE INDEX NODETYPE_CN_IDX ON " + ArchiveObjectsDBWriteImpl.getCORPUSNODES() + " ( NODETYPE )");
                statement.execute("CREATE INDEX FORMAT_CN_IDX ON " + ArchiveObjectsDBWriteImpl.getCORPUSNODES() + " ( FORMAT )");
            }
            if (this.db.dbType == 1 && !temp) {
                statement.execute("VACUUM ANALYZE " + ArchiveObjectsDBWriteImpl.getCORPUSNODES());
                statement.execute("VACUUM ANALYZE " + ArchiveObjectsDBWriteImpl.getCORPUSSTRUCTURE());
                statement.execute("VACUUM ANALYZE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS());
                this.closePreparedStatements();
                this.initPreparedStatements();
            }
            logger.info("createIndexes: done");
        }
        catch (SQLException sqle) {
            logger.error("createIndexes: Unexpected Error creating indexes: " + sqle, (Throwable)sqle);
            this.status = false;
        }
        catch (Exception e) {
            logger.error("createIndexes: Unexpected Error creating indexes: " + e, (Throwable)e);
            this.status = false;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.error("createIndexes: Failed to close statement: " + sqle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameTmpTables() {
        Statement statement = null;
        try {
            statement = this.db.getConnection().createStatement();
            logger.info("renameTmpTables: dropping temp indexes");
            try {
                statement.execute("DROP INDEX BOOTSTRAP_NODEID_AO_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_NODEID_CN_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_URL_AO_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_NODEID_CS_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_VPATH_CS_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_VPATH_CS_IDX_LIKE");
                statement.execute("DROP INDEX BOOTSTRAP_PID_AO_IDX");
            }
            catch (SQLException sqle) {
                logger.error("renameTmpTables: SQL error dropping temp index: " + sqle);
            }
            logger.info("renameTmpTables: renaming tables");
            for (String name : this.getTables(false)) {
                try {
                    statement.execute("ALTER TABLE " + name + " RENAME TO " + name.substring(3));
                    logger.debug("renameTmpTables:renamed table " + name + " to " + name.substring(3));
                }
                catch (SQLException sqle) {
                    logger.error("renameTmpTables:Error renaming table " + name + " SQL error: " + sqle);
                }
            }
            logger.info("renameTmpTables: renamed tables");
        }
        catch (SQLException sqle) {
            logger.error("renameTmpTables: Unexpected Error renaming tables and indexes: " + sqle);
        }
        catch (Exception e) {
            logger.error("renameTmpTables: Unexpected Error dropping tables and indexes: " + e, (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.error("renameTmpTables: Failed to close statement: " + sqle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getTableNames() {
        ResultSet rs = null;
        HashSet<String> results = new HashSet<String>();
        try {
            Object tableType;
            DatabaseMetaData md = this.db.getConnection().getMetaData();
            rs = md.getTables(null, null, null, null);
            while (rs.next()) {
                String name;
                tableType = rs.getString("TABLE_TYPE");
                if (!"TABLE".equals(tableType) || (name = rs.getString("TABLE_NAME")) == null) continue;
                results.add(name.toUpperCase());
            }
            tableType = results;
            return tableType;
        }
        catch (SQLException sqle) {
            logger.error("getTableNames: SQL exception: " + sqle, (Throwable)sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    logger.warn("getTableNames: close resultset failed: " + sqle);
                }
            }
            Object md = null;
            rs = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeUpdateInProgressLock() {
        Statement stat = null;
        int n = 0;
        if (this.db == null || !this.db.getStatus()) {
            logger.info("freeUpdateInProgressLock: db already closed correctly");
            return;
        }
        try {
            stat = this.db.getConnection().createStatement();
            try {
                n = stat.executeUpdate("UPDATE IMDIADMIN SET VALUE = 'FALSE' WHERE NAME = 'UPDATEINPROGRESS'");
            }
            catch (SQLException sqle) {
                logger.error("freeUpdateInProgressLock: SQLException: " + sqle);
            }
            if (n != 1) {
                logger.error("freeUpdateInProgressLock: ERROR freeing lock, record not found");
            }
        }
        catch (SQLException sqle) {
            logger.error("freeUpdateInProgressLock: unexpected error: " + sqle, (Throwable)sqle);
            this.status = false;
        }
        finally {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException sqle) {
                    logger.warn("freeUpdateInProgressLock: close statement failed: " + sqle);
                }
            }
            stat = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSequencePosition() throws UpdateInProgressException {
        logger.debug("resetSequencePosition: Scanning handles for highest node id...");
        String ownPrefix = this.getArchiveRoots().getHandlePrefix();
        long maxNodeIdFromHandles = this.getMaxNodeIdFromHandle(ownPrefix) + 1L;
        logger.debug("max nodeid from reversed handles: {}", (Object)maxNodeIdFromHandles);
        logger.debug("resetSequencePosition: Scanning archiveobjects for highest node id...");
        long maxDbIndex = this.getLastIssuedNodeIdInExistingTable() + 1L;
        logger.debug("max nodeid from archiveobjects: {}", (Object)maxDbIndex);
        long nextIndex = Math.max(maxDbIndex, maxNodeIdFromHandles);
        logger.debug("Using max index = {}", (Object)nextIndex);
        if (nextIndex <= 1L) {
            logger.error("resetSequencePosition: NOT setting position to " + nextIndex + " (too small)");
            return;
        }
        Statement statement = null;
        try {
            statement = this.db.getConnection().createStatement();
            if (this.db.dbType == 1) {
                statement.execute("ALTER SEQUENCE NODEID_SEQ RESTART WITH " + nextIndex);
            } else {
                statement.execute("ALTER TABLE " + ArchiveObjectsDBWriteImpl.getARCHIVEOBJECTS() + " ALTER COLUMN NODEID RESTART WITH " + nextIndex);
            }
            logger.debug("resetSequencePosition: Reset position to: {}.", (Object)nextIndex);
        }
        catch (SQLException sqle) {
            logger.error("resetSequencePosition: Unexpected Error setting position to" + nextIndex + ".", (Throwable)sqle);
        }
        catch (Exception e) {
            logger.error("resetSequencePosition: Unexpected Error setting position to " + nextIndex + ".", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.error("renameTmpTables: Failed to close statement: " + sqle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishUpdate() throws UpdateInProgressException {
        if (!this.statusLog("finishUpdate")) {
            return;
        }
        logger.debug("finishUpdate called");
        Object object = staticSyncFlag;
        synchronized (object) {
            if (!bootstrapMode) {
                logger.info("finishUpdate is only needed to leave bootstrap mode");
                return;
            }
            try {
                ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(CorpusStructureDBImpl.getDbName());
                logger.info("finishUpdate: dropping old DB objects");
                this.copyOldArchiveObjects();
                this.dropOldTables();
                logger.info("finishUpdate: renaming tables");
                this.renameTmpTables();
                this.unsetTmpTableNames();
                logger.info("finishUpdate: calling createIndexes - this may take a while");
                this.createIndexes(false);
                this.resetSequencePosition();
                logger.info("finishUpdate: storing setup parameters in imdiadmin table");
                int context = 1;
                String propName = ArchiveAccessContext.getPropName(context);
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 2;
                propName = ArchiveAccessContext.getPropName(context);
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 3;
                propName = ArchiveAccessContext.getPropName(context);
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 4;
                propName = ArchiveAccessContext.getPropName(context);
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 5;
                propName = ArchiveAccessContext.getPropName(context);
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 6;
                propName = ArchiveAccessContext.getPropName(context);
                this.insertAdminKey(propName, aac.getRoot(context));
            }
            finally {
                bootstrapMode = false;
                this.freeUpdateInProgressLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        logger.info("shutdown called");
        if (this.db == null) {
            logger.info("DB already closed");
            return;
        }
        Object object = staticSyncFlag;
        synchronized (object) {
            if (this.db.dbType == 2) {
                logger.debug("CorpusStructureDBWriteImpl instance " + ArchiveObjectsDBWriteImpl.getInstance() + " shutdown");
                Statement statement = null;
                try {
                    statement = this.db.getConnection().createStatement();
                    statement.execute("SHUTDOWN COMPACT");
                }
                catch (SQLException sqle) {
                    if (sqle.toString().indexOf("is shutdown") != -1) {
                        logger.info("database already shutdown");
                    } else {
                        logger.error("shutdown: SQLException: " + sqle, (Throwable)sqle);
                    }
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle) {
                            logger.warn("shutdown: close statement failed: " + sqle);
                        }
                    }
                    statement = null;
                }
            }
        }
        this.close();
    }

    public void setSearchServletURL(String str) {
        this.insertAdminKey("MDSearchServletURL", str);
    }

    @Override
    public boolean canWrite() {
        return this.statusLog("canWrite");
    }

    @Override
    public String newArchiveObject(String name, URI uri, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo, String checksum) throws UpdateInProgressException, UnknownNodeException {
        return this.newArchiveObject(name, uri, null, crawltime, onsite, size, filetime, ainfo, checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String newArchiveObject(String name, URI uri, String pid, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo, String checksum) throws UpdateInProgressException, UnknownNodeException {
        String urlstr = uri.toString();
        if (!this.statusLog("newArchiveObject")) {
            return null;
        }
        this.checkWriteAccess();
        Statement statement = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String nodeId = null;
        int base = 0;
        String cmd2 = null;
        String nodeIdStr = null;
        if (urlstr.indexOf("///") != -1) {
            urlstr = urlstr.replaceFirst("///", "/");
        }
        urlstr = urlstr.replace("%20", " ");
        String formattedPid = null;
        if (pid != null) {
            formattedPid = NodeIdUtils.formatPIDForStorage(pid, this.getArchiveRoots().getHandlePrefix());
        }
        if (useExistingNodeIds) {
            nodeId = this.getOldObjectId(uri, 3);
        }
        if (name != null && nodeId != null) {
            logger.error("newArchiveObject: Tried to assign NodeId " + name + " but URL already had nodeId " + nodeId + ": " + urlstr);
            return nodeId;
        }
        if (name != null) {
            nodeId = name;
        }
        if (nodeId != null) {
            if (!NodeIdUtils.isNodeId(nodeId)) {
                logger.error("newArchiveObject: invalid NodeId: " + nodeId);
                return null;
            }
            ps = this.newObjectWithIdInArchiveObjectsSTM;
            base = 1;
            cmd2 = null;
        } else {
            ps = this.newObjectInArchiveObjectsSTM;
            base = 0;
            cmd2 = this.db.dbType == 1 ? " SELECT CURRVAL('NODEID_SEQ')" : " CALL IDENTITY() ";
        }
        try {
            String decoded = URLDecoder.decode(urlstr, "UTF-8");
            if (!decoded.equals(urlstr)) {
                urlstr = decoded;
            }
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("newArchiveObject: This Java version does not support UTF-8??");
        }
        PreparedStatement preparedStatement = ps;
        synchronized (preparedStatement) {
            try {
                String readEnc;
                statement = this.db.getConnection().createStatement();
                ps.clearParameters();
                if (base == 1) {
                    ps.setInt(1, NodeIdUtils.TOINT(nodeId));
                }
                ps.setString(base + 1, urlstr);
                ps.setTimestamp(base + 2, crawltime);
                ps.setBoolean(base + 3, onsite);
                ps.setLong(base + 4, size);
                ps.setString(base + 5, checksum);
                ps.setTimestamp(base + 6, filetime);
                if (ainfo != null) {
                    readEnc = this.encodeRights(ainfo.getReadRights());
                    String writeEnc = this.encodeRights(ainfo.getWriteRights());
                    ps.setString(base + 7, readEnc);
                    ps.setString(base + 8, writeEnc);
                } else {
                    ps.setNull(base + 7, 12);
                    ps.setNull(base + 8, 12);
                }
                ps.setString(base + 9, formattedPid);
                ps.setInt(base + 10, ainfo != null ? ainfo.getAccessLevel() : -1);
                if (ps.executeUpdate() != 1) {
                    logger.error("newArchiveObject: INSERT failed");
                }
                if (cmd2 != null) {
                    rs = statement.executeQuery(cmd2);
                    while (rs.next()) {
                        nodeIdStr = NodeIdUtils.TONODEID(rs.getInt(1));
                    }
                } else {
                    nodeIdStr = nodeId;
                }
                readEnc = nodeIdStr;
                return readEnc;
            }
            catch (SQLException sqle) {
                logger.error("newArchiveObject: SQLException: " + sqle + " for " + "existing nodeId=" + nodeId + ", sequenceCommand=" + cmd2, (Throwable)sqle);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle) {
                        logger.warn("newArchiveObject: close statement failed: " + sqle);
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle) {
                        logger.warn("newArchiveObject: close resultset failed: " + sqle);
                    }
                }
                rs = null;
            }
            return null;
        }
    }

    @Override
    public String newArchiveObject(URI uri, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo) throws UpdateInProgressException, UnknownNodeException {
        return this.newArchiveObject(uri, null, crawltime, onsite, size, filetime, ainfo);
    }

    @Override
    public String newArchiveObject(URI uri, String pid, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo) throws UpdateInProgressException, UnknownNodeException {
        String checksum = null;
        return this.newArchiveObject(null, uri, pid, crawltime, onsite, size, filetime, ainfo, checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean deleteArchiveObject(String id) throws UpdateInProgressException, UnknownNodeException {
        if (!this.statusLog("deleteArchiveObject")) {
            return false;
        }
        if (bootstrapMode) {
            this.panic("deleteArchiveObject");
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.error("deleteArchiveObject: invalid NodeId: " + id);
            return false;
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.deleteObjectInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.deleteObjectInArchiveObjectsSTM.clearParameters();
                this.deleteObjectInArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                n = this.deleteObjectInArchiveObjectsSTM.executeUpdate();
            }
            if (n > 0) {
                logger.debug("deleteArchiveObject: Deleted from main DB: " + id);
            }
            if (n == 0) {
                this.throwUnknownObjectException("deleteArchiveObject", "", id);
            }
            return true;
        }
        catch (SQLException sqle) {
            logger.error("deleteArchiveObject: " + sqle, (Throwable)sqle);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArchiveObjectFileInfo(String nodeId, long filesize, Timestamp filetime) throws UpdateInProgressException, UnknownNodeException {
        if (!this.statusLog("setArchiveObjectFileInfo")) {
            return;
        }
        if (bootstrapMode) {
            this.panic("setArchiveObjectFileInfo");
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error("setArchiveObjectFileInfo: invalid NodeId: " + nodeId);
            return;
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.updateFileInfoInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.updateFileInfoInArchiveObjectsSTM.clearParameters();
                this.updateFileInfoInArchiveObjectsSTM.setLong(1, filesize);
                this.updateFileInfoInArchiveObjectsSTM.setTimestamp(2, filetime);
                this.updateFileInfoInArchiveObjectsSTM.setInt(3, NodeIdUtils.TOINT(nodeId));
                n = this.updateFileInfoInArchiveObjectsSTM.executeUpdate();
            }
            if (n == 0) {
                logger.warn("setArchiveObjectFileInfo: nothing updated: " + nodeId);
            }
        }
        catch (SQLException sqle) {
            logger.error("setArchiveObjectFileInfo: SQLException: " + sqle, (Throwable)sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean setArchiveObjectPid(String nodeId, String pid) throws UpdateInProgressException, UnknownNodeException {
        boolean result;
        block30: {
            logger.trace("setArchiveObjectPid: NodeId: " + nodeId + ",PID=" + pid);
            result = false;
            if (!this.statusLog("setArchiveObjectPid")) {
                return result;
            }
            this.checkWriteAccess();
            if (!NodeIdUtils.isNodeId(nodeId)) {
                logger.error("setArchiveObjectPid: invalid NodeId: " + nodeId);
                return result;
            }
            ResultSet rs = null;
            String pidFromAoDb = null;
            try {
                boolean hasPIDAlready = true;
                PreparedStatement preparedStatement = this.selectPIDForArchiveObjectsSTM;
                synchronized (preparedStatement) {
                    this.selectPIDForArchiveObjectsSTM.clearParameters();
                    this.selectPIDForArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                    rs = this.selectPIDForArchiveObjectsSTM.executeQuery();
                    if (rs != null) {
                        hasPIDAlready = rs.next() ? (pidFromAoDb = rs.getString("PID")) != null && pidFromAoDb.length() > 0 : false;
                        rs.close();
                    } else {
                        hasPIDAlready = false;
                    }
                }
                if (!hasPIDAlready && pid != null) {
                    String formattedPid = NodeIdUtils.formatPIDForStorage(pid, this.getArchiveRoots().getHandlePrefix());
                    PreparedStatement preparedStatement2 = this.updatePIDInArchiveObjectsSTM;
                    synchronized (preparedStatement2) {
                        this.updatePIDInArchiveObjectsSTM.clearParameters();
                        this.updatePIDInArchiveObjectsSTM.setString(1, formattedPid);
                        this.updatePIDInArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(nodeId));
                        if (this.updatePIDInArchiveObjectsSTM.executeUpdate() == 0) {
                            logger.warn("setArchiveObjectPid: nothing updated: " + nodeId);
                        } else {
                            result = true;
                        }
                        break block30;
                    }
                }
                if (!NodeIdUtils.arePIDsEqual(pid, pidFromAoDb)) {
                    if (pid == null && pidFromAoDb == null) {
                    } else if (pid == null) {
                        logger.warn("setArchiveObjectPid: nothing updated. The archiveobject with nodeid=" + nodeId + " already has a PID[" + pidFromAoDb + "]. PID removal rejected.");
                    } else {
                        logger.trace("setArchiveObjectPid: nothing updated. The archiveobject with nodeid=" + nodeId + " already has a PID[" + pidFromAoDb + "]. Update with PID[" + pid + "] rejected.");
                    }
                }
            }
            catch (SQLException sqle) {
                logger.error("setArchiveObjectPid: SQLException: " + sqle, (Throwable)sqle);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    logger.warn("setArchiveObjectPid: close resultset failed: " + e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectCrawlTime(String id, Timestamp whence) throws UpdateInProgressException, UnknownNodeException {
        if (!this.statusLog("updateObjectTimestamp")) {
            return;
        }
        if (bootstrapMode) {
            this.panic("updateObjectAccessInfo");
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.warn("setObjectCrawlTime: invalid NodeId: " + id);
            this.throwUnknownObjectException("setObjectCrawlTime", "", id);
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.updateCrawlTimeInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.updateCrawlTimeInArchiveObjectsSTM.clearParameters();
                this.updateCrawlTimeInArchiveObjectsSTM.setTimestamp(1, whence);
                this.updateCrawlTimeInArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                n = this.updateCrawlTimeInArchiveObjectsSTM.executeUpdate();
            }
            if (n == 0) {
                this.throwUnknownObjectException("updateObjectTimestamp", "", id);
            }
            return;
        }
        catch (SQLException sqle) {
            logger.error("updateObjectTimestamp: SQL exception: " + sqle, (Throwable)sqle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveArchiveObject(String id, URI newUri) throws UpdateInProgressException, UnknownNodeException {
        String urlstr;
        if (!this.statusLog("moveArchiveObject")) {
            return false;
        }
        if (bootstrapMode) {
            this.panic("moveArchiveObject");
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.warn("moveArchiveObject: invalid NodeId: " + id);
            this.throwUnknownObjectException("moveArchiveObject", "", id);
        }
        if ((urlstr = newUri.toString()).indexOf("///") != -1) {
            urlstr = urlstr.replaceFirst("///", "/");
        }
        urlstr = urlstr.replace("%20", " ");
        if (useExistingNodeIds) {
            ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(CorpusStructureDBImpl.getDbName());
            String oldId = null;
            try {
                oldId = this.getOldObjectId(aac.stringToURI(urlstr), 3);
            }
            catch (URISyntaxException use) {
                logger.warn("moveArchiveObject: invalid URI: " + urlstr);
                return false;
            }
            if (id.equals(oldId)) {
                logger.info("moveArchiveObject: zero distance move of " + id + " at: " + urlstr);
                return true;
            }
            if (oldId != null) {
                logger.warn("moveArchiveObject: COLLISION tried to change URI for " + id + " to URI of " + oldId);
                return false;
            }
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.moveObjectInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.moveObjectInArchiveObjectsSTM.clearParameters();
                this.moveObjectInArchiveObjectsSTM.setString(1, urlstr);
                this.moveObjectInArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                n = this.moveObjectInArchiveObjectsSTM.executeUpdate();
            }
            if (n == 0) {
                this.throwUnknownObjectException("moveArchiveObject", "", id);
            }
            return true;
        }
        catch (SQLException sqle) {
            logger.error("moveArchiveObject: SQL exception: " + sqle, (Throwable)sqle);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectAccessInfo(String id, AccessInfo ainfo) throws UpdateInProgressException, UnknownNodeException {
        if (!this.statusLog("setObjectAccessInfo")) {
            return;
        }
        if (bootstrapMode) {
            this.panic("setObjectAccessInfo");
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.warn("setObjectAccessInfo: invalid NodeId: " + id);
            this.throwUnknownObjectException("setObjectAccessInfo", "", id);
        }
        String readEnc = this.encodeRights(ainfo.getReadRights());
        String writeEnc = this.encodeRights(ainfo.getWriteRights());
        int accessLevel = ainfo.getAccessLevel();
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.updateAccessInfoInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.updateAccessInfoInArchiveObjectsSTM.clearParameters();
                this.updateAccessInfoInArchiveObjectsSTM.setString(1, readEnc);
                this.updateAccessInfoInArchiveObjectsSTM.setString(2, writeEnc);
                this.updateAccessInfoInArchiveObjectsSTM.setInt(3, accessLevel);
                this.updateAccessInfoInArchiveObjectsSTM.setInt(4, NodeIdUtils.TOINT(id));
                this.updateAccessInfoInArchiveObjectsSTM.setString(5, readEnc);
                this.updateAccessInfoInArchiveObjectsSTM.setString(6, writeEnc);
                this.updateAccessInfoInArchiveObjectsSTM.setInt(7, accessLevel);
                n = this.updateAccessInfoInArchiveObjectsSTM.executeUpdate();
            }
            return;
        }
        catch (SQLException sqle) {
            logger.error("setObjectAccessInfo: SQL exception: " + sqle, (Throwable)sqle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectChecksum(String id, String checksum) throws UpdateInProgressException, UnknownNodeException {
        if (!this.statusLog("setObjectChecksum")) {
            return;
        }
        if (bootstrapMode) {
            this.panic("setObjectChecksum");
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.warn("setObjectChecksum: invalid NodeId: " + id);
            this.throwUnknownObjectException("setObjectChecksum", "", id);
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.updateChecksumInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.updateChecksumInArchiveObjectsSTM.clearParameters();
                this.updateChecksumInArchiveObjectsSTM.setString(1, checksum);
                this.updateChecksumInArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                n = this.updateChecksumInArchiveObjectsSTM.executeUpdate();
            }
            if (n == 0) {
                this.throwUnknownObjectException("setObjectChecksum", "", id);
            }
            return;
        }
        catch (SQLException sqle) {
            logger.error("setObjectChecksum: SQL exception: " + sqle, (Throwable)sqle);
            return;
        }
    }

    private void panic(String whatHappened) {
        logger.error(whatHappened + " - NOT ALLOWED IN BOOTSTRAP MODE!");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastIssuedNodeIdInExistingTable() throws UpdateInProgressException {
        if (!this.statusLog("getLastIssuedNodeIdInExistingTable")) {
            return -1L;
        }
        this.checkWriteAccess();
        Statement statement = null;
        ResultSet rs = null;
        String cmd = "SELECT MAX(NODEID) FROM ARCHIVEOBJECTS";
        try {
            statement = this.db.getConnection().createStatement();
            rs = statement.executeQuery(cmd);
            if (rs.next()) {
                logger.debug("### getLastIssuedNodeIdInExistingTable: ->" + rs.getLong(1));
                long l = rs.getLong(1);
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (SQLException sqle) {
            logger.warn("getLastIssuedNodeIdInExistingTable: could not get last issued nodeid: " + sqle);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    logger.warn("getLastIssuedNodeIdInExistingTable: close statement failed: " + sqle);
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    logger.warn("getLastIssuedNodeIdInExistingTable: close resultset failed: " + sqle);
                }
            }
            rs = null;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String getOldObjectId(URI uri, int context) {
        if (!this.statusLog("getOldObjectId")) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(CorpusStructureDBImpl.getDbName());
        if (uri == null || !uri.isAbsolute()) {
            logger.error("getOldObjectId: must be absolute URI: " + uri);
            return null;
        }
        if ((uri = aac.uriToTableContext(uri, context)) == null) {
            logger.error("getOldObjectId: urlToTableContext error, context: " + context);
            return null;
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getIdFromOldArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getIdFromOldArchiveObjectsSTM.clearParameters();
                this.getIdFromOldArchiveObjectsSTM.setString(1, uri.toString());
                rs = this.getIdFromOldArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    String id = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                    if (!rs.isLast()) {
                        logger.error("getOldObjectId: ERROR more than one id for URI: " + uri);
                    }
                    String string = id;
                    return string;
                }
            }
            preparedStatement = null;
            return preparedStatement;
        }
        catch (SQLException sqle) {
            logger.error("getOldObjectId: SQL exception: " + sqle, (Throwable)sqle);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    logger.warn("getOldObjectId: close resultset failed: " + sqle);
                }
            }
            rs = null;
        }
    }

    @Override
    protected void throwUnknownNodeException(String method, String message, String nodeId) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no node with nodeId " + nodeId + ", " + message);
    }

    @Override
    protected void throwUnknownObjectException(String method, String message, String id) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no object with Id " + id + ", " + message);
    }

    @Override
    protected boolean statusLog(String method) {
        return super.statusLog("[Write]." + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encodeRights(String rights) {
        if ("everybody".equals(rights)) {
            return rights;
        }
        if ("nobody".equals(rights)) {
            return rights;
        }
        if ("cleared".equals(rights)) {
            return rights;
        }
        if ("anyAuthenticatedUser".equals(rights)) {
            return rights;
        }
        if (rights == null || !rights.startsWith(" ")) {
            throw new IllegalArgumentException("encodeRights: Only lists and everybody, nobody, cleared or all_auth supported, not: " + rights);
        }
        String md5 = Checksum.checksumString((String)rights);
        if (this.knownGroups.contains(md5)) {
            return md5;
        }
        PreparedStatement ps = null;
        try {
            ps = this.db.getConnection().prepareStatement("INSERT INTO accessgroups ( MD5, ACLSTRING ) SELECT ? AS MD5, ? AS ACLSTRING WHERE ? NOT IN (SELECT MD5 FROM accessgroups)");
            ps.clearParameters();
            ps.setString(1, md5);
            ps.setString(2, rights);
            ps.setString(3, md5);
            int n = ps.executeUpdate();
            if (n > 0) {
                logger.info("encodeRights: Stored " + md5 + " for " + rights);
            } else {
                logger.debug("encodeRights: Confirmed " + md5 + " for " + rights);
            }
            this.knownGroups.add(md5);
        }
        catch (SQLException sqle) {
            logger.error("encodeRights: SQLException: " + sqle, (Throwable)sqle);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sqle) {
                    logger.warn("encodeRights: close prepared statement failed: " + sqle);
                }
            }
            ps = null;
        }
        return md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAdminKey(String name, String value) {
        PreparedStatement ps = null;
        try {
            ps = this.db.getConnection().prepareStatement("INSERT INTO IMDIADMIN ( Name, Value )  VALUES ( ?, ? )");
            ps.clearParameters();
            ps.setString(1, name);
            ps.setString(2, value);
            ps.executeUpdate();
        }
        catch (SQLException sqle) {
            logger.error("insertAdminKey: SQLException: " + sqle, (Throwable)sqle);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sqle) {
                    logger.warn("insertAdminKey: close prepared statement failed: " + sqle);
                }
            }
            ps = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean checkUpdateInProgressLock(boolean claim) {
        Statement stat = null;
        try {
            stat = this.db.getConnection().createStatement();
            if (claim) {
                block32: {
                    try {
                        int n = stat.executeUpdate("UPDATE IMDIADMIN SET VALUE = 'TRUE' WHERE NAME = 'UPDATEINPROGRESS' AND VALUE ='FALSE'");
                        if (n != 1) break block32;
                        boolean bl = false;
                        return bl;
                    }
                    catch (SQLException sqle) {
                        boolean bl = false;
                        return bl;
                    }
                }
                String uIP = super.getMultiAdminKey("UPDATEINPROGRESS", false);
                if (uIP != null) {
                    if (!uIP.equals("TRUE")) {
                        logger.error("checkUpdateInProgressLock: ERROR failed to set lock");
                    }
                    boolean sqle = true;
                    return sqle;
                }
                stat.execute("INSERT INTO IMDIADMIN( NAME, VALUE ) VALUES('UPDATEINPROGRESS', 'TRUE')");
                boolean sqle = false;
                return sqle;
            }
            String uIP = super.getMultiAdminKey("UPDATEINPROGRESS", false);
            if (uIP != null) {
                boolean bl = uIP.equals("TRUE");
                return bl;
            }
        }
        catch (SQLException sqle) {
            logger.error("checkUpdateInProgressLock: SQLException but probably caused by recreating DB " + sqle);
            boolean bl = false;
            return bl;
        }
        finally {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException sqle) {
                    logger.warn("checkUpdateInProgressLock: close statement failed: " + sqle);
                }
            }
            stat = null;
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
    }

    protected void checkWriteAccess() throws UpdateInProgressException {
        if (this.updateInProgress && !this.iAmTheUpdater) {
            throw new UpdateInProgressException("Database updating, only read access allowed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxNodeIdFromDatabase() {
        long t1 = System.nanoTime();
        long maxNodeId = 0L;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.db.getConnection().createStatement();
            rs = statement.executeQuery("SELECT MAX(nodeid) FROM archiveobjects");
            if (rs.next()) {
                maxNodeId = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            logger.error("getMaxNodeIdFromDatabase:", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error("SQLException when closing object: " + e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("SQLException when closing object: " + e);
                }
            }
            statement = null;
            rs = null;
        }
        long t2 = System.nanoTime();
        logger.debug("getMaxNodeIdFromDatabase() took " + (t2 - t1) / 1000000L + "ms.");
        return maxNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxNodeIdFromHandle(String prefix) {
        long t1 = System.nanoTime();
        long maxNodeId = 0L;
        Statement statement = null;
        ResultSet rs = null;
        try {
            String qry = "SELECT pid FROM archiveobjects WHERE pid IS NOT NULL AND pid LIKE 'hdl:" + prefix + "/%'";
            statement = this.db.getConnection().createStatement();
            rs = statement.executeQuery(qry);
            while (rs.next()) {
                String pid = rs.getString(1);
                int nodeid = NodeIdUtils.handleToNode(pid, prefix);
                if ((long)nodeid <= maxNodeId) continue;
                maxNodeId = nodeid;
            }
        }
        catch (SQLException e) {
            logger.error("getMaxNodeIdFromHandle:", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error("SQLException when closing object: " + e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("SQLException when closing object: " + e);
                }
            }
            statement = null;
            rs = null;
        }
        long t2 = System.nanoTime();
        logger.debug("getMaxNodeIdFromHandle() took " + (t2 - t1) / 1000000L + "ms.");
        return maxNodeId;
    }
}

