/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.basex.core.GlobalOptions;
import org.basex.core.Locking;
import org.basex.core.Proc;
import org.basex.util.Prop;
import org.basex.util.list.StringList;

public final class DBLocking
implements Locking {
    private static final boolean FAIR = true;
    private static final String PREFIX = "%";
    public static final String COLL = "%COLL";
    public static final String CTX = "%CTX";
    public static final String ADMIN = "%ADMIN";
    public static final String BACKUP = "%BACKUP";
    public static final String EVENT = "%EVENT";
    public static final String REPO = "%REPO";
    public static final String USER_PREFIX = "+";
    public static final String MODULE_PREFIX = "&";
    private final Object globalLock = new Object();
    private int localWriters;
    private int globalReaders;
    private final ReentrantReadWriteLock writeAll = new ReentrantReadWriteLock();
    private final Map<String, ReentrantReadWriteLock> locks = new HashMap<String, ReentrantReadWriteLock>();
    private final Map<String, Integer> lockUsage = new HashMap<String, Integer>();
    private int transactions;
    private final Queue<Long> queue = new LinkedList<Long>();
    private final ConcurrentMap<Long, StringList> writeLocked = new ConcurrentHashMap<Long, StringList>();
    private final ConcurrentMap<Long, StringList> readLocked = new ConcurrentHashMap<Long, StringList>();
    private final GlobalOptions gopts;

    public DBLocking(GlobalOptions opts) {
        this.gopts = opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire(Proc pr, StringList read, StringList write) {
        StringList readObjects;
        StringList writeObjects;
        Long thread = Thread.currentThread().getId();
        if (this.writeLocked.containsKey(thread) || this.readLocked.containsKey(thread)) {
            throw new IllegalMonitorStateException("Thread already holds one or more locks.");
        }
        Object object = this.queue;
        synchronized (object) {
            this.queue.add(thread);
            while (this.transactions >= Math.max(this.gopts.get(GlobalOptions.PARALLEL), 1) || this.queue.peek() != thread) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            int t = this.transactions++;
            assert (t <= Math.max(this.gopts.get(GlobalOptions.PARALLEL), 1));
            this.queue.remove(thread);
        }
        if (write == null) {
            this.writeAll.writeLock().lock();
        } else {
            this.writeAll.readLock().lock();
        }
        object = this.globalLock;
        synchronized (object) {
            if (write != null && !write.isEmpty()) {
                while (this.globalReaders > 0) {
                    try {
                        this.globalLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                ++this.localWriters;
            }
            if (read == null) {
                while (this.localWriters > 0) {
                    try {
                        this.globalLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                ++this.globalReaders;
            }
        }
        if (write != null) {
            writeObjects = write.sort(true).unique();
            this.writeLocked.put(thread, writeObjects);
        } else {
            writeObjects = new StringList(0);
        }
        if (read != null) {
            readObjects = read.sort(true).unique();
            this.readLocked.put(thread, readObjects);
        } else {
            readObjects = new StringList(0);
        }
        int w = 0;
        int r = 0;
        while (r < readObjects.size() || w < writeObjects.size()) {
            if (w < writeObjects.size() && (r >= readObjects.size() || writeObjects.get(w).compareTo(readObjects.get(r)) <= 0)) {
                String writeObject = writeObjects.get(w++);
                this.setLockUsed(writeObject);
                this.getOrCreateLock(writeObject).writeLock().lock();
                continue;
            }
            if (write == null) continue;
            String readObject = readObjects.get(r++);
            this.setLockUsed(readObject);
            this.getOrCreateLock(readObject).readLock().lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock getOrCreateLock(String object) {
        ReentrantReadWriteLock lock;
        Map<String, ReentrantReadWriteLock> map = this.locks;
        synchronized (map) {
            lock = this.locks.get(object);
            if (lock == null) {
                lock = new ReentrantReadWriteLock(true);
                this.locks.put(object, lock);
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Proc pr) {
        Object object;
        Long thread = Thread.currentThread().getId();
        StringList writeObjects = (StringList)this.writeLocked.remove(thread);
        if (writeObjects != null) {
            for (String object2 : writeObjects) {
                ReentrantReadWriteLock lock = this.getOrCreateLock(object2);
                assert (lock.getWriteHoldCount() == 1) : "Unexpected write lock count: " + lock.getWriteHoldCount();
                lock.writeLock().unlock();
                this.unsetLockIfUnused(object2);
            }
        }
        StringList readObjects = (StringList)this.readLocked.remove(thread);
        if (!this.writeAll.isWriteLocked() && readObjects != null) {
            for (String object3 : readObjects) {
                this.getOrCreateLock(object3).readLock().unlock();
                this.unsetLockIfUnused(object3);
            }
        }
        ((Lock)(this.writeAll.isWriteLocked() ? this.writeAll.writeLock() : this.writeAll.readLock())).unlock();
        if (writeObjects != null && !writeObjects.isEmpty()) {
            object = this.globalLock;
            synchronized (object) {
                --this.localWriters;
                this.globalLock.notifyAll();
            }
        }
        if (readObjects == null) {
            object = this.globalLock;
            synchronized (object) {
                --this.globalReaders;
                this.globalLock.notifyAll();
            }
        }
        object = this.queue;
        synchronized (object) {
            --this.transactions;
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLockUsed(String lock) {
        Map<String, Integer> map = this.lockUsage;
        synchronized (map) {
            Integer usage = this.lockUsage.get(lock);
            if (usage == null) {
                usage = 0;
            }
            usage = usage + 1;
            this.lockUsage.put(lock, usage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetLockIfUnused(String object) {
        Map<String, Integer> map = this.lockUsage;
        synchronized (map) {
            Integer usage = this.lockUsage.get(object);
            assert (usage != null);
            if ((usage = Integer.valueOf(usage - 1)) == 0) {
                this.locks.remove(object);
                this.lockUsage.remove(object);
            } else {
                this.lockUsage.put(object, usage);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Prop.NL);
        sb.append("Locking" + Prop.NL);
        String ind = "| ";
        sb.append("| Transactions running: " + this.transactions + Prop.NL);
        sb.append("| Transaction queue: " + this.queue + Prop.NL);
        sb.append("| Held locks by object:" + Prop.NL);
        for (Map.Entry<String, ReentrantReadWriteLock> e : this.locks.entrySet()) {
            sb.append("| | " + e.getKey() + " -> " + e.getValue() + Prop.NL);
        }
        sb.append("| Held write locks by transaction:" + Prop.NL);
        for (Long thread : this.writeLocked.keySet()) {
            sb.append("| | " + thread + " -> " + this.writeLocked.get(thread) + Prop.NL);
        }
        sb.append("| Held read locks by transaction:" + Prop.NL);
        for (Long thread : this.readLocked.keySet()) {
            sb.append("| | " + thread + " -> " + this.readLocked.get(thread) + Prop.NL);
        }
        return sb.toString();
    }
}

