/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import org.basex.core.InfoListener;
import org.basex.core.LockResult;
import org.basex.core.ProcException;
import org.basex.core.Text;
import org.basex.util.Performance;

public abstract class Proc {
    public InfoListener listen;
    public boolean updating;
    protected boolean registered;
    private boolean stopped;
    private Thread timeout;
    private Proc sub;

    public final String title() {
        return this.sub != null ? this.sub.title() : this.tit();
    }

    public final String detail() {
        return this.sub != null ? this.sub.detail() : this.det();
    }

    public final double progress() {
        return this.sub != null ? this.sub.progress() : this.prog();
    }

    public final void listen(InfoListener il) {
        if (this.sub != null) {
            this.sub.listen(il);
        }
        this.listen = il;
    }

    public final <P extends Proc> P proc(P proc) {
        this.sub = proc;
        if (proc != null) {
            proc.listen = this.listen;
            proc.registered = this.registered;
            proc.proc((Proc)this.sub.sub);
            if (this.stopped) {
                proc.stop();
            }
        }
        return (P)proc;
    }

    public final void stop() {
        if (this.sub != null) {
            this.sub.stop();
        }
        this.stopped = true;
        this.stopTimeout();
    }

    public final void checkStop() {
        if (this.stopped) {
            throw new ProcException();
        }
    }

    protected void abort() {
        if (this.sub != null) {
            this.sub.abort();
        }
    }

    public final void startTimeout(final long ms) {
        if (ms == 0L) {
            return;
        }
        this.timeout = new Thread(){

            @Override
            public void run() {
                Performance.sleep(ms);
                Proc.this.stop();
            }
        };
        this.timeout.setDaemon(true);
        this.timeout.start();
    }

    public final void stopTimeout() {
        if (this.timeout != null) {
            this.timeout.interrupt();
            this.timeout = null;
        }
    }

    public void databases(LockResult lr) {
        lr.writeAll = true;
    }

    public final boolean registered() {
        return this.sub != null ? this.sub.registered() : this.registered;
    }

    public final void registered(boolean reg) {
        if (this.sub != null) {
            this.sub.registered(reg);
        }
        this.registered = reg;
    }

    protected String tit() {
        return Text.PLEASE_WAIT_D;
    }

    protected String det() {
        return Text.PLEASE_WAIT_D;
    }

    protected double prog() {
        return 0.0;
    }
}

