/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.HashMap;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.LockResult;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.ProcException;
import org.basex.core.Text;
import org.basex.core.parse.CmdBuilder;
import org.basex.data.Result;
import org.basex.io.IOFile;
import org.basex.io.out.BufferOutput;
import org.basex.io.out.NullOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.dot.DOTSerializer;
import org.basex.query.QueryException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.util.Performance;
import org.basex.util.Util;

public abstract class AQuery
extends Command {
    Result result;
    private final HashMap<String, String[]> vars = new HashMap();
    private Object http;
    private QueryProcessor qp;
    private QueryInfo info;

    AQuery(Perm p, boolean d, String ... arg) {
        super(p, d, arg);
    }

    final boolean query(String query) {
        String err;
        Performance p = new Performance();
        if (this.cause != null) {
            err = Util.message(this.cause);
        } else {
            try {
                long hits = 0L;
                boolean run = this.options.get(MainOptions.RUNQUERY);
                boolean serial = this.options.get(MainOptions.SERIALIZE);
                int runs = Math.max(1, this.options.get(MainOptions.RUNS));
                for (int r = 0; r < runs; ++r) {
                    Serializer ser;
                    PrintOutput po;
                    if (r != 0) {
                        this.qp = null;
                    }
                    this.qp(query, this.context);
                    this.parse(p);
                    if (r == 0) {
                        this.plan(false);
                    }
                    this.qp.compile();
                    this.info.compiling += p.time();
                    if (r == 0) {
                        this.plan(true);
                    }
                    if (!run) continue;
                    PrintOutput printOutput = po = r == 0 && serial ? this.out : new NullOutput();
                    if (this.options.get(MainOptions.CACHEQUERY).booleanValue()) {
                        this.result = this.qp.execute();
                        this.info.evaluating += p.time();
                        ser = this.qp.getSerializer(po);
                        this.result.serialize(ser);
                        hits = this.result.size();
                    } else {
                        hits = 0L;
                        Iter ir = this.qp.iter();
                        this.info.evaluating += p.time();
                        Item it = ir.next();
                        ser = this.qp.getSerializer(po);
                        while (it != null) {
                            this.checkStop();
                            ser.serialize(it);
                            it = ir.next();
                            ++hits;
                        }
                    }
                    ser.close();
                    this.qp.close();
                    this.info.serializing += p.time();
                }
                this.out.flush();
                if (this.goptions.get(GlobalOptions.GLOBALLOCK).booleanValue() && this.qp.updating) {
                    this.info.readLocked = null;
                    this.info.writeLocked = null;
                }
                boolean bl = this.info(this.info.toString(this.qp, this.out.size(), hits, this.options.get(MainOptions.QUERYINFO)), new Object[0]);
                return bl;
            }
            catch (QueryException ex) {
                this.cause = ex;
                err = Util.message(ex);
            }
            catch (IOException ex) {
                this.cause = ex;
                err = Util.message(ex);
            }
            catch (ProcException ex) {
                err = Text.INTERRUPTED;
            }
            catch (StackOverflowError ex) {
                Util.debug(ex);
                err = Err.BASX_STACKOVERFLOW.desc;
            }
            catch (RuntimeException ex) {
                this.extError("");
                Util.debug(this.info(), new Object[0]);
                throw ex;
            }
            finally {
                if (this.qp != null) {
                    this.qp.close();
                }
            }
        }
        return this.extError(err);
    }

    private void parse(Performance p) throws QueryException {
        this.qp.http(this.http);
        for (String name : this.vars.keySet()) {
            String[] value = this.vars.get(name);
            if (name == null) {
                this.qp.context(value[0], value[1]);
                continue;
            }
            this.qp.bind(name, value[0], value[1]);
        }
        this.qp.parse();
        if (p != null) {
            this.info.parsing += p.time();
        }
    }

    final boolean updating(Context ctx, String qu) {
        try {
            Performance p = new Performance();
            this.qp(qu, ctx);
            this.parse(p);
            return this.qp.updating;
        }
        catch (QueryException ex) {
            Util.debug(ex);
            this.cause = ex;
            this.qp.close();
            return false;
        }
    }

    final void queryNodes() {
        try {
            this.result = this.qp(this.args[0], this.context).queryNodes();
            this.qp.close();
        }
        catch (QueryException ex) {
            this.qp.close();
            this.qp = null;
            this.error(Util.message(ex), new Object[0]);
        }
    }

    private QueryProcessor qp(String query, Context ctx) {
        if (this.qp == null) {
            this.qp = this.proc(new QueryProcessor(query, ctx));
            if (this.info == null) {
                this.info = this.qp.ctx.info;
            }
        }
        return this.qp;
    }

    public SerializerOptions parameters(Context ctx) {
        SerializerOptions params = Serializer.OPTIONS;
        try {
            this.qp(this.args[0], ctx);
            this.parse(null);
            params = this.qp.ctx.serParams();
        }
        catch (QueryException ex) {
            this.error(Util.message(ex), new Object[0]);
        }
        this.qp = null;
        return params;
    }

    public AQuery bind(String name, String value) {
        return this.bind(name, value, null);
    }

    public AQuery bind(String name, String value, String type) {
        this.vars.put(name, new String[]{value, type});
        return this;
    }

    public void http(Object value) {
        this.http = value;
    }

    private boolean extError(String err) {
        StringBuilder sb = new StringBuilder();
        if (this.options.get(MainOptions.QUERYINFO).booleanValue()) {
            sb.append(this.info()).append(this.qp.info()).append(Text.NL).append(Text.ERROR).append(":").append(Text.NL);
        }
        sb.append(err);
        return this.error(sb.toString(), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plan(boolean comp) {
        if (comp != this.options.get(MainOptions.COMPPLAN)) {
            return;
        }
        BufferOutput bo = null;
        try {
            if (this.options.get(MainOptions.DOTPLAN).booleanValue()) {
                String path = this.context.options.get(MainOptions.QUERYPATH);
                String dot = path.isEmpty() ? "plan.dot" : new IOFile(path).name().replaceAll("\\..*?$", ".dot");
                bo = new BufferOutput(dot);
                DOTSerializer d = new DOTSerializer(bo, this.options.get(MainOptions.DOTCOMPACT));
                d.serialize(this.qp.plan());
                d.close();
            }
            if (this.options.get(MainOptions.XMLPLAN).booleanValue()) {
                this.info(Text.NL + Text.QUERY_PLAN + ":", new Object[0]);
                this.info(this.qp.plan().serialize().toString(), new Object[0]);
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
        finally {
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean updating(Context ctx) {
        return this.args[0] != null && this.updating(ctx, this.args[0]);
    }

    @Override
    public boolean updated(Context ctx) {
        return this.qp != null && this.qp.updates() != 0;
    }

    @Override
    public void databases(LockResult lr) {
        if (this.qp == null) {
            lr.writeAll = true;
        } else {
            this.qp.databases(lr);
            this.info.readLocked = lr.readAll ? null : lr.read;
            this.info.writeLocked = lr.writeAll ? null : lr.write;
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().xquery(0);
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    @Override
    public final Result result() {
        Result r = this.result;
        this.result = null;
        return r;
    }
}

