/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.DropDB;
import org.basex.core.parse.CmdBuilder;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.atomic.DataClip;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class Add
extends ACreate {
    private Builder build;
    boolean lock = true;

    public Add(String path) {
        this(path, (String)null);
    }

    public Add(String path, String input) {
        super(Perm.WRITE, true, path == null ? "" : path, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean run() {
        boolean bl;
        Data tmp;
        String db;
        block26: {
            block27: {
                boolean bl2;
                block25: {
                    IO io;
                    String name = MetaData.normPath(this.args[0]);
                    if (name == null) {
                        return this.error(Text.NAME_INVALID_X, this.args[0]);
                    }
                    try {
                        io = this.sourceToIO(name);
                    }
                    catch (IOException ex) {
                        return this.error(Util.message(ex), new Object[0]);
                    }
                    if (io == null) {
                        return this.error(Text.RES_NOT_FOUND, new Object[0]);
                    }
                    if (!io.exists()) {
                        boolean bl3;
                        if (this.in != null) {
                            bl3 = this.error(Text.RES_NOT_FOUND, new Object[0]);
                            return bl3;
                        }
                        bl3 = this.error(Text.RES_NOT_FOUND_X, this.context.user.has(Perm.CREATE) ? io : this.args[1]);
                        return bl3;
                    }
                    if (!name.endsWith("/") && (io.isDir() || io.isArchive())) {
                        name = name + '/';
                    }
                    String target = "";
                    int s = name.lastIndexOf(47);
                    if (s != -1) {
                        target = name.substring(0, s);
                        name = name.substring(s + 1);
                    }
                    Data data = this.context.data();
                    if (name.isEmpty()) {
                        name = io.name();
                    } else {
                        io.name(name);
                    }
                    if (name.isEmpty()) {
                        return this.error(Text.NAME_INVALID_X, name);
                    }
                    db = null;
                    tmp = null;
                    try {
                        DirParser parser = new DirParser(io, this.options, data.meta.path);
                        parser.target(target);
                        if (this.cache(parser)) {
                            db = this.context.globalopts.random(data.meta.name);
                            this.build = new DiskBuilder(db, parser, this.context);
                        } else {
                            this.build = new MemBuilder(name, parser);
                        }
                        tmp = this.build.build();
                        if (tmp.meta.size > 1) {
                            if (this.lock && !data.startUpdate()) {
                                bl2 = this.error(Text.DB_PINNED_X, data.meta.name);
                                if (tmp != null) {
                                    tmp.close();
                                }
                                if (db == null) return bl2;
                                break block25;
                            }
                            data.insert(data.meta.size, -1, new DataClip(tmp));
                            this.context.update();
                            if (this.lock) {
                                data.finishUpdate();
                            }
                        }
                        bl = this.info(((Parser)parser).info() + Text.PATH_ADDED_X_X, name, this.perf);
                        if (tmp == null) break block26;
                        break block27;
                    }
                    catch (IOException ex) {
                        boolean bl4 = this.error(Util.message(ex), new Object[0]);
                        return bl4;
                    }
                }
                DropDB.drop(db, this.context);
                return bl2;
            }
            tmp.close();
        }
        if (db == null) return bl;
        DropDB.drop(db, this.context);
        return bl;
        finally {
            if (tmp != null) {
                tmp.close();
            }
            if (db != null) {
                DropDB.drop(db, this.context);
            }
        }
    }

    private boolean cache(Parser parser) {
        Runtime rt;
        long max;
        IOFile f;
        if (this.options.get(MainOptions.MAINMEM).booleanValue()) {
            return false;
        }
        if (this.options.get(MainOptions.ADDCACHE).booleanValue()) {
            return true;
        }
        long fl = parser.src.length();
        if (parser.src instanceof IOFile && (f = (IOFile)parser.src).isDir()) {
            for (String d : f.descendants()) {
                fl += new IOFile(f, d).length();
            }
        }
        if (fl < ((max = (rt = Runtime.getRuntime()).maxMemory()) - rt.freeMemory()) / 2L) {
            return false;
        }
        Performance.gc(2);
        return fl > (max - rt.freeMemory()) / 2L;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg("TO", 0).arg(1);
    }

    @Override
    protected String tit() {
        return Text.ADD;
    }

    @Override
    protected double prog() {
        return this.build != null ? this.build.prog() : 0.0;
    }
}

