/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Datas;
import org.basex.core.LockResult;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.util.Util;

public final class Open
extends Command {
    public Open(String name) {
        super(Perm.NONE, name);
    }

    @Override
    protected boolean run() {
        new Close().run(this.context);
        String db = this.args[0];
        if (!Databases.validName(db)) {
            return this.error(Text.NAME_INVALID_X, db);
        }
        try {
            Data data = Open.open(db, this.context);
            this.context.openDB(data);
            if (data.meta.oldindex()) {
                this.info(Text.H_INDEX_FORMAT, new Object[0]);
            }
            if (data.meta.corrupt) {
                this.info(Text.DB_CORRUPT, new Object[0]);
            }
            return this.info(Text.DB_OPENED_X, db, this.perf);
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    @Override
    public void databases(LockResult lr) {
        lr.read.add("%CTX").add(this.args[0]);
    }

    @Override
    public boolean newData(Context ctx) {
        return new Close().run(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Data open(String name, Context ctx) throws IOException {
        Datas datas = ctx.dbs;
        synchronized (datas) {
            Data data = ctx.dbs.pin(name);
            if (data == null) {
                if (!ctx.globalopts.dbexists(name)) {
                    throw new BaseXException(Open.dbnf(name), new Object[0]);
                }
                data = new DiskData(name, ctx);
                ctx.dbs.add(data);
            }
            if (!ctx.perm(Perm.READ, data.meta)) {
                Close.close(data, ctx);
                throw new BaseXException(Text.PERM_REQUIRED_X, new Object[]{Perm.READ});
            }
            return data;
        }
    }

    public static String dbnf(String name) {
        return Util.info(Text.DB_NOT_FOUND_X, name);
    }
}

