/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.IdPreMap;
import org.basex.index.Index;
import org.basex.index.IndexType;
import org.basex.index.ft.FTIndex;
import org.basex.index.name.Names;
import org.basex.index.path.PathSummary;
import org.basex.index.value.DiskValues;
import org.basex.index.value.UpdatableDiskValues;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.io.random.TableDiskAccess;
import org.basex.util.Compress;
import org.basex.util.Num;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;

public final class DiskData
extends Data {
    private static final ThreadLocal<Compress> COMP = new ThreadLocal<Compress>(){

        @Override
        protected Compress initialValue() {
            return new Compress();
        }
    };
    private DataAccess texts;
    private DataAccess values;
    private TokenObjMap<IntList> txts;
    private TokenObjMap<IntList> atvs;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskData(String db, Context ctx) throws IOException {
        this.meta = new MetaData(db, ctx);
        if (this.updateFile().exists()) {
            throw new BaseXException(Text.DB_UPDATED_X, this.meta.name);
        }
        DataInput in = new DataInput(this.meta.dbfile("inf"));
        try {
            String k;
            this.meta.read(in);
            while (!(k = Token.string(in.readToken())).isEmpty()) {
                if (k.equals("TAGS")) {
                    this.tagindex = new Names(in, this.meta);
                    continue;
                }
                if (k.equals("ATTS")) {
                    this.atnindex = new Names(in, this.meta);
                    continue;
                }
                if (k.equals("PATH")) {
                    this.paths = new PathSummary(this, in);
                    continue;
                }
                if (k.equals("NS")) {
                    this.nspaces = new Namespaces(in);
                    continue;
                }
                if (!k.equals("DOCS")) continue;
                this.resources.read(in);
            }
        }
        finally {
            in.close();
        }
        if (this.meta.updindex) {
            this.idmap = new IdPreMap(this.meta.dbfile("idp"));
            if (this.meta.textindex) {
                this.txtindex = new UpdatableDiskValues(this, true);
            }
            if (this.meta.attrindex) {
                this.atvindex = new UpdatableDiskValues(this, false);
            }
        } else {
            if (this.meta.textindex) {
                this.txtindex = new DiskValues(this, true);
            }
            if (this.meta.attrindex) {
                this.atvindex = new DiskValues(this, false);
            }
        }
        if (this.meta.ftxtindex) {
            this.ftxindex = new FTIndex(this);
        }
        this.init();
    }

    public DiskData(MetaData md, Names nm, Names at, PathSummary ps, Namespaces n) throws IOException {
        this.meta = md;
        this.tagindex = nm;
        this.atnindex = at;
        this.paths = ps;
        this.paths.data(this);
        this.nspaces = n;
        if (this.meta.updindex) {
            this.idmap = new IdPreMap(this.meta.lastid);
        }
        this.init();
    }

    void init() throws IOException {
        this.table = new TableDiskAccess(this.meta, false);
        this.texts = new DataAccess(this.meta.dbfile("txt"));
        this.values = new DataAccess(this.meta.dbfile("atv"));
    }

    private void write() throws IOException {
        if (this.meta.dirty) {
            DataOutput out = new DataOutput(this.meta.dbfile("inf"));
            this.meta.write(out);
            out.writeToken(Token.token("TAGS"));
            this.tagindex.write(out);
            out.writeToken(Token.token("ATTS"));
            this.atnindex.write(out);
            out.writeToken(Token.token("PATH"));
            this.paths.write(out);
            out.writeToken(Token.token("NS"));
            this.nspaces.write(out);
            out.writeToken(Token.token("DOCS"));
            this.resources.write(out);
            out.write(0);
            out.close();
            if (this.idmap != null) {
                this.idmap.write(this.meta.dbfile("idp"));
            }
            this.meta.dirty = false;
        }
        this.updateFile().delete();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.write();
            this.table.close();
            this.texts.close();
            this.values.close();
            this.closeIndex(IndexType.TEXT);
            this.closeIndex(IndexType.ATTRIBUTE);
            this.closeIndex(IndexType.FULLTEXT);
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    @Override
    public synchronized void closeIndex(IndexType type) {
        Index index = this.index(type);
        if (index == null) {
            return;
        }
        index.close();
        this.meta.dirty = true;
        switch (type) {
            case TEXT: {
                this.txtindex = null;
                break;
            }
            case ATTRIBUTE: {
                this.atvindex = null;
                break;
            }
            case FULLTEXT: {
                this.ftxindex = null;
                break;
            }
        }
    }

    @Override
    public void setIndex(IndexType type, Index index) {
        this.meta.dirty = true;
        switch (type) {
            case TEXT: {
                this.txtindex = index;
                break;
            }
            case ATTRIBUTE: {
                this.atvindex = index;
                break;
            }
            case FULLTEXT: {
                this.ftxindex = index;
                break;
            }
        }
    }

    @Override
    public boolean startUpdate() {
        IOFile uf = this.updateFile();
        return (uf.exists() || uf.touch()) && this.table.lock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finishUpdate() {
        if (!this.meta.options.get(MainOptions.AUTOFLUSH).booleanValue() || this.closed) {
            return;
        }
        try {
            this.write();
            this.table.flush();
            this.texts.flush();
            this.values.flush();
            if (this.txtindex != null) {
                ((DiskValues)this.txtindex).flush();
            }
            if (this.atvindex != null) {
                ((DiskValues)this.atvindex).flush();
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
        finally {
            this.table.lock(false);
        }
    }

    public IOFile updateFile() {
        return this.meta.dbfile("upd");
    }

    @Override
    public byte[] text(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? Token.token((int)o) : this.txt(o, text);
    }

    @Override
    public long textItr(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? o & 0x7FFFFFFFFFL : Token.toLong(this.txt(o, text));
    }

    @Override
    public double textDbl(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? (double)(o & 0x7FFFFFFFFFL) : Token.toDouble(this.txt(o, text));
    }

    @Override
    public int textLen(int pre, boolean text) {
        long o = this.textOff(pre);
        if (DiskData.num(o)) {
            return Token.numDigits((int)o);
        }
        DataAccess da = text ? this.texts : this.values;
        int l = da.readNum(o & 0x3FFFFFFFFFL);
        return DiskData.cpr(o) ? da.readNum() : l;
    }

    private byte[] txt(long o, boolean text) {
        byte[] txt = (text ? this.texts : this.values).readToken(o & 0x3FFFFFFFFFL);
        return DiskData.cpr(o) ? COMP.get().unpack(txt) : txt;
    }

    private static boolean num(long o) {
        return (o & 0x8000000000L) != 0L;
    }

    private static boolean cpr(long o) {
        return (o & 0x4000000000L) != 0L;
    }

    @Override
    protected void delete(int pre, boolean text) {
        long old = this.textOff(pre);
        if (!DiskData.num(old)) {
            (text ? this.texts : this.values).free(old & 0x3FFFFFFFFFL, 0);
        }
    }

    @Override
    protected void updateText(int pre, byte[] value, int kind) {
        long off;
        boolean text;
        boolean bl = text = kind != 3;
        if (this.meta.updindex) {
            int id = this.id(pre);
            byte[] oldval = this.text(pre, text);
            DiskValues index = (DiskValues)(text ? this.txtindex : this.atvindex);
            if (index != null && kind != 0) {
                index.replace(oldval, value, id);
            }
        }
        DataAccess store = text ? this.texts : this.values;
        long len = store.length();
        long v = Token.toSimpleInt(value);
        boolean vn = v != Integer.MIN_VALUE;
        byte[] vl = vn ? null : COMP.get().pack(value);
        long old = this.textOff(pre);
        if (DiskData.num(old)) {
            off = len;
        } else {
            int l = vn ? 0 : vl.length + Num.length(vl.length);
            off = store.free(old & 0x3FFFFFFFFFL, l);
        }
        if (vn) {
            this.textOff(pre, v | 0x8000000000L);
        } else {
            store.writeToken(off, vl);
            this.textOff(pre, vl == value ? off : off | 0x4000000000L);
        }
    }

    @Override
    protected void indexBegin() {
        this.txts = new TokenObjMap();
        this.atvs = new TokenObjMap();
    }

    @Override
    protected void indexEnd() {
        if (!this.txts.isEmpty()) {
            ((DiskValues)this.txtindex).index(this.txts);
        }
        if (!this.atvs.isEmpty()) {
            ((DiskValues)this.atvindex).index(this.atvs);
        }
    }

    @Override
    protected long index(int pre, int id, byte[] value, int kind) {
        long v;
        TokenObjMap<IntList> m;
        DataAccess store;
        if (kind == 3) {
            store = this.values;
            m = this.meta.attrindex ? this.atvs : null;
        } else {
            store = this.texts;
            TokenObjMap<IntList> tokenObjMap = m = this.meta.textindex && kind != 0 ? this.txts : null;
        }
        if (this.meta.updindex && m != null && value.length <= this.meta.maxlen) {
            IntList ids = m.get(value);
            if (ids == null) {
                ids = new IntList(1);
                m.put(value, ids);
            }
            ids.add(id);
        }
        if ((v = (long)Token.toSimpleInt(value)) != Integer.MIN_VALUE) {
            return v | 0x8000000000L;
        }
        long off = store.length();
        byte[] val = COMP.get().pack(value);
        store.writeToken(off, val);
        return val == value ? off : off | 0x4000000000L;
    }

    @Override
    protected void indexDelete(int pre, int size) {
        if (!this.meta.textindex && !this.meta.attrindex) {
            return;
        }
        this.txts = new TokenObjMap();
        this.atvs = new TokenObjMap();
        int l = pre + size;
        for (int p = pre; p < l; ++p) {
            byte[] key;
            boolean isAttr;
            int k = this.kind(p);
            boolean bl = isAttr = k == 3;
            if ((!this.meta.attrindex || !isAttr) && (!this.meta.textindex || k != 2 && k != 4 && k != 5) || (key = this.text(p, !isAttr)).length > this.meta.maxlen) continue;
            TokenObjMap<IntList> m = isAttr ? this.atvs : this.txts;
            IntList ids = m.get(key);
            if (ids == null) {
                ids = new IntList(1);
                m.put(key, ids);
            }
            ids.add(this.id(p));
        }
        if (!this.txts.isEmpty()) {
            ((DiskValues)this.txtindex).delete(this.txts);
        }
        if (!this.atvs.isEmpty()) {
            ((DiskValues)this.atvindex).delete(this.atvs);
        }
    }

    @Override
    public boolean inMemory() {
        return false;
    }
}

