/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.data.FTStringMatch;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public final class FTMatch
extends ElementList
implements Iterable<FTStringMatch> {
    FTStringMatch[] match;

    public FTMatch() {
        this(0);
    }

    public FTMatch(int capacity) {
        this.match = new FTStringMatch[capacity];
    }

    public FTMatch add(FTMatch m) {
        for (FTStringMatch sm : m) {
            this.add(sm);
        }
        return this;
    }

    public FTMatch add(FTStringMatch m) {
        if (this.size == this.match.length) {
            this.match = Array.copy(this.match, new FTStringMatch[this.newSize()]);
        }
        this.match[this.size++] = m;
        return this;
    }

    public boolean notin(FTMatch m) {
        for (FTStringMatch s : this) {
            for (FTStringMatch sm : m) {
                if (s.in(sm)) continue;
                return true;
            }
        }
        return false;
    }

    boolean match() {
        for (FTStringMatch s : this) {
            if (!s.exclude) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this.match, 0, this.size, null);
    }

    @Override
    public Iterator<FTStringMatch> iterator() {
        return new ArrayIterator<FTStringMatch>(this.match, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FTStringMatch s : this) {
            sb.append(sb.length() == 0 ? "" : ", ").append(s);
        }
        return Util.className(this) + ' ' + sb;
    }
}

