/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.util.Iterator;
import org.basex.data.FTMatch;
import org.basex.data.FTStringMatch;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public final class FTMatches
extends ElementList
implements Iterable<FTMatch> {
    public FTMatch[] match = new FTMatch[0];
    public int pos;

    public FTMatches() {
    }

    public FTMatches(int p) {
        this.pos = p;
    }

    public void reset(int p) {
        this.pos = p;
        this.size = 0;
    }

    public void or(int p) {
        this.or(p, p);
    }

    public void or(int s, int e) {
        this.add(new FTMatch(1).add(new FTStringMatch(s, e, this.pos)));
    }

    public void and(int s, int e) {
        FTStringMatch sm = new FTStringMatch(s, e, this.pos);
        for (FTMatch m : this) {
            m.add(sm);
        }
    }

    public void add(FTMatch m) {
        if (this.size == this.match.length) {
            this.match = Array.copy(this.match, new FTMatch[Array.newSize(this.size)]);
        }
        this.match[this.size++] = m;
    }

    public void delete(int i) {
        Array.move(this.match, i + 1, -1, --this.size - i);
    }

    public boolean matches() {
        for (FTMatch m : this) {
            if (!m.match()) continue;
            return true;
        }
        return false;
    }

    public boolean phrase(FTMatches all, int dis) {
        int a = 0;
        int b = 0;
        int c = 0;
        while (a < this.size && b < all.size) {
            int e = all.match[b].match[0].start;
            int d = e - this.match[a].match[0].end - dis;
            if (d == 0) {
                this.match[c] = this.match[a];
                this.match[c++].match[0].end = e;
            }
            if (d >= 0) {
                ++a;
            }
            if (d > 0) continue;
            ++b;
        }
        this.size = c;
        return this.size != 0;
    }

    @Override
    public Iterator<FTMatch> iterator() {
        return new ArrayIterator<FTMatch>(this.match, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.className(this)).append('[').append(this.pos).append(']');
        for (FTMatch m : this) {
            sb.append("\n  ").append(m);
        }
        return sb.toString();
    }
}

