/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.DropBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Restore;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.gui.GUI;
import org.basex.gui.dialog.DialogInput;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXList;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DialogManage
extends BaseXDialog {
    private final BaseXList choice;
    private final BaseXLabel doc1;
    private final BaseXLabel doc2;
    private final TextPanel detail;
    private final BaseXButton rename;
    private final BaseXButton drop;
    private final BaseXButton open;
    private final BaseXButton backup;
    private final BaseXButton restore;
    private final BaseXButton copy;
    private boolean refresh;
    private final BaseXList backups;
    private final BaseXButton delete;
    private final BaseXButton deleteAll;

    public DialogManage(GUI main) {
        super(main, Text.MANAGE_DB);
        this.panel.setLayout(new BorderLayout(4, 0));
        StringList dbs = main.context.databases.list();
        this.choice = new BaseXList(dbs.toArray(), this, false);
        this.choice.setSize(200, 500);
        Data data = main.context.data();
        if (data != null) {
            this.choice.setValue(data.meta.name);
        }
        this.doc1 = new BaseXLabel(" ").large();
        this.doc1.setSize(420, this.doc1.getHeight());
        this.detail = new TextPanel(false, this);
        this.detail.setFont(this.panel.getFont());
        this.rename = new BaseXButton(Text.RENAME + "...", this);
        this.copy = new BaseXButton(Text.COPY + "...", this);
        this.open = new BaseXButton(Text.OPEN, this);
        this.drop = new BaseXButton(Text.DROP + "...", this);
        BaseXBack tab1 = new BaseXBack(new BorderLayout(0, 8)).border(8);
        tab1.add((Component)this.doc1, "North");
        tab1.add((Component)new SearchEditor(main, this.detail), "Center");
        tab1.add((Component)this.newButtons(this.drop, this.rename, this.copy, this.open), "South");
        this.doc2 = new BaseXLabel(" ").border(0, 0, 6, 0);
        this.doc2.setFont(this.doc1.getFont());
        this.backups = new BaseXList(new String[0], this);
        this.backups.setSize(400, 400);
        this.backup = new BaseXButton(Text.BACKUP, this);
        this.restore = new BaseXButton(Text.RESTORE, this);
        this.delete = new BaseXButton(Text.DELETE, this);
        this.deleteAll = new BaseXButton(Text.DELETE_ALL + "...", this);
        BaseXBack tab2 = new BaseXBack(new BorderLayout(0, 8)).border(8);
        tab2.add((Component)this.doc2, "North");
        tab2.add((Component)this.backups, "Center");
        tab2.add((Component)this.newButtons(this.backup, this.restore, this.delete, this.deleteAll), "South");
        BaseXTabs tabs = new BaseXTabs(this);
        tabs.addTab(Text.INFORMATION, tab1);
        tabs.addTab(Text.BACKUPS, tab2);
        BaseXLayout.setWidth(this.detail, 400);
        BaseXLayout.setWidth(this.doc1, 400);
        BaseXLayout.setWidth(this.doc2, 400);
        this.set(this.choice, "Center");
        this.set(tabs, "East");
        this.action(null);
        if (!dbs.isEmpty()) {
            this.finish(null);
        }
    }

    public boolean nodb() {
        return this.choice.getList().length == 0;
    }

    @Override
    public void action(Object cmp) {
        Context ctx = this.gui.context;
        if (this.refresh) {
            this.choice.setData(ctx.databases.list().toArray());
            this.choice.requestFocusInWindow();
            this.refresh = false;
        }
        StringList dbs = this.choice.getValues();
        String db = this.choice.getValue();
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (cmp == this.open) {
            this.close();
        } else if (cmp == this.drop) {
            for (String s : dbs) {
                if (!ctx.globalopts.dbexists(s)) continue;
                cmds.add(new DropDB(s));
            }
            if (!BaseXDialog.confirm(this.gui, Util.info(Text.DROPPING_DB_X, cmds.size()))) {
                return;
            }
            this.refresh = true;
        } else if (cmp == this.rename) {
            DialogInput dr = new DialogInput(db, Text.RENAME_DB, this, 1);
            if (!dr.ok() || dr.input().equals(db)) {
                return;
            }
            cmds.add(new AlterDB(db, dr.input()));
            this.refresh = true;
        } else if (cmp == this.copy) {
            DialogInput dc = new DialogInput(db, Text.COPY_DB, this, 2);
            if (!dc.ok() || dc.input().equals(db)) {
                return;
            }
            cmds.add(new Copy(db, dc.input()));
            this.refresh = true;
        } else if (cmp == this.backup) {
            for (String s : dbs) {
                cmds.add(new CreateBackup(s));
            }
        } else if (cmp == this.restore) {
            if (!this.gui.context.globalopts.dbexists(db) || BaseXDialog.confirm(this.gui, Text.OVERWRITE_DB_QUESTION)) {
                cmds.add(new Restore(this.backups.getValue()));
            }
        } else if (cmp != this.backups) {
            if (cmp == this.delete) {
                cmds.add(new DropBackup(this.backups.getValue()));
                this.refresh = this.backups.getList().length == 1;
                this.backups.requestFocusInWindow();
            } else if (cmp == this.deleteAll) {
                String[] back = this.backups.getList();
                if (!BaseXDialog.confirm(this.gui, Util.info(Text.DROP_BACKUPS_X, back.length))) {
                    return;
                }
                for (String b : back) {
                    cmds.add(new DropBackup(b));
                }
                this.refresh = true;
            } else {
                String title = dbs.size() == 1 ? db : dbs.size() + " " + Text.DATABASES;
                this.doc1.setText(title);
                this.doc2.setText(Text.BACKUPS + ": " + title);
                boolean active = ctx.globalopts.dbexists(db);
                String info = "";
                if (active) {
                    MetaData meta = new MetaData(db, ctx);
                    try {
                        meta.read();
                        info = InfoDB.db(meta, true, true, true);
                    }
                    catch (IOException ex) {
                        info = Util.message(ex);
                    }
                } else if (dbs.size() == 1) {
                    info = Text.ONLY_BACKUP;
                }
                this.detail.setText(info);
                this.rename.setEnabled(active);
                this.copy.setEnabled(active);
                this.open.setEnabled(active);
                this.restore.setEnabled(active);
                active = false;
                for (String d : dbs) {
                    active |= ctx.globalopts.dbexists(d);
                }
                this.drop.setEnabled(active);
                this.backup.setEnabled(active);
                StringList names = ctx.databases.backups(db);
                active = !names.isEmpty();
                this.backups.setData(names.toArray());
                this.backups.setEnabled(active);
                this.restore.setEnabled(active);
                this.delete.setEnabled(active);
                this.deleteAll.setEnabled(active);
            }
        }
        if (!cmds.isEmpty()) {
            DialogProgress.execute((BaseXDialog)this, cmds.toArray(new Command[cmds.size()]));
        }
    }

    @Override
    public void close() {
        String db = this.choice.getValue();
        if (this.gui.context.globalopts.dbexists(db)) {
            DialogProgress.execute((BaseXDialog)this, new Open(db));
            this.dispose();
        }
    }
}

