/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.TextPanel;
import org.basex.util.Token;

public final class DialogMessage
extends BaseXDialog {
    private final BaseXButton yes;
    private boolean canceled = true;
    private BaseXButton no;

    public DialogMessage(GUI main, String txt, GUIConstants.Msg ic) {
        super(main, ic == GUIConstants.Msg.ERROR ? Text.ERROR : Text.INFORMATION);
        BaseXBack buttons;
        this.panel.setLayout(new BorderLayout());
        BaseXBack back = new BaseXBack(new TableLayout(1, 2, 12, 0));
        BaseXLabel b = new BaseXLabel();
        b.setIcon(ic.large);
        back.add(b);
        TextPanel text = new TextPanel(Token.token(txt), false, this);
        text.setFont(b.getFont());
        back.add(text);
        this.set(back, "North");
        if (ic == GUIConstants.Msg.QUESTION || ic == GUIConstants.Msg.YESNOCANCEL) {
            this.yes = new BaseXButton(Text.B_YES, this);
            this.no = new BaseXButton(Text.B_NO, this);
            buttons = ic == GUIConstants.Msg.QUESTION ? this.newButtons(this.yes, this.no) : this.newButtons(this.yes, this.no, new BaseXButton(Text.CANCEL, this));
        } else {
            this.yes = new BaseXButton(Text.B_OK, this);
            buttons = this.newButtons(this.yes);
        }
        this.set(buttons, "South");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogMessage.this.yes.requestFocusInWindow();
            }
        });
        this.finish(null);
    }

    @Override
    public void action(Object cmp) {
        boolean bl = this.canceled = cmp != this.yes && cmp != this.no;
        if (cmp == this.yes) {
            this.close();
        } else {
            this.cancel();
        }
    }

    public boolean canceled() {
        return this.canceled;
    }
}

