/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.basex.build.xml.CatalogWrapper;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;

final class DialogXmlParser
extends DialogParser {
    private final BaseXCheckBox intparse;
    private final BaseXCheckBox dtd;
    private final BaseXCheckBox chopWS;
    private final BaseXCheckBox stripNS;
    private final BaseXCheckBox usecat;
    private final BaseXTextField cfile;
    private final BaseXButton browsec;

    DialogXmlParser(BaseXDialog d, MainOptions opts) {
        super(d);
        BaseXBack pp = new BaseXBack(new TableLayout(9, 1));
        this.intparse = new BaseXCheckBox(Text.INT_PARSER, MainOptions.INTPARSE, opts, d).bold();
        pp.add(this.intparse);
        pp.add(new BaseXLabel(Text.H_INT_PARSER, true, false));
        this.dtd = new BaseXCheckBox(Text.PARSE_DTDS, MainOptions.DTD, opts, d).bold();
        pp.add(this.dtd);
        this.stripNS = new BaseXCheckBox(Text.STRIP_NS, MainOptions.STRIPNS, opts, d).bold();
        pp.add(this.stripNS);
        this.chopWS = new BaseXCheckBox(Text.CHOP_WS, MainOptions.CHOP, opts, d).bold();
        pp.add(this.chopWS);
        pp.add(new BaseXLabel(Text.H_CHOP_WS, false, false).border(0, 0, 8, 0));
        pp.add(new BaseXLabel());
        boolean cat = !opts.get(MainOptions.CATFILE).isEmpty();
        this.usecat = new BaseXCheckBox(Text.USE_CATALOG_FILE, cat, d).bold();
        boolean rsen = CatalogWrapper.available();
        BaseXBack cr = new BaseXBack(new TableLayout(2, 2, 8, 0));
        this.usecat.setEnabled(rsen);
        cr.add(this.usecat);
        cr.add(new BaseXLabel());
        this.cfile = new BaseXTextField(opts.get(MainOptions.CATFILE), d);
        this.cfile.setEnabled(rsen);
        cr.add(this.cfile);
        this.browsec = new BaseXButton(Text.BROWSE_D, d);
        this.browsec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIOptions gopts = DialogXmlParser.this.dialog.gui.gopts;
                BaseXFileChooser fc = new BaseXFileChooser(Text.FILE_OR_DIR, gopts.get(GUIOptions.INPUTPATH), DialogXmlParser.this.dialog.gui).filter("XML Documents", ".xml");
                IOFile file = fc.select(BaseXFileChooser.Mode.FDOPEN);
                if (file != null) {
                    DialogXmlParser.this.cfile.setText(file.path());
                }
            }
        });
        this.browsec.setEnabled(rsen);
        cr.add(this.browsec);
        pp.add(cr);
        if (!rsen) {
            BaseXBack rs = new BaseXBack(new TableLayout(2, 1));
            rs.add(new BaseXLabel(Text.HELP1_USE_CATALOG).color(GUIConstants.DGRAY));
            rs.add(new BaseXLabel(Text.HELP2_USE_CATALOG).color(GUIConstants.DGRAY));
            pp.add(rs);
        }
        this.add((Component)pp, "West");
        boolean ip = this.intparse.isSelected();
        boolean uc = this.usecat.isSelected();
        this.intparse.setEnabled(!uc);
        this.usecat.setEnabled(!ip && CatalogWrapper.available());
        this.cfile.setEnabled(uc);
        this.browsec.setEnabled(uc);
    }

    @Override
    boolean action(boolean active) {
        boolean ip = this.intparse.isSelected();
        boolean uc = this.usecat.isSelected();
        this.intparse.setEnabled(!uc);
        this.usecat.setEnabled(!ip && CatalogWrapper.available());
        this.cfile.setEnabled(uc);
        this.browsec.setEnabled(uc);
        return true;
    }

    @Override
    void update() {
    }

    @Override
    void setOptions(GUI gui) {
        gui.set(MainOptions.CHOP, this.chopWS.isSelected());
        gui.set(MainOptions.STRIPNS, this.stripNS.isSelected());
        gui.set(MainOptions.DTD, this.dtd.isSelected());
        gui.set(MainOptions.INTPARSE, this.intparse.isSelected());
        gui.set(MainOptions.CATFILE, this.usecat.isSelected() ? this.cfile.getText() : "");
    }
}

