/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Font;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXHistory;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextHint;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.basex.util.options.StringsOption;

public class BaseXTextField
extends JTextField {
    public static final int DWIDTH = 350;
    private Options options;
    private Option<?> option;
    private BaseXHistory history;
    private BaseXTextHint hint;
    private String last = "";
    private int hist;

    public BaseXTextField(GUI gui) {
        this(null, gui, null);
    }

    public BaseXTextField(BaseXDialog dialog) {
        this(null, dialog, dialog);
    }

    public BaseXTextField(NumberOption opt, Options opts, BaseXDialog dialog) {
        this((Option<?>)opt, opts, dialog);
    }

    private BaseXTextField(Option<?> opt, Options opts, BaseXDialog dialog) {
        this(opts.get(opt).toString(), dialog, dialog);
        this.options = opts;
        this.option = opt;
    }

    public BaseXTextField(String text, BaseXDialog dialog) {
        this(text, dialog, dialog);
    }

    private BaseXTextField(String text, Window win, BaseXDialog dialog) {
        BaseXLayout.setWidth(this, 350);
        BaseXLayout.addInteraction(this, win);
        if (text != null) {
            this.setText(text);
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseXTextField.this.selectAll();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.UNDOSTEP.is(e) || BaseXKeys.REDOSTEP.is(e)) {
                    String t = BaseXTextField.this.getText();
                    BaseXTextField.this.setText(BaseXTextField.this.last);
                    BaseXTextField.this.last = t;
                }
            }
        });
        if (dialog != null) {
            this.addKeyListener(dialog.keys);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.hint != null) {
            this.hint.setFont(f);
        }
    }

    public void history(final StringsOption so, Window win) {
        GUI gui;
        BaseXDialog dialog;
        if (win instanceof BaseXDialog) {
            dialog = (BaseXDialog)win;
            gui = dialog.gui;
        } else {
            dialog = null;
            gui = (GUI)win;
        }
        this.history = new BaseXHistory(gui, so);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.ENTER.is(e)) {
                    BaseXTextField.this.store();
                } else if (BaseXKeys.NEXTLINE.is(e) || BaseXKeys.PREVLINE.is(e)) {
                    boolean next = BaseXKeys.NEXTLINE.is(e);
                    String[] qu = gui.gopts.get(so);
                    if (qu.length == 0) {
                        return;
                    }
                    BaseXTextField.this.hist = next ? Math.min(qu.length - 1, BaseXTextField.this.hist + 1) : Math.max(0, BaseXTextField.this.hist - 1);
                    BaseXTextField.this.setText(qu[BaseXTextField.this.hist]);
                    if (dialog != null) {
                        dialog.action(this);
                    }
                }
            }
        });
    }

    public void store() {
        if (this.history == null) {
            return;
        }
        this.history.store(this.getText());
        this.hist = 0;
    }

    public void hint(String label) {
        if (this.hint == null) {
            this.hint = new BaseXTextHint(label + "...", this);
        } else {
            this.hint.setText(label + "...");
        }
        this.setToolTipText(label);
    }

    @Override
    public void setText(String txt) {
        this.last = txt;
        super.setText(txt);
    }

    public void assign() {
        if (this.option instanceof NumberOption) {
            try {
                this.options.set((NumberOption)this.option, Integer.parseInt(this.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.options.set((StringOption)this.option, this.getText());
        }
    }
}

