/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.MatteBorder;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.dialog.DialogLine;
import org.basex.gui.dialog.DialogSort;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXScrollBar;
import org.basex.gui.layout.GUICode;
import org.basex.gui.text.LinkListener;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.SyntaxJSON;
import org.basex.gui.text.SyntaxXML;
import org.basex.gui.text.SyntaxXQuery;
import org.basex.gui.text.TextEditor;
import org.basex.gui.text.TextIterator;
import org.basex.gui.text.TextRenderer;
import org.basex.io.IO;
import org.basex.util.History;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;

public class TextPanel
extends BaseXPanel {
    private static final int ERROR_DELAY = 500;
    protected final TextEditor editor;
    public final History hist;
    public SearchBar search;
    private final TextRenderer rend;
    private final BaseXScrollBar scroll;
    private final boolean editable;
    private LinkListener linkListener;
    private int errorID;
    public final GUICode scrollCode = new GUICode(){

        @Override
        public void execute(Object down) {
            TextPanel.this.rend.updateScrollbar();
            TextPanel.this.cursorCode.execute((Boolean)down != false ? 2 : 0);
        }
    };
    private final GUICode cursorCode = new GUICode(){

        @Override
        public void execute(Object algn) {
            int y;
            int m;
            int p = TextPanel.this.scroll.pos();
            if (p < (m = (y = TextPanel.this.rend.cursorY()) + TextPanel.this.rend.fontHeight() * 3 - TextPanel.this.getHeight()) || p > y) {
                int align = (Integer)algn;
                TextPanel.this.scroll.pos(align == 0 ? y : (align == 1 ? y - TextPanel.this.getHeight() / 2 : m));
                TextPanel.this.rend.repaint();
            }
        }
    };
    private int lastCol = -1;
    private final Timer caretTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextPanel.this.rend.caret(!TextPanel.this.rend.caret());
        }
    });
    private final GUICode resizeCode = new GUICode(){

        @Override
        public void execute(Object arg) {
            TextPanel.this.rend.updateScrollbar();
            TextPanel.this.scroll.pos(TextPanel.this.scroll.pos());
            TextPanel.this.rend.repaint();
        }
    };

    public TextPanel(boolean edit, Window win) {
        this(Token.EMPTY, edit, win);
    }

    public TextPanel(byte[] txt, boolean edit, Window win) {
        super(win);
        GUICommand[] gUICommandArray;
        this.editable = edit;
        this.editor = new TextEditor(this.gui);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(!edit);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (TextPanel.this.isEnabled()) {
                    TextPanel.this.caret(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextPanel.this.caret(false);
                TextPanel.this.rend.caret(false);
            }
        });
        this.setFont(GUIConstants.dmfont);
        this.layout(new BorderLayout());
        this.scroll = new BaseXScrollBar(this);
        this.rend = new TextRenderer(this.editor, this.scroll, this.editable, this.gui);
        this.add((Component)this.rend, "Center");
        this.add((Component)this.scroll, "East");
        this.setText(txt);
        this.hist = new History(edit ? this.editor.text() : null);
        if (edit) {
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 0, 0, GUIConstants.color(6)));
        } else {
            this.mode(GUIConstants.Fill.NONE);
        }
        if (edit) {
            GUICommand[] gUICommandArray2 = new GUICommand[14];
            gUICommandArray2[0] = new FindCmd();
            gUICommandArray2[1] = new FindNextCmd();
            gUICommandArray2[2] = new FindPrevCmd();
            gUICommandArray2[3] = null;
            gUICommandArray2[4] = new GotoCmd();
            gUICommandArray2[5] = null;
            gUICommandArray2[6] = new UndoCmd();
            gUICommandArray2[7] = new RedoCmd();
            gUICommandArray2[8] = null;
            gUICommandArray2[9] = new AllCmd();
            gUICommandArray2[10] = new CutCmd();
            gUICommandArray2[11] = new CopyCmd();
            gUICommandArray2[12] = new PasteCmd();
            gUICommandArray = gUICommandArray2;
            gUICommandArray2[13] = new DelCmd();
        } else {
            GUICommand[] gUICommandArray3 = new GUICommand[8];
            gUICommandArray3[0] = new FindCmd();
            gUICommandArray3[1] = new FindNextCmd();
            gUICommandArray3[2] = new FindPrevCmd();
            gUICommandArray3[3] = null;
            gUICommandArray3[4] = new GotoCmd();
            gUICommandArray3[5] = null;
            gUICommandArray3[6] = new AllCmd();
            gUICommandArray = gUICommandArray3;
            gUICommandArray3[7] = new CopyCmd();
        }
        new BaseXPopup(this, gUICommandArray);
    }

    public void setText(String t) {
        this.setText(Token.token(t));
    }

    public void setText(byte[] t) {
        this.setText(t, t.length);
        this.resetError();
    }

    public String searchString() {
        String string = this.editor.copy();
        return string.isEmpty() || string.contains("\n") ? null : string;
    }

    public final int[] pos() {
        return this.rend.pos();
    }

    public final void setText(byte[] t, int s) {
        byte[] txt = t;
        if (Token.contains(t, 13)) {
            int ns = 0;
            for (int r = 0; r < s; ++r) {
                byte b = t[r];
                if (b == 13) continue;
                t[ns++] = b;
            }
            txt = Arrays.copyOf(t, ns);
        }
        if (this.editor.text(txt) && this.hist != null) {
            this.hist.store(txt, this.editor.pos(), 0);
        }
        this.componentResized(null);
    }

    protected final void setSyntax(IO file, boolean opened) {
        this.setSyntax(!opened || file.hasSuffix(IO.XQSUFFIXES) ? new SyntaxXQuery() : (file.hasSuffix(".json") ? new SyntaxJSON() : (file.hasSuffix(IO.XMLSUFFIXES) || file.hasSuffix(IO.HTMLSUFFIXES) || file.hasSuffix(IO.XSLSUFFIXES) || file.hasSuffix(".bxs") ? new SyntaxXML() : Syntax.SIMPLE)));
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setSyntax(Syntax syntax) {
        this.rend.setSyntax(syntax);
    }

    public final void setCaret(int pos) {
        this.editor.pos(pos);
        this.cursorCode.invokeLater(1);
        this.caret(true);
    }

    public final int getCaret() {
        return this.editor.pos();
    }

    public final void scrollToEnd() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextPanel.this.editor.pos(TextPanel.this.editor.size());
                TextPanel.this.cursorCode.execute(2);
            }
        });
    }

    public final byte[] getText() {
        return this.editor.text();
    }

    public final boolean selected() {
        return this.editor.selected();
    }

    @Override
    public final void setFont(Font f) {
        super.setFont(f);
        if (this.rend != null) {
            this.rend.setFont(f);
            this.scrollCode.invokeLater(true);
        }
    }

    public final void resetError() {
        ++this.errorID;
        this.editor.error(-1);
        this.rend.repaint();
    }

    public final void error(int pos) {
        final int eid = ++this.errorID;
        this.editor.error(pos);
        new Thread(){

            @Override
            public void run() {
                Performance.sleep(500L);
                if (eid == TextPanel.this.errorID) {
                    TextPanel.this.rend.repaint();
                }
            }
        }.start();
    }

    public void comment() {
        int caret = this.editor.pos();
        if (this.editor.comment(this.rend.getSyntax())) {
            this.hist.store(this.editor.text(), caret, this.editor.pos());
        }
        this.scrollCode.invokeLater(true);
    }

    public void sort() {
        DialogSort ds = new DialogSort(this.gui);
        if (!ds.ok()) {
            return;
        }
        int caret = this.editor.pos();
        if (this.editor.sort()) {
            this.hist.store(this.editor.text(), caret, this.editor.pos());
        }
        this.scrollCode.invokeLater(true);
    }

    public void format() {
        int caret = this.editor.pos();
        if (this.editor.format(this.rend.getSyntax())) {
            this.hist.store(this.editor.text(), caret, this.editor.pos());
        }
        this.scrollCode.invokeLater(true);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.rend.setEnabled(enabled);
        this.scroll.setEnabled(enabled);
        this.caret(enabled);
    }

    final void selectAll() {
        this.editor.select(0, this.editor.size());
        this.rend.repaint();
    }

    public final void setLinkListener(LinkListener ll) {
        this.linkListener = ll;
    }

    final void setSearch(SearchBar s) {
        this.search = s;
    }

    public final SearchBar getSearch() {
        return this.search;
    }

    final void search(SearchContext sc, boolean jump) {
        try {
            this.rend.search(sc);
            this.gui.status.setText(sc.search.isEmpty() ? "OK" : Util.info(Text.STRINGS_FOUND_X, sc.nr()));
            if (jump) {
                this.jump(SearchDir.CURRENT, false);
            }
        }
        catch (Exception ex) {
            String msg = Util.message(ex).replaceAll(Prop.NL + ".*", "");
            this.gui.status.setError(Text.REGULAR_EXPR + ": " + msg);
        }
    }

    final void replace(ReplaceContext rc) {
        try {
            int[] select = this.rend.replace(rc);
            if (rc.text != null) {
                boolean sel = this.editor.selected();
                this.setText(rc.text);
                this.editor.select(select[0], select[sel ? 1 : 0]);
                this.release(Action.CHECK);
            }
            this.gui.status.setText(Util.info(Text.STRINGS_REPLACED, new Object[0]));
        }
        catch (Exception ex) {
            String msg = Util.message(ex).replaceAll(Prop.NL + ".*", "");
            this.gui.status.setError(Text.REGULAR_EXPR + ": " + msg);
        }
    }

    protected final void jump(SearchDir dir, boolean select) {
        int y = this.rend.jump(dir, select);
        int h = this.getHeight();
        int p = this.scroll.pos();
        int m = y + this.rend.fontHeight() * 3 - h;
        if (y != -1 && (p < m || p > y)) {
            this.scroll.pos(y - h / 2);
        }
        this.rend.repaint();
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        this.gui.cursor(GUIConstants.CURSORTEXT);
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.gui.cursor(GUIConstants.CURSORARROW);
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        if (this.linkListener == null) {
            return;
        }
        TextIterator iter = this.rend.jump(e.getPoint());
        this.gui.cursor(iter.link() != null ? GUIConstants.CURSORHAND : GUIConstants.CURSORARROW);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.linkListener == null) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            TextIterator iter;
            String link;
            this.editor.endSelection();
            if (!this.editor.selected() && (link = (iter = this.rend.jump(e.getPoint())).link()) != null) {
                this.linkListener.linkClicked(link);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isMiddleMouseButton(e)) {
            return;
        }
        new PasteCmd().execute(this.gui);
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.select(e.getPoint(), false);
        int y = Math.max(20, Math.min(e.getY(), this.getHeight() - 20));
        if (y != e.getY()) {
            this.scroll.pos(this.scroll.pos() + e.getY() - y);
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (!this.isEnabled() || !this.isFocusable()) {
            return;
        }
        this.requestFocusInWindow();
        this.caret(true);
        if (SwingUtilities.isMiddleMouseButton(e)) {
            this.copy();
        }
        boolean shift = e.isShiftDown();
        boolean selected = this.editor.selected();
        if (SwingUtilities.isLeftMouseButton(e)) {
            int c = e.getClickCount();
            if (c == 1) {
                if (shift) {
                    this.editor.startSelection(true);
                }
                this.select(e.getPoint(), !shift);
            } else if (c == 2) {
                this.editor.selectWord();
            } else {
                this.editor.selectLine();
            }
        } else if (!selected) {
            this.select(e.getPoint(), true);
        }
    }

    private void select(Point point, boolean start) {
        this.editor.select(this.rend.jump(point).pos(), start);
        this.rend.repaint();
    }

    private boolean specialKey(KeyEvent e) {
        if (BaseXKeys.PREVTAB.is(e)) {
            this.gui.editor.tab(false);
        } else if (BaseXKeys.NEXTTAB.is(e)) {
            this.gui.editor.tab(true);
        } else if (BaseXKeys.CLOSETAB.is(e)) {
            this.gui.editor.close(null);
        } else if (this.search != null && BaseXKeys.ESCAPE.is(e)) {
            this.search.deactivate(true);
        } else {
            return false;
        }
        e.consume();
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        byte[] tmp;
        if (this.specialKey(e) || BaseXKeys.modifier(e)) {
            return;
        }
        this.caret(true);
        int fh = this.rend.fontHeight();
        if (BaseXKeys.SCROLLDOWN.is(e)) {
            this.scroll.pos(this.scroll.pos() + fh);
            return;
        }
        if (BaseXKeys.SCROLLUP.is(e)) {
            this.scroll.pos(this.scroll.pos() - fh);
            return;
        }
        boolean selected = this.editor.selected();
        int pos = this.editor.pos();
        boolean shift = e.isShiftDown();
        boolean down = true;
        boolean consumed = true;
        int lc = Integer.MIN_VALUE;
        byte[] txt = this.editor.text();
        if (BaseXKeys.NEXTWORD.is(e)) {
            this.editor.nextWord(shift);
        } else if (BaseXKeys.PREVWORD.is(e)) {
            this.editor.prevWord(shift);
            down = false;
        } else if (BaseXKeys.TEXTSTART.is(e)) {
            this.editor.textStart(shift);
            down = false;
        } else if (BaseXKeys.TEXTEND.is(e)) {
            this.editor.textEnd(shift);
        } else if (BaseXKeys.LINESTART.is(e)) {
            this.editor.lineStart(shift);
            down = false;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.editor.lineEnd(shift);
        } else if (BaseXKeys.PREVPAGE_RO.is(e) && !this.hist.active()) {
            lc = this.editor.linesUp(this.getHeight() / fh, false, this.lastCol);
            down = false;
        } else if (BaseXKeys.NEXTPAGE_RO.is(e) && !this.hist.active()) {
            lc = this.editor.linesDown(this.getHeight() / fh, false, this.lastCol);
        } else if (BaseXKeys.PREVPAGE.is(e)) {
            lc = this.editor.linesUp(this.getHeight() / fh, shift, this.lastCol);
            down = false;
        } else if (BaseXKeys.NEXTPAGE.is(e)) {
            lc = this.editor.linesDown(this.getHeight() / fh, shift, this.lastCol);
        } else if (BaseXKeys.NEXTLINE.is(e) && !BaseXKeys.MOVEDOWN.is(e)) {
            lc = this.editor.linesDown(1, shift, this.lastCol);
        } else if (BaseXKeys.PREVLINE.is(e) && !BaseXKeys.MOVEUP.is(e)) {
            lc = this.editor.linesUp(1, shift, this.lastCol);
            down = false;
        } else if (BaseXKeys.NEXTCHAR.is(e)) {
            this.editor.next(shift);
        } else if (BaseXKeys.PREVCHAR.is(e)) {
            this.editor.previous(shift);
            down = false;
        } else {
            consumed = false;
        }
        int n = this.lastCol = lc == Integer.MIN_VALUE ? -1 : lc;
        if (this.hist.active()) {
            if (BaseXKeys.MOVEDOWN.is(e)) {
                this.editor.move(true);
            } else if (BaseXKeys.MOVEUP.is(e)) {
                this.editor.move(false);
            } else if (BaseXKeys.COMPLETE.is(e)) {
                this.editor.complete();
            } else if (BaseXKeys.DELLINE.is(e)) {
                this.editor.deleteLine();
            } else if (BaseXKeys.DELNEXTWORD.is(e)) {
                this.editor.deleteNext(true);
            } else if (BaseXKeys.DELLINEEND.is(e)) {
                this.editor.deleteNext(false);
            } else if (BaseXKeys.DELNEXT.is(e)) {
                this.editor.delete();
            } else if (BaseXKeys.DELPREVWORD.is(e)) {
                this.editor.deletePrev(true);
                down = false;
            } else if (BaseXKeys.DELLINESTART.is(e)) {
                this.editor.deletePrev(false);
                down = false;
            } else if (BaseXKeys.DELPREV.is(e)) {
                this.editor.deletePrev();
                down = false;
            } else {
                consumed = false;
            }
        }
        if (consumed) {
            e.consume();
        }
        if (txt != (tmp = this.editor.text())) {
            this.hist.store(tmp, pos, this.editor.pos());
            this.scrollCode.invokeLater(down);
        } else if (pos != this.editor.pos() || selected != this.editor.selected()) {
            this.cursorCode.invokeLater(down ? 2 : 0);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        boolean selected;
        if (!this.hist.active() || BaseXKeys.control(e) || BaseXKeys.DELNEXT.is(e) || BaseXKeys.DELPREV.is(e) || BaseXKeys.ESCAPE.is(e)) {
            return;
        }
        int caret = this.editor.pos();
        StringBuilder sb = new StringBuilder(1).append(e.getKeyChar());
        boolean indent = BaseXKeys.TAB.is(e) && this.editor.indent(sb, e.isShiftDown());
        boolean bl = selected = this.editor.selected() && !indent;
        if (selected) {
            this.editor.delete();
        }
        int move = BaseXKeys.ENTER.is(e) ? this.editor.enter(sb) : this.editor.add(sb, selected);
        this.hist.store(this.editor.text(), caret, this.editor.pos());
        if (move != 0) {
            this.editor.pos(Math.min(this.editor.size(), caret + move));
        }
        this.scrollCode.invokeLater(true);
        e.consume();
    }

    protected void release(Action action) {
    }

    final boolean copy() {
        String txt = this.editor.copy();
        if (txt.isEmpty()) {
            return false;
        }
        BaseXLayout.copy(txt);
        return true;
    }

    private static String clip() {
        Iterator<Object> i$;
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable tr = clip.getContents(null);
        if (tr != null && (i$ = BaseXLayout.contents(tr).iterator()).hasNext()) {
            Object o = i$.next();
            return o.toString();
        }
        return null;
    }

    void finish(int old) {
        if (old != -1) {
            this.hist.store(this.editor.text(), old, this.editor.pos());
        }
        this.scrollCode.invokeLater(true);
        this.release(Action.CHECK);
    }

    final void caret(boolean start) {
        this.caretTimer.stop();
        if (start) {
            this.caretTimer.start();
        }
        this.rend.caret(start);
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        this.scroll.pos(this.scroll.pos() + e.getUnitsToScroll() * 20);
        this.rend.repaint();
    }

    @Override
    public final void componentResized(ComponentEvent e) {
        this.resizeCode.invokeLater();
    }

    private void find(boolean next) {
        boolean vis = this.search.isVisible();
        this.search.activate(this.searchString(), false);
        this.jump(vis ? (next ? SearchDir.FORWARD : SearchDir.BACKWARD) : SearchDir.CURRENT, true);
    }

    private void gotoLine() {
        byte[] last = this.editor.text();
        int ll = last.length;
        int cr = this.getCaret();
        int l = 1;
        for (int e = 0; e < ll && e < cr; e += Token.cl(last, e)) {
            if (last[e] != 10) continue;
            ++l;
        }
        DialogLine dl = new DialogLine(this.gui, l);
        if (!dl.ok()) {
            return;
        }
        int el = dl.line();
        l = 1;
        int p = 0;
        for (int e = 0; e < ll && l < el; e += Token.cl(last, e)) {
            if (last[e] != 10) continue;
            p = e + 1;
            ++l;
        }
        this.setCaret(p);
        this.gui.editor.posCode.invokeLater();
    }

    class GotoCmd
    extends GUIPopupCmd {
        GotoCmd() {
            super(Text.GO_TO_LINE + "...", BaseXKeys.GOTOLINE);
        }

        @Override
        public void execute() {
            TextPanel.this.gotoLine();
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }
    }

    class FindPrevCmd
    extends GUIPopupCmd {
        FindPrevCmd() {
            super(Text.FIND_PREVIOUS, BaseXKeys.FINDPREV1, BaseXKeys.FINDPREV2);
        }

        @Override
        public void execute() {
            TextPanel.this.find(false);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }
    }

    class FindNextCmd
    extends GUIPopupCmd {
        FindNextCmd() {
            super(Text.FIND_NEXT, BaseXKeys.FINDNEXT1, BaseXKeys.FINDNEXT2);
        }

        @Override
        public void execute() {
            TextPanel.this.find(true);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }
    }

    class FindCmd
    extends GUIPopupCmd {
        FindCmd() {
            super(Text.FIND + "...", BaseXKeys.FIND);
        }

        @Override
        public void execute() {
            TextPanel.this.search.activate(TextPanel.this.searchString(), true);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.search != null;
        }
    }

    class AllCmd
    extends GUIPopupCmd {
        AllCmd() {
            super(Text.SELECT_ALL, BaseXKeys.SELECTALL);
        }

        @Override
        public void execute() {
            TextPanel.this.selectAll();
        }
    }

    class DelCmd
    extends GUIPopupCmd {
        DelCmd() {
            super(Text.DELETE, BaseXKeys.DELNEXT);
        }

        @Override
        public void execute() {
            int pos = TextPanel.this.editor.pos();
            TextPanel.this.editor.delete();
            TextPanel.this.finish(pos);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.hist.active() && TextPanel.this.editor.selected();
        }
    }

    class PasteCmd
    extends GUIPopupCmd {
        PasteCmd() {
            super(Text.PASTE, BaseXKeys.PASTE1, BaseXKeys.PASTE2);
        }

        @Override
        public void execute() {
            int pos = TextPanel.this.editor.pos();
            String clip = TextPanel.clip();
            if (clip == null) {
                return;
            }
            if (TextPanel.this.editor.selected()) {
                TextPanel.this.editor.delete();
            }
            TextPanel.this.editor.add(clip);
            TextPanel.this.finish(pos);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.hist.active() && TextPanel.clip() != null;
        }
    }

    class CopyCmd
    extends GUIPopupCmd {
        CopyCmd() {
            super(Text.COPY, BaseXKeys.COPY1, BaseXKeys.COPY2);
        }

        @Override
        public void execute() {
            TextPanel.this.copy();
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.editor.selected();
        }
    }

    class CutCmd
    extends GUIPopupCmd {
        CutCmd() {
            super(Text.CUT, BaseXKeys.CUT1, BaseXKeys.CUT2);
        }

        @Override
        public void execute() {
            int pos = TextPanel.this.editor.pos();
            if (!TextPanel.this.copy()) {
                return;
            }
            TextPanel.this.editor.delete();
            TextPanel.this.finish(pos);
        }

        @Override
        public boolean enabled(GUI main) {
            return TextPanel.this.hist.active() && TextPanel.this.editor.selected();
        }
    }

    class RedoCmd
    extends GUIPopupCmd {
        RedoCmd() {
            super(Text.REDO, BaseXKeys.REDOSTEP);
        }

        @Override
        public void execute() {
            if (!TextPanel.this.hist.active()) {
                return;
            }
            byte[] t = TextPanel.this.hist.next();
            if (t == null) {
                return;
            }
            TextPanel.this.editor.text(t);
            TextPanel.this.editor.pos(TextPanel.this.hist.caret());
            TextPanel.this.finish(-1);
        }

        @Override
        public boolean enabled(GUI main) {
            return !TextPanel.this.hist.last();
        }
    }

    class UndoCmd
    extends GUIPopupCmd {
        UndoCmd() {
            super(Text.UNDO, BaseXKeys.UNDOSTEP);
        }

        @Override
        public void execute() {
            if (!TextPanel.this.hist.active()) {
                return;
            }
            byte[] t = TextPanel.this.hist.prev();
            if (t == null) {
                return;
            }
            TextPanel.this.editor.text(t);
            TextPanel.this.editor.pos(TextPanel.this.hist.caret());
            TextPanel.this.finish(-1);
        }

        @Override
        public boolean enabled(GUI main) {
            return !TextPanel.this.hist.first();
        }
    }

    public static enum Action {
        CHECK,
        PARSE,
        EXECUTE;

    }

    public static enum SearchDir {
        CURRENT,
        FORWARD,
        BACKWARD;

    }
}

