/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXScrollBar;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextEditor;
import org.basex.gui.text.TextIterator;
import org.basex.gui.text.TextPanel;
import org.basex.util.list.IntList;

final class TextRenderer
extends BaseXBack {
    public final GUI gui;
    private static final int OFFSET = 5;
    private final TextEditor text;
    private final BaseXScrollBar scroll;
    private final boolean edit;
    private final IntList pars = new IntList();
    private Font font;
    private Font defaultFont;
    private Font boldFont;
    private int fontHeight;
    private int[] charWidths = GUIConstants.mfwidth;
    private int wordWidth;
    private boolean showInvisible;
    private boolean showNL;
    private int margin;
    private int indent;
    private boolean showLines;
    private boolean markline;
    private Color color;
    private int offset;
    private int width;
    private int height;
    private int x;
    private int y;
    private int lineY;
    private int line;
    private boolean lineC;
    private Syntax syntax = Syntax.SIMPLE;
    private boolean caret;
    private boolean highlighted;
    private boolean link;

    TextRenderer(TextEditor t, BaseXScrollBar s, boolean editable, GUI main) {
        this.mode(GUIConstants.Fill.NONE);
        this.text = t;
        this.scroll = s;
        this.edit = editable;
        this.gui = main;
    }

    @Override
    public void setFont(Font f) {
        this.defaultFont = f;
        this.boldFont = f.deriveFont(1);
        this.font(f);
        if (this.gui != null) {
            this.margin = this.gui.gopts.get(GUIOptions.SHOWMARGIN) != false ? Math.max(this.gui.gopts.get(GUIOptions.MARGIN), 1) : -1;
            this.showInvisible = this.gui.gopts.get(GUIOptions.SHOWINVISIBLE);
            this.showNL = this.gui.gopts.get(GUIOptions.SHOWNL);
            this.showLines = this.gui.gopts.get(GUIOptions.SHOWLINES);
            this.markline = this.gui.gopts.get(GUIOptions.MARKLINE);
            this.indent = Math.max(1, this.gui.gopts.get(GUIOptions.INDENT));
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.pars.reset();
        TextIterator iter = this.init(g, false);
        int oldL = 0;
        while (this.more(iter, g)) {
            if (this.line != oldL && this.y >= 0) {
                this.drawLineNumber(g);
                oldL = this.line;
            }
            this.write(iter, g);
        }
        if (this.x == this.offset) {
            this.markLine(g);
        }
        if (this.line != oldL) {
            this.drawLineNumber(g);
        }
        this.wordWidth = 0;
        int s = iter.pos();
        if (this.caret && s == iter.caret()) {
            this.drawCaret(g, this.x);
        }
        if (s == iter.error()) {
            this.drawError(g);
        }
        this.drawLinesSep(g);
    }

    private void drawLineNumber(Graphics g) {
        if (this.edit && this.showLines) {
            g.setColor(GUIConstants.GRAY);
            String s = Integer.toString(this.line);
            g.drawString(s, this.offset - this.fontWidth(g, s) - 10, this.y);
        }
    }

    private void drawErrorLine(Graphics g) {
        g.setColor(GUIConstants.colormark2A);
        g.fillRect(0, this.lineY, this.offset - 7, this.fontHeight);
    }

    private void drawLinesSep(Graphics g) {
        if (this.edit) {
            int lx;
            if (this.showLines) {
                lx = this.offset - 7;
                g.setColor(GUIConstants.LGRAY);
                g.drawLine(lx, 0, lx, this.height);
            }
            if (this.margin != -1) {
                lx = this.offset + this.fontWidth(g, 32) * this.margin;
                g.setColor(GUIConstants.LGRAY);
                g.drawLine(lx, 0, lx, this.height);
            }
        }
    }

    void search(SearchContext sc) {
        this.text.search(sc);
    }

    int[] replace(ReplaceContext rc) {
        return this.text.replace(rc);
    }

    int jump(TextPanel.SearchDir dir, boolean select) {
        int pos = this.text.jump(dir, select);
        if (pos == -1) {
            return -1;
        }
        int hh = this.height;
        this.height = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g) && iter.pos() < pos) {
            this.next(iter);
        }
        this.height = hh;
        return this.y;
    }

    int[] pos() {
        int hh = this.height;
        this.height = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        boolean more = true;
        int col = 1;
        while (this.more(iter, g)) {
            int p = iter.pos();
            while (iter.more()) {
                boolean bl = more = iter.pos() < iter.caret();
                if (!more) break;
                iter.next();
                ++col;
            }
            if (!more) break;
            iter.pos(p);
            if (!this.next(iter)) continue;
            col = 1;
        }
        this.height = hh;
        return new int[]{this.line, col};
    }

    private void font(Font f) {
        this.font = f;
        this.fontHeight = f.getSize() * 5 / 4;
        this.charWidths = GUIConstants.fontWidths(f);
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        this.width = Integer.MAX_VALUE;
        this.height = Integer.MAX_VALUE;
        TextIterator iter = this.init(g, true);
        int maxX = 0;
        while (this.more(iter, g)) {
            if (iter.curr() == 10) {
                maxX = Math.max(this.x, maxX);
            }
            this.next(iter);
        }
        return new Dimension(Math.max(this.x, maxX) + this.charWidths[32], this.y + this.fontHeight);
    }

    private TextIterator init(Graphics g, boolean start) {
        this.font = this.defaultFont;
        this.syntax.init(this.getForeground());
        TextIterator iter = new TextIterator(this.text);
        this.link = false;
        this.offset = 5;
        if (this.edit && this.showLines) {
            this.offset += this.fontWidth(g, Integer.toString(this.text.lines())) + 10;
        }
        this.x = this.offset;
        this.y = this.fontHeight - (start ? 0 : this.scroll.pos()) - 2;
        this.lineY = this.y - this.fontHeight * 4 / 5;
        this.line = 1;
        boolean bl = this.lineC = this.edit && iter.caretLine(true);
        if (g != null) {
            g.setFont(this.font);
        }
        return iter;
    }

    void updateScrollbar() {
        this.width = this.getWidth() - (this.offset >> 1);
        this.height = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g)) {
            this.next(iter);
        }
        this.height = this.getHeight() + this.fontHeight;
        this.scroll.height(this.y + 5);
    }

    int cursorY() {
        int hh = this.height;
        this.height = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g) && !iter.edited()) {
            this.next(iter);
        }
        this.height = hh;
        return this.y - this.fontHeight;
    }

    private boolean more(TextIterator iter, Graphics g) {
        if (!iter.moreTokens()) {
            return false;
        }
        int ww = 0;
        int p = iter.pos();
        while (iter.more()) {
            int ch = iter.next();
            if (ch == 2) {
                this.font(this.boldFont);
                continue;
            }
            if (ch == 3) {
                this.font(this.defaultFont);
                continue;
            }
            if (ch == 5) {
                this.link ^= true;
                continue;
            }
            ww += this.fontWidth(g, ch);
        }
        iter.pos(p);
        if (this.x + ww > this.width) {
            this.newline(this.fontHeight);
        }
        this.wordWidth = ww;
        return this.y < this.height;
    }

    private void newline(int h) {
        this.x = this.offset;
        this.y += h;
        this.lineY += h;
    }

    private void markLine(Graphics g) {
        if (this.lineC && this.markline) {
            g.setColor(GUIConstants.color4A);
            g.fillRect(0, this.lineY, this.width + this.offset, this.fontHeight);
        }
    }

    private boolean next(TextIterator iter) {
        int ch = iter.curr();
        if (ch == 10 || ch == 1) {
            this.newline(this.fontHeight >> (ch == 10 ? 0 : 1));
            ++this.line;
            this.lineC = this.edit && iter.caretLine(false);
            return true;
        }
        this.x += this.wordWidth;
        return false;
    }

    private void write(TextIterator iter, Graphics g) {
        if (this.x == this.offset) {
            this.markLine(g);
        }
        this.color = this.isEnabled() ? (this.highlighted ? GUIConstants.GREEN : (this.link ? GUIConstants.color4 : this.syntax.getColor(iter))) : Color.gray;
        this.highlighted = false;
        int ch = iter.curr();
        if (ch == 4) {
            this.highlighted = true;
        }
        int cp = iter.pos();
        int cc = iter.caret();
        if (this.y > 0 && this.y < this.height) {
            int cw;
            int xx;
            if (iter.selectStart()) {
                xx = this.x;
                while (!iter.inSelect() && iter.more()) {
                    xx += this.fontWidth(g, iter.next());
                }
                cw = 0;
                while (iter.inSelect() && iter.more()) {
                    cw += this.fontWidth(g, iter.next());
                }
                g.setColor(GUIConstants.color(3));
                g.fillRect(xx, this.lineY, cw, this.fontHeight);
                iter.pos(cp);
            }
            xx = this.x;
            while (iter.more() && iter.searchStart()) {
                while (!iter.inSearch() && iter.more()) {
                    xx += this.fontWidth(g, iter.next());
                }
                cw = 0;
                while (iter.inSearch() && iter.more()) {
                    cw += this.fontWidth(g, iter.next());
                }
                g.setColor(GUIConstants.color2A);
                g.fillRect(xx, this.lineY, cw, this.fontHeight);
                xx += cw;
            }
            iter.pos(cp);
            if (iter.erroneous()) {
                this.drawError(g);
            }
            if (ch == 10 && this.showNL) {
                g.setColor(GUIConstants.GRAY);
                g.drawString("\u00b6", this.x, this.y);
            } else if ((ch == 160 || ch >= 8192 && ch <= 8202) && this.showInvisible) {
                int s = this.fontHeight / 12 + 1;
                g.setColor(GUIConstants.GRAY);
                g.fillRect(this.x + (this.wordWidth >> 1), this.y - this.fontHeight * 3 / 10, s, s);
            } else if (ch == 9 && this.showInvisible) {
                int yy = this.y - this.fontHeight * 3 / 10;
                int s = 1 + this.fontHeight / 12;
                int xe = this.x + this.fontWidth(g, 9) - s;
                int as = s * 2 - 1;
                g.setColor(GUIConstants.GRAY);
                g.drawLine(this.x + s, yy, xe, yy);
                g.drawLine(xe - as, yy - as, xe, yy);
                g.drawLine(xe - as, yy + as, xe, yy);
            } else if (ch > 32) {
                g.setColor(this.color);
                String n = iter.nextString();
                int ww = this.width - this.x;
                if (this.x + this.wordWidth > ww) {
                    int c;
                    int nl = n.length();
                    for (c = 0; c < nl && ww > 0; ww -= this.fontWidth(g, n.charAt(c)), ++c) {
                    }
                    n = n.substring(0, c);
                }
                if (ch != 32) {
                    g.drawString(n, this.x, this.y);
                }
            } else if (ch <= 5) {
                g.setFont(this.font);
            }
            if (this.link) {
                g.drawLine(this.x, this.y + 1, this.x + this.wordWidth, this.y + 1);
            }
            if (this.caret && iter.edited()) {
                xx = this.x;
                while (iter.more()) {
                    if (cc == iter.pos()) {
                        this.drawCaret(g, xx);
                        break;
                    }
                    xx += this.fontWidth(g, iter.next());
                }
                iter.pos(cp);
            }
        }
        if (ch == 40 || ch == 91 || ch == 123) {
            this.pars.add(this.x);
            this.pars.add(this.y);
            this.pars.add(cp);
            this.pars.add(ch);
        } else if (!(ch != 41 && ch != 93 && ch != 125 || this.pars.isEmpty())) {
            int open;
            int n = ch == 41 ? 40 : (open = ch == 93 ? 91 : 123);
            if (this.pars.peek() == open) {
                this.pars.pop();
                int cr = this.pars.pop();
                int yy = this.pars.pop();
                int xx = this.pars.pop();
                if (cc == cp || cc == cr) {
                    g.setColor(GUIConstants.color4);
                    g.drawRect(xx, yy - this.fontHeight * 4 / 5, this.fontWidth(g, open), this.fontHeight);
                    g.drawRect(this.x, this.lineY, this.fontWidth(g, ch), this.fontHeight);
                }
            }
        }
        this.next(iter);
    }

    private void drawCaret(Graphics g, int xx) {
        g.setColor(GUIConstants.DGRAY);
        g.fillRect(xx, this.lineY, 2, this.fontHeight);
    }

    private void drawError(Graphics g) {
        int ww = this.wordWidth == 0 ? this.fontWidth(g, 32) : this.wordWidth;
        int s = Math.max(1, this.fontHeight / 8);
        g.setColor(GUIConstants.LRED);
        g.fillRect(this.x, this.y + 2, ww, s);
        g.setColor(GUIConstants.RED);
        for (int xp = this.x; xp < this.x + ww; ++xp) {
            if ((xp & 1) != 0) continue;
            g.drawLine(xp, this.y + 2, xp, this.y + s + 1);
        }
        if (this.edit) {
            this.drawErrorLine(g);
        }
    }

    private int fontWidth(Graphics g, int cp) {
        return cp < 32 || g == null ? (cp == 9 ? this.charWidths[32] * this.indent : 0) : (cp < 256 ? this.charWidths[cp] : (cp >= 55296 && cp <= 56320 ? 0 : g.getFontMetrics().charWidth(cp)));
    }

    private int fontWidth(Graphics g, String string) {
        int cl = string.length();
        int w = 0;
        for (int c = 0; c < cl; ++c) {
            w += this.fontWidth(g, string.charAt(c));
        }
        return w;
    }

    TextIterator jump(Point p) {
        int xx = p.x;
        int yy = p.y - this.fontHeight / 5;
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, false);
        if (yy > this.y - this.fontHeight) {
            int s = iter.pos();
            while (true) {
                if (xx > this.x && yy < this.y - this.fontHeight) {
                    iter.pos(s);
                    break;
                }
                if (!this.more(iter, g)) {
                    while (iter.more()) {
                        iter.next();
                    }
                    break;
                }
                if (xx <= this.x && yy < this.y) break;
                if (xx > this.x && xx <= this.x + this.wordWidth && yy > this.y - this.fontHeight && yy <= this.y) {
                    int ww;
                    while (iter.more() && xx >= this.x + (ww = this.fontWidth(g, iter.curr()))) {
                        this.x += ww;
                        iter.next();
                    }
                    break;
                }
                s = iter.pos();
                this.next(iter);
            }
        }
        iter.link(this.link);
        return iter;
    }

    int fontHeight() {
        return this.fontHeight;
    }

    void caret(boolean c) {
        this.caret = c;
        this.repaint();
    }

    boolean caret() {
        return this.caret;
    }

    void setSyntax(Syntax s) {
        this.syntax = s;
    }

    Syntax getSyntax() {
        return this.syntax;
    }
}

