/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.project.ProjectFile;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;

public class ProjectList
extends JList {
    private static FontMetrics fm;
    final GUIPopupCmd[] commands = new GUIPopupCmd[]{new GUIPopupCmd(Text.OPEN, new BaseXKeys[]{BaseXKeys.ENTER}){

        @Override
        public void execute() {
            ProjectList.this.open();
        }
    }, new GUIPopupCmd(Text.OPEN_EXTERNALLY, new BaseXKeys[]{BaseXKeys.OPEN}){

        @Override
        public void execute() {
            ProjectList.this.openExternal();
        }
    }, null, new GUIPopupCmd(Text.REFRESH, new BaseXKeys[]{BaseXKeys.REFRESH}){

        @Override
        public void execute() {
            ((ProjectList)ProjectList.this).project.filter.refresh(true);
        }
    }, new GUIPopupCmd(Text.COPY_PATH, new BaseXKeys[]{BaseXKeys.COPYPATH}){

        @Override
        public void execute() {
            if (this.enabled(null)) {
                BaseXLayout.copy(ProjectList.this.selectedValue());
            }
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectList.this.selectedValue() != null;
        }
    }};
    private final ProjectView project;
    private String search;

    ProjectList(ProjectView view) {
        this.project = view;
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ProjectList.this.open();
                }
            }
        });
        new BaseXPopup(this, view.gui, (GUICommand[])this.commands);
    }

    void setElements(final TokenSet elements, final String srch) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int is = elements.size();
                String[] list = new String[is];
                for (int i = 0; i < is; ++i) {
                    list[i] = Token.string(elements.key(i + 1));
                }
                if (ProjectList.this.changed(list)) {
                    Object[] old = ProjectList.this.getSelectedValues();
                    IntList il = new IntList();
                    block1: for (Object o : old) {
                        for (int i = 0; i < is; ++i) {
                            if (!o.equals(elements.key(i + 1))) continue;
                            il.add(i);
                            continue block1;
                        }
                    }
                    ProjectList.this.setListData(list);
                    ProjectList.this.setSelectedIndices(il.toArray());
                }
                ProjectList.this.search = srch;
            }
        });
    }

    boolean changed(String[] list) {
        int sl = list.length;
        int el = this.getModel().getSize();
        if (sl != el) {
            return true;
        }
        for (int i = 0; i < sl; ++i) {
            if (list[i].equals(this.getModel().getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    void open() {
        for (IOFile file : this.selectedValues()) {
            this.project.open(file, this.search);
        }
    }

    void openExternal() {
        for (IOFile file : this.selectedValues()) {
            try {
                file.open();
            }
            catch (IOException ex) {
                BaseXDialog.error(this.project.gui, Util.info(Text.FILE_NOT_OPENED_X, file));
            }
        }
    }

    private String selectedValue() {
        Object[] old = this.getSelectedValues();
        return old.length == 1 ? old[0].toString() : null;
    }

    private IOFile[] selectedValues() {
        if (this.isSelectionEmpty() && this.getModel().getSize() != 0) {
            this.setSelectedIndex(0);
        }
        ArrayList<IOFile> list = new ArrayList<IOFile>();
        for (Object o : this.getSelectedValues()) {
            list.add(new IOFile(o.toString()));
        }
        return list.toArray(new IOFile[list.size()]);
    }

    class CellRenderer
    extends DefaultListCellRenderer {
        private final BaseXLabel label;
        private IOFile file = new IOFile(".");

        CellRenderer() {
            this.label = new BaseXLabel(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    BaseXLayout.hints(g);
                    if (fm == null) {
                        fm = g.getFontMetrics(CellRenderer.this.label.getFont());
                    }
                    int y = Math.min(fm.getHeight(), (int)CellRenderer.this.label.getPreferredSize().getHeight()) - 2;
                    int x = (int)CellRenderer.this.label.getPreferredSize().getWidth() + 2;
                    String s = CellRenderer.this.file.name();
                    g.setColor(CellRenderer.this.label.getForeground());
                    g.drawString(s, x, y);
                    x += fm.stringWidth(s);
                    String[] names = CellRenderer.this.file.file().getParent().split("/|\\\\");
                    StringBuilder sb = new StringBuilder(" ");
                    for (int n = names.length - 1; n >= 0; --n) {
                        sb.append('/').append(names[n]);
                    }
                    g.setColor(GUIConstants.GRAY);
                    g.drawString(sb.toString(), x, y);
                }
            };
            this.label.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean expanded) {
            this.file = new IOFile(value.toString());
            this.label.setIcon(BaseXImages.file(this.file));
            this.label.setText("");
            this.label.setToolTipText(ProjectFile.toString(this.file, true));
            if (selected) {
                this.label.setBackground(ProjectList.this.getSelectionBackground());
                this.label.setForeground(ProjectList.this.getSelectionForeground());
            } else {
                this.label.setBackground(Color.WHITE);
                this.label.setForeground(this.getForeground());
            }
            return this.label;
        }
    }
}

