/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Proc;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.Index;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Util;

public abstract class IndexBuilder
extends Proc {
    protected final Data data;
    protected final int size;
    private final int splitSize;
    private final long maxMem = (long)((double)Runtime.getRuntime().maxMemory() * 0.8);
    protected int pre;
    protected long count;
    protected int splits;
    private int gcCount;

    public abstract Index build() throws IOException;

    protected final void check() {
        this.checkStop();
        if (Prop.debug && (this.pre & 0x1FFFFF) == 0) {
            Util.err(".", new Object[0]);
        }
    }

    protected final boolean split() throws IOException {
        boolean split;
        if (this.splitSize > 0) {
            split = this.count >= ((long)this.splits + 1L) * (long)this.splitSize;
        } else {
            split = Performance.memory() >= this.maxMem;
            int gc = this.gcCount;
            if (split) {
                if (gc >= 0) {
                    throw new BaseXException(Text.OUT_OF_MEM + Text.H_OUT_OF_MEM, new Object[0]);
                }
                gc = 30;
            } else {
                gc = Math.max(-1, gc - 1);
            }
            this.gcCount = gc;
        }
        if (split && Prop.debug) {
            Util.err("|", new Object[0]);
        }
        return split;
    }

    protected final void finishSplit() {
        if (this.splitSize <= 0) {
            Performance.gc(1);
        }
    }

    protected final void finishIndex(Performance perf) {
        if (!Prop.debug) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.splits > 1) {
            sb.append(' ').append(this.splits).append(" splits,");
        }
        sb.append(' ').append(this.count).append(" operations, ");
        sb.append(perf).append(" (").append(Performance.getMemory()).append(')');
        Util.errln(sb, new Object[0]);
    }

    protected IndexBuilder(Data d, int max) {
        this.data = d;
        this.size = this.data.meta.size;
        this.splitSize = max;
        if (Performance.memory() >= this.maxMem) {
            Performance.gc(1);
        }
    }

    @Override
    public final String tit() {
        return Text.CREATING_INDEXES;
    }

    @Override
    public final double prog() {
        return (double)this.pre / (double)(this.size + (this.splits > 0 ? this.size / 50 : 0));
    }
}

