/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.resource;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.atomic.DataClip;
import org.basex.index.Index;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.resource.Binaries;
import org.basex.index.resource.Docs;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenBoolMap;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Resources
implements Index {
    private final Docs docs;
    private final Binaries bins;

    public Resources(Data d) {
        this.docs = new Docs(d);
        this.bins = new Binaries(d);
    }

    public synchronized void read(DataInput in) throws IOException {
        this.docs.read(in);
    }

    public void write(DataOutput out) throws IOException {
        this.docs.write(out);
    }

    public synchronized IntList docs() {
        return this.docs.docs();
    }

    @Override
    public synchronized void init() {
        this.docs.init();
    }

    public void insert(int pre, DataClip clip) {
        this.docs.insert(pre, clip);
    }

    public void delete(int pre, int size) {
        this.docs.delete(pre, size);
    }

    public void rename(int pre, byte[] value) {
        this.docs.rename(pre, value);
    }

    public void replace(int pre, int size, DataClip clip) {
        this.docs.replace(pre, size, clip);
    }

    public synchronized IntList docs(String path) {
        return this.docs.docs(path, false);
    }

    public synchronized IntList docs(String path, boolean exact) {
        return this.docs.docs(path, exact);
    }

    public int doc(String path) {
        return this.docs.doc(path, true);
    }

    public synchronized TokenList binaries(String path) {
        return this.bins.bins(path);
    }

    public synchronized boolean isDir(byte[] path) {
        return this.docs.isDir(path) || this.bins.isDir(Token.string(path));
    }

    public synchronized TokenBoolMap children(byte[] path, boolean dir) {
        TokenBoolMap tbm = new TokenBoolMap();
        this.docs.children(path, dir, tbm);
        this.bins.children(path, dir, tbm);
        return tbm;
    }

    @Override
    public void close() {
    }

    @Override
    public IndexIterator iter(IndexToken token) {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public int costs(IndexToken token) {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public byte[] info() {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        throw Util.notExpected(new Object[0]);
    }
}

