/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.basex.core.Proc;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.list.ByteList;
import org.basex.util.list.StringList;

public final class Zip
extends Proc {
    private final IO archive;
    private int total;
    private int curr;

    public Zip(IO file) {
        this.archive = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size() throws IOException {
        ZipInputStream in = new ZipInputStream(this.archive.inputStream());
        try {
            int c = 0;
            while (in.getNextEntry() != null) {
                ++c;
            }
            int n = c;
            return n;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(String path) throws IOException {
        ZipInputStream in = new ZipInputStream(this.archive.inputStream());
        try {
            byte[] cont = Zip.getEntry(in, path);
            if (cont == null) {
                throw new FileNotFoundException(path);
            }
            byte[] byArray = cont;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(IOFile target) throws IOException {
        ZipInputStream in = new ZipInputStream(this.archive.inputStream());
        this.total = this.size();
        this.curr = 0;
        try {
            ZipEntry ze;
            byte[] data = new byte[4096];
            while ((ze = in.getNextEntry()) != null) {
                ++this.curr;
                IOFile trg = new IOFile(target, ze.getName());
                if (ze.isDirectory()) {
                    trg.md();
                    continue;
                }
                trg.dir().md();
                FileOutputStream out = new FileOutputStream(trg.path());
                try {
                    int c;
                    while ((c = in.read(data)) != -1) {
                        ((OutputStream)out).write(data, 0, c);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(IOFile root, StringList files) throws IOException {
        if (!(this.archive instanceof IOFile)) {
            throw new FileNotFoundException(this.archive.path());
        }
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.archive.path())));
        this.curr = 0;
        try {
            out.setLevel(1);
            this.total = files.size();
            byte[] data = new byte[4096];
            for (String file : files) {
                ++this.curr;
                FileInputStream in = new FileInputStream(new File(root.file(), file));
                try {
                    int c;
                    String fl = Prop.WIN ? file.replace('\\', '/') : file;
                    out.putNextEntry(new ZipEntry(root.name() + '/' + fl));
                    while ((c = in.read(data)) != -1) {
                        out.write(data, 0, c);
                    }
                    out.closeEntry();
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            out.close();
        }
    }

    @Override
    protected double prog() {
        return (double)this.curr / (double)this.total;
    }

    private static byte[] getEntry(ZipInputStream in, String entry) throws IOException {
        ZipEntry ze;
        while ((ze = in.getNextEntry()) != null) {
            int c;
            if (!entry.equals(ze.getName())) continue;
            int s = (int)ze.getSize();
            if (s >= 0) {
                int c2;
                byte[] data = new byte[s];
                int o = 0;
                while (s - o != 0 && (c2 = in.read(data, o, s - o)) != -1) {
                    o += c2;
                }
                return data;
            }
            byte[] data = new byte[4096];
            ByteList bl = new ByteList();
            while ((c = in.read(data)) != -1) {
                bl.add(data, 0, c);
            }
            return bl.toArray();
        }
        return null;
    }
}

