/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.basex.data.DataText;
import org.basex.data.FTPos;
import org.basex.io.in.TextInput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.StrStream;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.hash.TokenSet;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public abstract class OutputSerializer
extends Serializer {
    String docsys;
    private String docpub;
    int ct;
    protected boolean sep;
    private boolean isep;
    boolean script;
    final boolean html5;
    final boolean escuri;
    final boolean saomit;
    final boolean content;
    protected final byte[] nl;
    protected final PrintOutput out;
    private boolean item;
    private CharsetEncoder encoder;
    private TokenBuilder encbuffer;
    private final Charset encoding;
    private final boolean utf8;
    private final TokenSet cdata = new TokenSet();
    private final TokenSet suppress = new TokenSet();
    private final String media;
    private final byte[] itemsep;
    private final boolean webdav;
    protected final int indents;
    protected final char tab;
    private final boolean format;
    private final byte[] wPre;
    private final boolean wrap;

    protected OutputSerializer(OutputStream os, SerializerOptions sopts, String ... versions) throws IOException {
        boolean xml;
        String supp;
        SerializerOptions opts = sopts == null ? OPTIONS : sopts;
        String ver = OutputSerializer.supported(SerializerOptions.VERSION, opts, versions);
        String htmlver = OutputSerializer.supported(SerializerOptions.HTML_VERSION, opts, "4.0", "4.01", "5.0");
        this.html5 = htmlver.equals("5.0") || ver.equals("5.0");
        boolean omitDecl = opts.yes(SerializerOptions.OMIT_XML_DECLARATION);
        boolean bom = opts.yes(SerializerOptions.BYTE_ORDER_MARK);
        SerializerOptions.YesNoOmit sa = opts.get(SerializerOptions.STANDALONE);
        this.saomit = sa == SerializerOptions.YesNoOmit.OMIT;
        String maps = opts.get(SerializerOptions.USE_CHARACTER_MAPS);
        String enc = Token.normEncoding(opts.get(SerializerOptions.ENCODING), true);
        try {
            this.encoding = Charset.forName(enc);
        }
        catch (Exception ex) {
            throw Err.SERENCODING.getIO(enc);
        }
        boolean bl = this.utf8 = enc == "UTF-8";
        if (!this.utf8) {
            this.encoder = this.encoding.newEncoder();
            this.encbuffer = new TokenBuilder();
        }
        this.indents = opts.get(SerializerOptions.INDENTS);
        this.format = opts.yes(SerializerOptions.FORMAT);
        this.tab = (char)(opts.yes(SerializerOptions.TABULATOR) ? 9 : 32);
        this.wPre = Token.token(opts.get(SerializerOptions.WRAP_PREFIX));
        this.wrap = this.wPre.length != 0;
        this.nl = Token.utf8(Token.token(opts.get(SerializerOptions.NEWLINE).newline()), enc);
        this.itemsep = opts.contains(SerializerOptions.ITEM_SEPARATOR) ? Token.token(opts.get(SerializerOptions.ITEM_SEPARATOR).replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t")) : null;
        this.docsys = opts.get(SerializerOptions.DOCTYPE_SYSTEM);
        this.docpub = opts.get(SerializerOptions.DOCTYPE_PUBLIC);
        this.media = opts.get(SerializerOptions.MEDIA_TYPE);
        this.escuri = opts.yes(SerializerOptions.ESCAPE_URI_ATTRIBUTES);
        this.content = opts.yes(SerializerOptions.INCLUDE_CONTENT_TYPE);
        this.undecl = opts.yes(SerializerOptions.UNDECLARE_PREFIXES);
        this.indent = opts.yes(SerializerOptions.INDENT) && this.format;
        this.webdav = "webdav".equals(maps);
        if (!this.webdav && !maps.isEmpty()) {
            throw Err.SERMAP.getIO(maps);
        }
        if (this.docsys.isEmpty()) {
            this.docsys = null;
        }
        if (this.docpub.isEmpty()) {
            this.docpub = null;
        }
        this.out = PrintOutput.get(os);
        int l = opts.get(SerializerOptions.LIMIT);
        if (l != -1) {
            this.out.setLimit(l);
        }
        if (bom) {
            if (enc == "UTF-8") {
                this.out.write(239);
                this.out.write(187);
                this.out.write(191);
            } else if (enc == "UTF-16LE") {
                this.out.write(255);
                this.out.write(254);
            } else if (enc == "UTF-16BE") {
                this.out.write(254);
                this.out.write(255);
            }
        }
        if (!(supp = opts.get(SerializerOptions.SUPPRESS_INDENTATION)).isEmpty()) {
            for (String c : supp.split("\\s+")) {
                if (c.isEmpty()) continue;
                this.suppress.add(c);
            }
        }
        boolean html = this instanceof HTMLSerializer;
        boolean bl2 = xml = this instanceof XMLSerializer || this instanceof XHTMLSerializer;
        if (xml || html) {
            String cdse = opts.get(SerializerOptions.CDATA_SECTION_ELEMENTS);
            for (String c : cdse.split("\\s+")) {
                if (c.isEmpty() || html && (!c.contains(":") || this.html5 && c.contains("html:"))) continue;
                this.cdata.add(c);
            }
            if (this.undecl && ver.equals("1.0")) {
                throw Err.SERUNDECL.getIO(new Object[0]);
            }
            if (xml) {
                if (omitDecl) {
                    if (!this.saomit || !ver.equals("1.0") && this.docsys != null) {
                        throw Err.SERSTAND.getIO(new Object[0]);
                    }
                } else {
                    this.print(DataText.PI_O);
                    this.print("xml version=\"");
                    this.print(ver);
                    this.print("\" encoding=\"");
                    this.print(opts.get(SerializerOptions.ENCODING));
                    if (!this.saomit) {
                        this.print("\" standalone=\"");
                        this.print(sa.toString());
                    }
                    this.print(DataText.ATT2);
                    this.print(DataText.PI_C);
                    this.sep = true;
                }
            }
        }
        if (this.wrap) {
            this.startElement(Token.concat(this.wPre, Token.COLON, DataText.T_RESULTS));
            this.namespace(this.wPre, Token.token(opts.get(SerializerOptions.WRAP_URI)));
        }
    }

    @Override
    public final void reset() {
        this.sep = false;
        this.item = false;
        this.isep = false;
    }

    @Override
    public void close() throws IOException {
        if (this.wrap) {
            this.closeElement();
        }
        this.out.flush();
    }

    @Override
    public final boolean finished() {
        return this.out.finished();
    }

    @Override
    protected void openResult() throws IOException {
        byte[] sp = this.itemsep;
        if (sp != null) {
            if (this.isep) {
                int sl = sp.length;
                if (sl == 1) {
                    this.printChar(sp[0]);
                } else {
                    for (int s = 0; s < sl; s += Token.cl(sp, s)) {
                        this.printChar(Token.cp(sp, s));
                    }
                }
                this.sep = false;
            } else {
                this.isep = true;
            }
        }
        if (this.wrap) {
            this.startElement(this.wPre.length == 0 ? DataText.T_RESULT : Token.concat(this.wPre, Token.COLON, DataText.T_RESULT));
        }
    }

    @Override
    protected void closeResult() throws IOException {
        if (this.wrap) {
            this.closeElement();
        }
    }

    @Override
    protected void attribute(byte[] n, byte[] v) throws IOException {
        this.print(32);
        this.print(n);
        this.print(DataText.ATT1);
        int vl = v.length;
        for (int k = 0; k < vl; k += Token.cl(v, k)) {
            int ch = Token.cp(v, k);
            if (!this.format) {
                this.printChar(ch);
                continue;
            }
            if (ch == 34) {
                this.print(DataText.E_QU);
                continue;
            }
            if (ch == 9 || ch == 10) {
                this.hex(ch);
                continue;
            }
            this.encode(ch);
        }
        this.print(DataText.ATT2);
    }

    @Override
    protected void finishText(byte[] b) throws IOException {
        int bl = b.length;
        if (this.cdata.isEmpty() || this.tags.isEmpty() || !this.cdata.contains(this.tags.peek())) {
            for (int k = 0; k < bl; k += Token.cl(b, k)) {
                this.encode(Token.cp(b, k));
            }
        } else {
            this.print(DataText.CDATA_O);
            int c = 0;
            for (int k = 0; k < b.length; k += Token.cl(b, k)) {
                int ch = Token.cp(b, k);
                if (ch == 93) {
                    ++c;
                } else {
                    if (c > 1 && ch == 62) {
                        this.print(DataText.CDATA_C);
                        this.print(DataText.CDATA_O);
                    }
                    c = 0;
                }
                this.printChar(ch);
            }
            this.print(DataText.CDATA_C);
        }
        this.sep = false;
    }

    @Override
    protected void finishText(byte[] b, FTPos ftp) throws IOException {
        FTLexer lex = new FTLexer().sc().init(b);
        while (lex.hasNext()) {
            FTSpan span = lex.next();
            if (!span.special && ftp.contains(span.pos)) {
                this.print(4);
            }
            byte[] t = span.text;
            for (int k = 0; k < t.length; k += Token.cl(t, k)) {
                this.encode(Token.cp(t, k));
            }
        }
        this.sep = false;
    }

    @Override
    protected void finishComment(byte[] n) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.COMM_O);
        this.print(n);
        this.print(DataText.COMM_C);
        this.sep = true;
    }

    @Override
    protected void finishPi(byte[] n, byte[] v) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.PI_O);
        this.print(n);
        this.print(32);
        this.print(v);
        this.print(DataText.PI_C);
        this.sep = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void atomic(Item it, boolean iter) throws IOException {
        block11: {
            if (this.sep && this.item) {
                this.print(32);
            }
            try {
                if (it instanceof StrStream) {
                    TextInput ni = ((StrStream)it).input(null);
                    try {
                        int cp;
                        while ((cp = ((InputStream)ni).read()) != -1) {
                            if (iter) {
                                this.print(cp);
                                continue;
                            }
                            this.encode(cp);
                        }
                        break block11;
                    }
                    finally {
                        ((InputStream)ni).close();
                    }
                }
                byte[] atom = it.string(null);
                for (int a = 0; a < atom.length; a += Token.cl(atom, a)) {
                    int cp = Token.cp(atom, a);
                    if (iter) {
                        this.print(cp);
                        continue;
                    }
                    this.encode(cp);
                }
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
        this.sep = true;
        this.item = true;
    }

    @Override
    protected void openDoc(byte[] n) throws IOException {
        this.sep = false;
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
        this.doctype(t);
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.ELEM_O);
        this.print(t);
        this.sep = true;
    }

    @Override
    protected void finishOpen() throws IOException {
        this.print(DataText.ELEM_C);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.print(DataText.ELEM_SC);
    }

    @Override
    protected void finishClose() throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.ELEM_OS);
        this.print(this.tag);
        this.print(DataText.ELEM_C);
        this.sep = true;
    }

    protected void encode(int ch) throws IOException {
        if (!this.format) {
            this.printChar(ch);
        } else if (ch < 32 && ch != 10 && ch != 9 || ch >= 127 && ch < 160 || this.webdav && ch == 160) {
            this.hex(ch);
        } else if (ch == 38) {
            this.print(DataText.E_AMP);
        } else if (ch == 62) {
            this.print(DataText.E_GT);
        } else if (ch == 60) {
            this.print(DataText.E_LT);
        } else if (ch == 8232) {
            this.print(DataText.E_2028);
        } else {
            this.printChar(ch);
        }
    }

    boolean doctype(byte[] dt) throws IOException {
        if (this.level != 0 || this.docsys == null && this.docpub == null) {
            return false;
        }
        if (this.sep) {
            this.indent();
        }
        this.print("<!DOCTYPE ");
        if (dt == null) {
            this.print("html");
        } else {
            this.print(dt);
        }
        if (this.docpub != null) {
            this.print(" PUBLIC \"" + this.docpub + '\"');
        } else {
            this.print(" SYSTEM");
        }
        if (this.docsys != null) {
            this.print(" \"" + this.docsys + '\"');
        }
        this.print(DataText.ELEM_C);
        this.sep = true;
        return true;
    }

    protected void indent() throws IOException {
        if (this.item) {
            this.item = false;
        } else if (this.indent) {
            if (!this.suppress.isEmpty() && !this.tags.isEmpty()) {
                for (byte[] t : this.tags) {
                    if (!this.suppress.contains(t)) continue;
                    return;
                }
            }
            this.print(this.nl);
            int ls = this.level * this.indents;
            for (int l = 0; l < ls; ++l) {
                this.print(this.tab);
            }
        }
    }

    final void hex(int ch) throws IOException {
        this.print("&#x");
        int h = ch >> 4;
        if (h != 0) {
            this.print(Token.HEX[h]);
        }
        this.print(Token.HEX[ch & 0xF]);
        this.print(59);
    }

    protected final void printChar(int ch) throws IOException {
        if (ch == 10) {
            this.out.write(this.nl);
        } else {
            this.print(ch);
        }
    }

    protected void print(int ch) throws IOException {
        if (this.utf8) {
            this.out.utf8(ch);
        } else {
            this.encbuffer.reset();
            this.encoder.reset();
            ByteBuffer bb = this.encoder.encode(CharBuffer.wrap(this.encbuffer.add(ch).toString()));
            this.out.write(bb.array(), 0, bb.limit());
        }
    }

    protected final void print(byte[] token) throws IOException {
        if (this.utf8) {
            for (byte b : token) {
                this.out.write(b);
            }
        } else {
            this.out.write(Token.string(token).getBytes(this.encoding));
        }
    }

    protected final void print(String s) throws IOException {
        if (this.utf8) {
            for (byte b : Token.token(s)) {
                this.out.write(b);
            }
        } else {
            this.out.write(s.getBytes(this.encoding));
        }
    }

    boolean ct(boolean empty, boolean html) throws IOException {
        if (this.ct != 1) {
            return false;
        }
        ++this.ct;
        if (empty) {
            this.finishOpen();
        }
        ++this.level;
        this.startOpen(DataText.META);
        this.attribute(DataText.HTTPEQUIV, Token.token("Content-Type"));
        this.attribute(DataText.CONTENT, new TokenBuilder(this.media.isEmpty() ? "text/html" : this.media).add(DataText.CHARSET).addExt(this.encoding, new Object[0]).finish());
        if (html) {
            this.print(DataText.ELEM_C);
        } else {
            this.print(32);
            this.print(DataText.ELEM_SC);
        }
        --this.level;
        if (empty) {
            this.finishClose();
        }
        return true;
    }

    private static String supported(StringOption option, Options opts, String ... allowed) throws QueryIOException {
        String val = opts.get(option);
        if (val.isEmpty()) {
            return allowed.length > 0 ? allowed[0] : val;
        }
        for (String a : allowed) {
            if (!a.equals(val)) continue;
            return val;
        }
        throw Err.SERNOTSUPP.getIO(Options.allowed(option, allowed));
    }
}

