/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.Token;

public class XHTMLSerializer
extends OutputSerializer {
    XHTMLSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts, "1.0", "1.1");
    }

    @Override
    protected void attribute(byte[] n, byte[] v) throws IOException {
        byte[] tagatt = Token.concat(Token.lc(this.tag), Token.COLON, Token.lc(n));
        byte[] val = this.escuri && HTMLSerializer.URIS.contains(tagatt) ? Token.escape(v) : v;
        super.attribute(n, val);
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
        super.startOpen(t);
        if (this.content && Token.eq(Token.lc(this.tag), DataText.HEAD)) {
            ++this.ct;
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        super.finishOpen();
        this.ct(false, false);
    }

    @Override
    protected void finishEmpty() throws IOException {
        if (this.ct(true, false)) {
            return;
        }
        if ((this.html5 ? HTMLSerializer.EMPTIES5 : HTMLSerializer.EMPTIES).contains(Token.lc(this.tag))) {
            this.print(32);
            this.print(DataText.ELEM_SC);
        } else {
            this.print(DataText.ELEM_C);
            this.sep = false;
            this.finishClose();
        }
    }

    @Override
    protected boolean doctype(byte[] dt) throws IOException {
        if (this.level != 0) {
            return false;
        }
        if (!super.doctype(dt) && this.html5) {
            if (this.sep) {
                this.indent();
            }
            this.print("<!DOCTYPE ");
            if (dt == null) {
                this.print("html");
            } else {
                this.print(dt);
            }
            this.print(DataText.ELEM_C);
            this.print(this.nl);
        }
        return true;
    }
}

