/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.IdentityHashMap;
import org.basex.core.LockResult;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.Scope;
import org.basex.query.StaticContext;
import org.basex.query.StaticScope;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class MainModule
extends StaticScope {
    private final SeqType declType;

    public MainModule(Expr rt, VarScope scp, String xqdoc, StaticContext sctx) {
        this(rt, scp, null, xqdoc, sctx, null);
    }

    public MainModule(Expr rt, VarScope scp, SeqType type, String xqdoc, StaticContext sctx, InputInfo ii) {
        super(scp, xqdoc, sctx, ii);
        this.expr = rt;
        this.declType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compile(QueryContext ctx) throws QueryException {
        if (this.compiled) {
            return;
        }
        try {
            this.compiled = true;
            this.expr = this.expr.compile(ctx, this.scope);
        }
        finally {
            this.scope.cleanUp(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value value(QueryContext ctx) throws QueryException {
        int fp = this.scope.enter(ctx);
        try {
            Value v = ctx.value(this.expr);
            Value value = this.declType != null ? this.declType.treat(v, this.info) : v;
            return value;
        }
        finally {
            this.scope.exit(ctx, fp);
        }
    }

    public Iter iter(final QueryContext ctx) throws QueryException {
        if (this.declType != null) {
            return this.value(ctx).iter();
        }
        final int fp = this.scope.enter(ctx);
        final Iter iter = this.expr.iter(ctx);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it = iter.next();
                if (it == null) {
                    MainModule.this.scope.exit(ctx, fp);
                }
                return it;
            }

            @Override
            public long size() {
                return iter.size();
            }

            @Override
            public Item get(long i) throws QueryException {
                return iter.get(i);
            }

            @Override
            public boolean reset() {
                return iter.reset();
            }
        };
    }

    @Override
    public String toString() {
        return this.expr.toString();
    }

    @Override
    public void plan(FElem e) {
        this.expr.plan(e);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        return this.expr.accept(visitor);
    }

    public boolean databases(LockResult lr, QueryContext ctx) {
        return this.expr.accept(new LockVisitor(lr, ctx));
    }

    static class LockVisitor
    extends ASTVisitor {
        private final IdentityHashMap<Scope, Object> funcs = new IdentityHashMap();
        private final StringList sl;
        private int level;

        LockVisitor(LockResult lr, QueryContext ctx) {
            this.sl = ctx.updating ? lr.write : lr.read;
            this.level = ctx.ctxItem == null ? 0 : 1;
        }

        @Override
        public boolean lock(String db) {
            if (db == null) {
                return false;
            }
            if (this.level == 0 || db != "%CTX") {
                this.sl.add(db);
            }
            return true;
        }

        @Override
        public void enterFocus() {
            ++this.level;
        }

        @Override
        public void exitFocus() {
            --this.level;
        }

        @Override
        public boolean staticVar(StaticVar var) {
            if (this.funcs.containsKey(var)) {
                return true;
            }
            this.funcs.put(var, null);
            return var.visit(this);
        }

        @Override
        public boolean staticFuncCall(StaticFuncCall call) {
            return this.func(call.func());
        }

        @Override
        public boolean inlineFunc(Scope sub) {
            this.enterFocus();
            boolean ac = sub.visit(this);
            this.exitFocus();
            return ac;
        }

        @Override
        public boolean funcItem(FuncItem func) {
            return this.func(func);
        }

        private boolean func(Scope scp) {
            if (this.funcs.containsKey(scp)) {
                return true;
            }
            this.funcs.put(scp, null);
            this.enterFocus();
            boolean ac = scp.visit(this);
            this.exitFocus();
            return ac;
        }
    }
}

