/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.SwitchCase;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Switch
extends ParseExpr {
    private final SwitchCase[] cases;
    private Expr cond;

    public Switch(InputInfo ii, Expr c, SwitchCase[] sc) {
        super(ii);
        this.cases = sc;
        this.cond = c;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        for (SwitchCase sc : this.cases) {
            sc.checkUp();
        }
        Expr[] tmp = new Expr[this.cases.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.cases[i].expr[0];
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.cond = this.cond.compile(ctx, scp);
        for (SwitchCase sc : this.cases) {
            sc.compile(ctx, scp);
        }
        Expr ex = this;
        if (this.cond.isValue()) {
            Item it = this.cond.item(ctx, this.info);
            block1: for (SwitchCase sc : this.cases) {
                int sl = sc.expr.length;
                for (int e = 1; e < sl; ++e) {
                    if (!sc.expr[e].isValue()) break block1;
                    Item cs = sc.expr[e].item(ctx, this.info);
                    if (it != cs && (cs == null || it == null || !it.equiv(cs, null, this.info))) continue;
                    ex = sc.expr[0];
                    break block1;
                }
                if (sl != 1) continue;
                ex = sc.expr[0];
            }
        }
        if (ex != this) {
            return this.optPre(ex, ctx);
        }
        this.type = this.cases[0].expr[0].type();
        for (int c = 1; c < this.cases.length; ++c) {
            this.type = this.type.union(this.cases[c].expr[0].type());
        }
        return ex;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return ctx.iter(this.getCase(ctx));
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return ctx.value(this.getCase(ctx));
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.getCase(ctx).item(ctx, ii);
    }

    @Override
    public boolean isVacuous() {
        for (SwitchCase sc : this.cases) {
            if (sc.expr[0].isVacuous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        for (SwitchCase sc : this.cases) {
            if (!sc.has(flag)) continue;
            return true;
        }
        return this.cond.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        for (SwitchCase sc : this.cases) {
            if (sc.removable(v)) continue;
            return false;
        }
        return this.cond.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        VarUsage max = VarUsage.NEVER;
        VarUsage curr = VarUsage.NEVER;
        for (SwitchCase cs : this.cases) {
            curr = curr.plus(cs.countCases(v));
            max = max.max(curr.plus(cs.count(v)));
        }
        return max.plus(this.cond.count(v));
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean change = Switch.inlineAll(ctx, scp, this.cases, v, e);
        Expr cn = this.cond.inline(ctx, scp, v, e);
        if (cn != null) {
            change = true;
            this.cond = cn;
        }
        return change ? this.optimize(ctx, scp) : null;
    }

    private Expr getCase(QueryContext ctx) throws QueryException {
        Item it = this.cond.item(ctx, this.info);
        for (SwitchCase sc : this.cases) {
            int sl = sc.expr.length;
            for (int e = 1; e < sl; ++e) {
                Item cs = sc.expr[e].item(ctx, this.info);
                if (it != cs && (it == null || cs == null || !it.equiv(cs, null, this.info))) continue;
                return sc.expr[0];
            }
            if (sl != 1) continue;
            return sc.expr[0];
        }
        return null;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new Switch(this.info, this.cond.copy(ctx, scp, vs), (SwitchCase[])Arr.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.cases));
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.cond, this.cases});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("switch(" + this.cond + ")");
        for (SwitchCase sc : this.cases) {
            sb.append(sc.toString());
        }
        return sb.toString();
    }

    @Override
    public void markTailCalls(QueryContext ctx) {
        for (SwitchCase sc : this.cases) {
            sc.markTailCalls(ctx);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && Switch.visitAll(visitor, this.cases);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (SwitchCase e : this.cases) {
            sz += ((Expr)e).exprSize();
        }
        return sz;
    }
}

