/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.data.Data;
import org.basex.data.FTMatches;
import org.basex.data.MetaData;
import org.basex.index.query.FTIndexIterator;
import org.basex.index.query.IndexIterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTNot;
import org.basex.query.ft.FTTokenizer;
import org.basex.query.ft.FTTokens;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.IndexContext;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTMode;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public final class FTWords
extends FTExpr {
    FTMatches matches = new FTMatches();
    boolean first;
    FTMode mode = FTMode.ANY;
    Expr query;
    Expr[] occ;
    private FTTokenizer ftt;
    private IndexContext ictx;
    private TokenList txt;
    private int pos;
    private boolean fast;

    public FTWords(InputInfo ii, Expr e, FTMode m, Expr[] o) {
        super(ii, new FTExpr[0]);
        this.query = e;
        this.mode = m;
        this.occ = o;
    }

    public FTWords(InputInfo ii, IndexContext ic, Value t, FTMode m) {
        super(ii, new FTExpr[0]);
        this.query = t;
        this.mode = m;
        this.ictx = ic;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.occ);
        this.checkNoUp(this.query);
    }

    @Override
    public FTWords compile(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.occ != null) {
            for (int o = 0; o < this.occ.length; ++o) {
                this.occ[o] = this.occ[o].compile(ctx, scp);
            }
        }
        if (this.txt == null) {
            this.query = this.query.compile(ctx, scp);
            if (this.query.isValue()) {
                this.txt = this.tokens(ctx);
            }
            boolean bl = this.fast = this.mode == FTMode.ANY && this.txt != null && this.occ == null;
            if (this.ftt == null) {
                this.ftt = new FTTokenizer(this, ctx);
            }
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext ctx, InputInfo ii) throws QueryException {
        if (this.pos == 0) {
            this.pos = ++ctx.ftPos;
        }
        this.matches.reset(this.pos);
        int c = this.contains(ctx);
        if (c == 0) {
            this.matches.size(0);
        }
        return new FTNode(this.matches, c == 0 ? 0.0 : Scoring.word(c, ctx.ftToken.count()));
    }

    @Override
    public FTIter iter(final QueryContext ctx) {
        final Data data = this.ictx.data;
        return new FTIter(){
            FTIndexIterator ftiter;
            int len;

            @Override
            public FTNode next() throws QueryException {
                if (this.ftiter == null) {
                    FTLexer lex = new FTLexer(((FTWords)FTWords.this).ftt.opt);
                    int t = 0;
                    for (byte[] k : FTWords.this.unique(FTWords.this.txt != null ? FTWords.this.txt : FTWords.this.tokens(ctx))) {
                        lex.init(k);
                        if (!lex.hasNext()) {
                            return null;
                        }
                        int d = 0;
                        IndexIterator ii = null;
                        do {
                            byte[] tok = lex.nextToken();
                            t += tok.length;
                            if (((FTWords)FTWords.this).ftt.opt.sw != null && ((FTWords)FTWords.this).ftt.opt.sw.contains(tok)) {
                                ++d;
                                continue;
                            }
                            FTIndexIterator ir = lex.get().length > data.meta.maxlen ? FTWords.this.scan(lex) : (FTIndexIterator)data.iter(lex);
                            ir.pos(++ctx.ftPos);
                            if (ii == null) {
                                ii = ir;
                                continue;
                            }
                            ii = FTIndexIterator.intersect((FTIndexIterator)ii, ir, ++d);
                            d = 0;
                        } while (lex.hasNext());
                        if (this.ftiter == null) {
                            this.len = t;
                            this.ftiter = ii;
                            continue;
                        }
                        if (FTWords.this.mode == FTMode.ALL || FTWords.this.mode == FTMode.ALL_WORDS) {
                            if (ii.size() == 0) {
                                return null;
                            }
                            this.len += t;
                            this.ftiter = FTIndexIterator.intersect(this.ftiter, (FTIndexIterator)ii, 0);
                            continue;
                        }
                        if (ii.size() == 0) continue;
                        this.len = Math.max(t, this.len);
                        this.ftiter = FTIndexIterator.union(this.ftiter, (FTIndexIterator)ii);
                    }
                }
                return this.ftiter == null || !this.ftiter.more() ? null : new FTNode(this.ftiter.matches(), data, this.ftiter.pre(), this.len, this.ftiter.size(), -1.0);
            }
        };
    }

    FTIndexIterator scan(FTLexer lex) throws QueryException {
        final Data data = this.ictx.data;
        final FTLexer input = new FTLexer(this.ftt.opt);
        final FTTokens tokens = this.ftt.cache(lex.get());
        return new FTIndexIterator(){
            int pre = -1;
            int ps;

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < data.meta.size) {
                    if (data.kind(this.pre) != 2) continue;
                    input.init(data.text(this.pre, true));
                    FTWords.this.matches.reset(this.ps);
                    try {
                        if (FTWords.this.ftt.contains(tokens, input) == 0) continue;
                        return true;
                    }
                    catch (QueryException queryException) {
                    }
                }
                return false;
            }

            @Override
            public FTMatches matches() {
                return FTWords.this.matches;
            }

            @Override
            public void pos(int p) {
                this.ps = p;
            }

            @Override
            public int size() {
                return Math.max(1, data.meta.size >>> 1);
            }
        };
    }

    TokenList tokens(QueryContext ctx) throws QueryException {
        byte[] qu;
        TokenList tl = new TokenList();
        Iter ir = ctx.iter(this.query);
        while ((qu = this.nextToken(ir)) != null) {
            if (qu.length == 0 && this.mode != FTMode.ALL && this.mode != FTMode.ALL_WORDS) continue;
            tl.add(qu);
        }
        return tl;
    }

    private int contains(QueryContext ctx) throws QueryException {
        long mx;
        this.first = true;
        FTLexer lexer = this.ftt.lexer(ctx.ftToken);
        int num = 0;
        if (this.fast) {
            for (byte[] t : this.txt) {
                FTTokens qtok = this.ftt.cache(t);
                num = Math.max(num, this.ftt.contains(qtok, lexer) * qtok.length());
            }
            return num;
        }
        boolean all = this.mode == FTMode.ALL || this.mode == FTMode.ALL_WORDS;
        int oc = 0;
        for (byte[] w : this.unique(this.tokens(ctx))) {
            FTTokens qtok = this.ftt.cache(w);
            int o = this.ftt.contains(qtok, lexer);
            if (all && o == 0) {
                return 0;
            }
            num = Math.max(num, o * qtok.length());
            oc += o;
        }
        long mn = this.occ != null ? this.checkItr(this.occ[0], ctx) : 1L;
        long l = mx = this.occ != null ? this.checkItr(this.occ[1], ctx) : Long.MAX_VALUE;
        if (mn == 0L && oc == 0) {
            this.matches = FTNot.not(this.matches);
        }
        return (long)oc >= mn && (long)oc <= mx ? Math.max(1, num) : 0;
    }

    TokenSet unique(TokenList list) {
        TokenSet ts = new TokenSet();
        switch (this.mode) {
            case ALL: 
            case ANY: {
                for (byte[] t : list) {
                    ts.add(t);
                }
                break;
            }
            case ALL_WORDS: 
            case ANY_WORD: {
                FTLexer l = new FTLexer(this.ftt.opt);
                for (byte[] t : list) {
                    l.init(t);
                    while (l.hasNext()) {
                        ts.add(l.nextToken());
                    }
                }
                break;
            }
            case PHRASE: {
                TokenBuilder tb = new TokenBuilder();
                for (byte[] t : list) {
                    tb.add(t).add(32);
                }
                ts.add(tb.trim().finish());
            }
        }
        return ts;
    }

    byte[] nextToken(Iter iter) throws QueryException {
        Item it = iter.next();
        return it == null ? null : this.checkEStr(it);
    }

    void add(int s, int e) {
        if (!(this.first || this.mode != FTMode.ALL && this.mode != FTMode.ALL_WORDS)) {
            this.matches.and(s, e);
        } else {
            this.matches.or(s, e);
        }
    }

    @Override
    public boolean indexAccessible(IndexCosts ic) {
        Data dt = ic.ictx.data;
        MetaData md = dt.meta;
        FTOpt fto = this.ftt.opt;
        if (this.occ != null || fto.cs != null && md.casesens == (fto.cs == FTCase.INSENSITIVE) || fto.isSet(FTFlag.DC) && md.diacritics != fto.is(FTFlag.DC) || fto.isSet(FTFlag.ST) && md.stemming != fto.is(FTFlag.ST) || fto.ln != null && !fto.ln.equals(md.language)) {
            return false;
        }
        if (this.txt == null) {
            ic.costs(Math.max(1, dt.meta.size >>> 3));
            return true;
        }
        fto.copy(md);
        FTLexer ft = new FTLexer(fto);
        ic.costs(0);
        for (byte[] t : this.txt) {
            ft.init(t);
            while (ft.hasNext()) {
                byte[] tok = ft.nextToken();
                if (fto.sw != null && fto.sw.contains(tok)) continue;
                if (fto.is(FTFlag.WC)) {
                    t = ft.get();
                    if (t[0] == 46) {
                        return false;
                    }
                    int d = 0;
                    for (byte w : t) {
                        if (w != 123 && w != 92 && (w != 46 || ++d <= 1)) continue;
                        return false;
                    }
                }
                ic.addCosts(Math.max(1, dt.costs(ft) >> 10));
            }
        }
        return true;
    }

    @Override
    public FTExpr indexEquivalent(IndexCosts ic) {
        this.ictx = ic.ictx;
        return this;
    }

    @Override
    public boolean usesExclude() {
        return this.occ != null;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (!o.has(flag)) continue;
                return true;
            }
        }
        return this.query.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (o.removable(v)) continue;
                return false;
            }
        }
        return this.query.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.occ != null ? VarUsage.sum(v, this.occ).plus(this.query.count(v)) : this.query.count(v);
    }

    @Override
    public FTExpr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean change = this.occ != null && FTWords.inlineAll(ctx, scp, this.occ, v, e);
        Expr q = this.query.inline(ctx, scp, v, e);
        if (q != null) {
            this.query = q;
            change = true;
        }
        return change ? this.optimize(ctx, scp) : null;
    }

    @Override
    public FTExpr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        FTWords ftw = new FTWords(this.info, this.query.copy(ctx, scp, vs), this.mode, this.occ == null ? null : Arr.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.occ));
        if (this.ftt != null) {
            ftw.ftt = this.ftt.copy(ftw);
        }
        if (this.txt != null) {
            ftw.txt = this.txt.copy();
        }
        ftw.ictx = this.ictx;
        ftw.first = this.first;
        ftw.pos = this.pos;
        ftw.fast = this.fast;
        return ftw;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.occ, this.query});
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.query.accept(visitor) && (this.occ == null || FTWords.visitAll(visitor, this.occ));
    }

    @Override
    public int exprSize() {
        int sz = 1;
        if (this.occ != null) {
            for (Expr expr : this.occ) {
                sz += expr.exprSize();
            }
        }
        for (Expr expr : this.expr) {
            sz += expr.exprSize();
        }
        return sz + this.query.exprSize();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean str = this.query instanceof AStr;
        if (!str) {
            sb.append("{ ");
        }
        sb.append(this.query);
        if (!str) {
            sb.append(" }");
        }
        switch (this.mode) {
            case ALL: {
                sb.append(" all");
                break;
            }
            case ALL_WORDS: {
                sb.append(" all words");
                break;
            }
            case ANY_WORD: {
                sb.append(" any word");
                break;
            }
            case PHRASE: {
                sb.append(" phrase");
                break;
            }
        }
        if (this.occ != null) {
            sb.append("occurs " + this.occ[0] + ' ' + "to" + ' ' + this.occ[1] + ' ' + "times");
        }
        return sb.append(this.ftt.opt).toString();
    }
}

