/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.zip.ZipEntry;
import org.basex.io.IOFile;
import org.basex.io.in.ArrayInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNConvert;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.NodeTest;
import org.basex.query.util.Err;
import org.basex.query.util.archive.ArchiveIn;
import org.basex.query.util.archive.ArchiveOut;
import org.basex.query.util.archive.GZIPIn;
import org.basex.query.util.archive.GZIPOut;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class FNArchive
extends StandardFunc {
    public static final String GZIP = "gzip";
    public static final String ZIP = "zip";
    private static final String PREFIX = "archive";
    private static final QNm Q_ENTRY = QNm.get("archive", "entry", QueryText.ARCHIVEURI);
    private static final QNm Q_OPTIONS = QNm.get("archive", "options", QueryText.ARCHIVEURI);
    private static final QNm Q_FORMAT = QNm.get("archive", "format", QueryText.ARCHIVEURI);
    private static final QNm Q_ALGORITHM = QNm.get("archive", "algorithm", QueryText.ARCHIVEURI);
    private static final NodeTest TEST = new NodeTest(Q_ENTRY);
    private static final String LEVEL = "compression-level";
    private static final String ENCODING = "encoding";
    private static final String LAST_MOD = "last-modified";
    private static final String COMP_SIZE = "compressed-size";
    private static final String SIZE = "size";
    private static final String VALUE = "value";
    private static final String DEFLATE = "deflate";
    private static final String STORED = "stored";
    private static final String UNKNOWN = "unknown";

    public FNArchive(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _ARCHIVE_ENTRIES: {
                return this.entries(ctx);
            }
            case _ARCHIVE_EXTRACT_TEXT: {
                return this.extractText(ctx);
            }
            case _ARCHIVE_EXTRACT_BINARY: {
                return this.extractBinary(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _ARCHIVE_CREATE: {
                return this.create(ctx);
            }
            case _ARCHIVE_UPDATE: {
                return this.update(ctx);
            }
            case _ARCHIVE_DELETE: {
                return this.delete(ctx);
            }
            case _ARCHIVE_OPTIONS: {
                return this.options(ctx);
            }
            case _ARCHIVE_WRITE: {
                return this.write(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private B64 create(QueryContext ctx) throws QueryException {
        Iter entr = ctx.iter(this.expr[0]);
        Iter cont = ctx.iter(this.expr[1]);
        ArchiveOptions opts = this.checkOptions(2, Q_OPTIONS, new ArchiveOptions(), ctx);
        String format = opts.get(ArchiveOptions.FORMAT);
        ArchiveOut out = ArchiveOut.get(format.toLowerCase(Locale.ENGLISH), this.info);
        String alg = opts.get(ArchiveOptions.ALGORITHM);
        int level = 8;
        if (alg != null) {
            if (format.equals(ZIP) && !Token.eq(alg, STORED, DEFLATE) || format.equals(GZIP) && !Token.eq(alg, DEFLATE)) {
                throw Err.ARCH_SUPP.get(this.info, ArchiveOptions.ALGORITHM.name(), alg);
            }
            if (Token.eq(alg, STORED)) {
                level = 0;
            } else if (Token.eq(alg, DEFLATE)) {
                level = 8;
            }
        }
        out.level(level);
        try {
            Item cn;
            Item en;
            int e = 0;
            int c = 0;
            while (true) {
                en = entr.next();
                cn = cont.next();
                if (en == null || cn == null) break;
                if (out instanceof GZIPOut && c > 0) {
                    throw Err.ARCH_ONE.get(this.info, format.toUpperCase(Locale.ENGLISH));
                }
                this.add(this.checkElmStr(en), cn, out, level, ctx);
                ++e;
                ++c;
            }
            if (cn != null) {
                do {
                    ++c;
                } while (cont.next() != null);
            }
            if (en != null) {
                do {
                    ++e;
                } while (entr.next() != null);
            }
            if (e != c) {
                throw Err.ARCH_DIFF.get(this.info, e, c);
            }
        }
        catch (IOException ex) {
            throw Err.ARCH_FAIL.get(this.info, ex);
        }
        finally {
            out.close();
        }
        return new B64(out.toArray());
    }

    private FElem options(QueryContext ctx) throws QueryException {
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        String format = null;
        int level = -1;
        ArchiveIn arch = ArchiveIn.get(archive.input(this.info), this.info);
        try {
            format = arch.format();
            while (arch.more()) {
                ZipEntry ze = arch.entry();
                if (ze.isDirectory()) continue;
                level = ze.getMethod();
                break;
            }
        }
        catch (IOException ex) {
            throw Err.ARCH_FAIL.get(this.info, ex);
        }
        finally {
            arch.close();
        }
        FElem e = new FElem(Q_OPTIONS).declareNS();
        if (format != null) {
            e.add(new FElem(Q_FORMAT).add(VALUE, format));
        }
        if (level >= 0) {
            String lvl = level == 8 ? DEFLATE : (level == 0 ? STORED : UNKNOWN);
            e.add(new FElem(Q_ALGORITHM).add(VALUE, lvl));
        }
        return e;
    }

    private Iter entries(QueryContext ctx) throws QueryException {
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        ValueBuilder vb = new ValueBuilder();
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        try {
            Object ze;
            while (in.more()) {
                ze = in.entry();
                if (((ZipEntry)ze).isDirectory()) continue;
                FElem e = new FElem(Q_ENTRY).declareNS();
                long s = ((ZipEntry)ze).getSize();
                if (s != -1L) {
                    e.add(SIZE, Token.token(s));
                }
                if ((s = ((ZipEntry)ze).getTime()) != -1L) {
                    e.add(LAST_MOD, new Dtm(s, this.info).string(this.info));
                }
                if ((s = ((ZipEntry)ze).getCompressedSize()) != -1L) {
                    e.add(COMP_SIZE, Token.token(s));
                }
                e.add(((ZipEntry)ze).getName());
                vb.add(e);
            }
            ze = vb;
            return ze;
        }
        catch (IOException ex) {
            throw Err.ARCH_FAIL.get(this.info, ex);
        }
        finally {
            in.close();
        }
    }

    private ValueBuilder extractText(QueryContext ctx) throws QueryException {
        String enc = this.encoding(2, Err.ARCH_ENCODING, ctx);
        ValueBuilder vb = new ValueBuilder();
        for (byte[] b : this.extract(ctx)) {
            vb.add(Str.get(this.encode(b, enc, ctx)));
        }
        return vb;
    }

    private ValueBuilder extractBinary(QueryContext ctx) throws QueryException {
        ValueBuilder vb = new ValueBuilder();
        for (byte[] b : this.extract(ctx)) {
            vb.add(new B64(b));
        }
        return vb;
    }

    private B64 update(QueryContext ctx) throws QueryException {
        Item cn;
        Item en;
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        TokenObjMap<Item[]> hm = new TokenObjMap<Item[]>();
        Iter entr = ctx.iter(this.expr[1]);
        Iter cont = ctx.iter(this.expr[2]);
        int e = 0;
        int c = 0;
        while (true) {
            en = entr.next();
            cn = cont.next();
            if (en == null || cn == null) break;
            hm.put(this.checkElmStr(en).string(this.info), new Item[]{en, cn});
            ++e;
            ++c;
        }
        if (cn != null) {
            do {
                ++c;
            } while (cont.next() != null);
        }
        if (en != null) {
            do {
                ++e;
            } while (entr.next() != null);
        }
        if (e != c) {
            throw Err.ARCH_DIFF.get(this.info, e, c);
        }
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        ArchiveOut out = ArchiveOut.get(in.format(), this.info);
        try {
            if (in instanceof GZIPIn) {
                throw Err.ARCH_MODIFY.get(this.info, in.format().toUpperCase(Locale.ENGLISH));
            }
            while (in.more()) {
                if (hm.contains(Token.token(in.entry().getName()))) continue;
                out.write(in);
            }
            for (byte[] h : hm) {
                if (h == null) continue;
                Item[] it = (Item[])hm.get(h);
                this.add(it[0], it[1], out, 8, ctx);
            }
        }
        catch (IOException ex) {
            throw Err.ARCH_FAIL.get(this.info, ex);
        }
        finally {
            in.close();
            out.close();
        }
        return new B64(out.toArray());
    }

    private B64 delete(QueryContext ctx) throws QueryException {
        Item en;
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        TokenObjMap hm = new TokenObjMap();
        Iter names = ctx.iter(this.expr[1]);
        while ((en = names.next()) != null) {
            hm.put(this.checkElmStr(en).string(this.info), null);
        }
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        ArchiveOut out = ArchiveOut.get(in.format(), this.info);
        try {
            if (in instanceof GZIPIn) {
                throw Err.ARCH_MODIFY.get(this.info, in.format().toUpperCase(Locale.ENGLISH));
            }
            while (in.more()) {
                if (hm.contains(Token.token(in.entry().getName()))) continue;
                out.write(in);
            }
        }
        catch (IOException ex) {
            throw Err.ARCH_FAIL.get(this.info, ex);
        }
        finally {
            in.close();
            out.close();
        }
        return new B64(out.toArray());
    }

    private TokenList extract(QueryContext ctx) throws QueryException {
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.B64);
        TokenSet hs = this.entries(1, ctx);
        TokenList tl = new TokenList();
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        try {
            while (in.more()) {
                ZipEntry ze = in.entry();
                if (ze.isDirectory() || hs != null && hs.delete(Token.token(ze.getName())) == 0) continue;
                tl.add(in.read());
            }
        }
        catch (IOException ex) {
            throw Err.ARCH_FAIL.get(this.info, ex);
        }
        finally {
            in.close();
        }
        return tl;
    }

    private Item write(QueryContext ctx) throws QueryException {
        File path = this.checkFile(0, ctx);
        B64 archive = (B64)this.checkType(this.checkItem(this.expr[1], ctx), AtomType.B64);
        TokenSet hs = this.entries(2, ctx);
        ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
        try {
            while (in.more()) {
                ZipEntry ze = in.entry();
                String name = ze.getName();
                if (hs != null && hs.delete(Token.token(name)) == 0) continue;
                IOFile file = new IOFile(path.getPath(), name);
                if (ze.isDirectory()) {
                    file.md();
                    continue;
                }
                file.dir().md();
                file.write(in.read());
            }
        }
        catch (IOException ex) {
            throw Err.ARCH_FAIL.get(this.info, ex);
        }
        finally {
            in.close();
        }
        return null;
    }

    private TokenSet entries(int e, QueryContext ctx) throws QueryException {
        TokenSet hs = null;
        if (e < this.expr.length) {
            Item en;
            hs = new TokenSet();
            Iter names = ctx.iter(this.expr[e]);
            while ((en = names.next()) != null) {
                hs.add(this.checkElmStr(en).string(this.info));
            }
        }
        return hs;
    }

    private void add(Item entry, Item cont, ArchiveOut out, int level, QueryContext ctx) throws QueryException, IOException {
        String name = Token.string(entry.string(this.info));
        if (name.isEmpty()) {
            throw Err.ARCH_EMPTY.get(this.info, new Object[0]);
        }
        if (Prop.WIN) {
            name = name.replace('\\', '/');
        }
        ZipEntry ze = new ZipEntry(name);
        String enc = null;
        byte[] lvl = null;
        if (entry instanceof ANode) {
            byte[] ea;
            ANode el = (ANode)entry;
            lvl = el.attribute(LEVEL);
            byte[] mod = el.attribute(LAST_MOD);
            if (mod != null) {
                try {
                    ze.setTime(this.dateTimeToMs(new Dtm(mod, this.info), ctx));
                }
                catch (QueryException qe) {
                    throw Err.ARCH_DATETIME.get(this.info, new Object[]{mod});
                }
            }
            if ((ea = el.attribute(ENCODING)) != null && !Charset.isSupported(enc = Token.string(ea))) {
                throw Err.ARCH_ENCODING.get(this.info, new Object[]{ea});
            }
        }
        byte[] val = this.checkStrBin(cont);
        if (cont instanceof AStr && enc != null && enc != "UTF-8") {
            val = this.encode(val, enc, ctx);
        }
        try {
            out.level(lvl == null ? level : Token.toInt(lvl));
        }
        catch (IllegalArgumentException ex) {
            throw Err.ARCH_LEVEL.get(this.info, new Object[]{lvl});
        }
        out.write(ze, val);
    }

    private byte[] encode(byte[] val, String enc, QueryContext ctx) throws QueryException {
        try {
            return FNConvert.toString((InputStream)new ArrayInput(val), enc, ctx);
        }
        catch (IOException ex) {
            throw Err.ARCH_ENCODE.get(this.info, ex);
        }
    }

    private Item checkElmStr(Item it) throws QueryException {
        if (it instanceof AStr || TEST.eq(it)) {
            return it;
        }
        throw Err.ELMSTRTYPE.get(this.info, Q_ENTRY.string(), it.type);
    }

    public static class ArchiveOptions
    extends Options {
        public static final StringOption FORMAT = new StringOption("format", "zip");
        public static final StringOption ALGORITHM = new StringOption("algorithm", "deflate");
    }
}

