/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.Functions;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Ann;
import org.basex.query.util.inspect.PlainDoc;
import org.basex.query.util.inspect.XQDoc;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;

public final class FNInspect
extends StandardFunc {
    public FNInspect(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _INSPECT_FUNCTIONS: {
                return this.functions(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _INSPECT_FUNCTION: {
                return this.function(ctx);
            }
            case _INSPECT_MODULE: {
                return this.module(ctx);
            }
            case _INSPECT_CONTEXT: {
                return this.context(ctx);
            }
            case _INSPECT_XQDOC: {
                return this.xqdoc(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.sig == Function._INSPECT_FUNCTIONS) {
            for (StaticFunc sf : ctx.funcs.funcs()) {
                sf.compile(ctx);
            }
            return this.functions(ctx).value();
        }
        return this;
    }

    private Item function(QueryContext ctx) throws QueryException {
        FItem f = this.checkFunc(this.expr[0], ctx);
        StaticFunc sf = f.funcName() == null ? null : ctx.funcs.get(f.funcName(), f.arity(), null, false);
        return new PlainDoc(ctx, this.info).function(f.funcName(), sf, f.funcType(), null);
    }

    private Item context(QueryContext ctx) throws QueryException {
        return new PlainDoc(ctx, this.info).context();
    }

    private Item module(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        return new PlainDoc(ctx, this.info).parse(this.checkPath(this.expr[0], ctx));
    }

    private Item xqdoc(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        return new XQDoc(ctx, this.info).parse(this.checkPath(this.expr[0], ctx));
    }

    private ValueBuilder functions(QueryContext ctx) throws QueryException {
        ValueBuilder vb = new ValueBuilder();
        for (StaticFunc sf : ctx.funcs.funcs()) {
            FuncItem fi = Functions.getUser(sf, ctx, sf.sc, this.info);
            if (fi.annotations().contains(Ann.Q_UPDATING)) continue;
            vb.add(fi);
        }
        return vb;
    }
}

