/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.build.JsonParserOptions;
import org.basex.build.JsonSerialOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNJson
extends StandardFunc {
    private static final QNm Q_OPTIONS = QNm.get("json:options", QueryText.JSONURI);

    public FNJson(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _JSON_PARSE: {
                return this.parse(ctx);
            }
            case _JSON_SERIALIZE: {
                return this.serialize(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item parse(QueryContext ctx) throws QueryException {
        byte[] input = this.checkStr(this.expr[0], ctx);
        JsonParserOptions opts = this.checkOptions(1, Q_OPTIONS, new JsonParserOptions(), ctx);
        try {
            JsonConverter conv = JsonConverter.get(opts);
            conv.convert(input, null);
            return conv.finish();
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
    }

    private Str serialize(QueryContext ctx) throws QueryException {
        Iter iter = ctx.iter(this.expr[0]);
        JsonSerialOptions jopts = this.checkOptions(1, Q_OPTIONS, new JsonSerialOptions(), ctx);
        SerializerOptions sopts = new SerializerOptions();
        sopts.set(SerializerOptions.METHOD, SerialMethod.JSON);
        sopts.set(SerializerOptions.JSON, jopts);
        return Str.get(Token.delete(this.serialize(iter, sopts, Err.INVALIDOPT), 13));
    }
}

