/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.math.BigDecimal;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class FNNum
extends StandardFunc {
    public FNNum(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            return null;
        }
        Type ip = it.type;
        if (!ip.isNumberOrUntyped()) {
            throw Err.numberError(this, it);
        }
        double d = it.dbl(this.info);
        switch (this.sig) {
            case ABS: {
                return FNNum.abs(it, this.info);
            }
            case CEILING: {
                return FNNum.num(it, d, StrictMath.ceil(d));
            }
            case FLOOR: {
                return FNNum.num(it, d, StrictMath.floor(d));
            }
            case ROUND: {
                return this.rnd(it, d, false, ctx);
            }
            case ROUND_HALF_TO_EVEN: {
                return this.rnd(it, d, true, ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item rnd(Item it, double d, boolean h2e, QueryContext ctx) throws QueryException {
        long p = this.expr.length == 1 ? 0L : this.checkItr(this.expr[1], ctx);
        return FNNum.round(it, d, p, h2e, this.info);
    }

    public static Item abs(Item it, InputInfo ii) throws QueryException {
        double d = it.dbl(ii);
        boolean s = d > 0.0 || 1.0 / d > 0.0;
        Type ip = it.type;
        if (ip instanceof AtomType) {
            switch ((AtomType)ip) {
                case DBL: {
                    return s ? it : Dbl.get(Math.abs(it.dbl(ii)));
                }
                case FLT: {
                    return s ? it : Flt.get(Math.abs((float)it.dbl(ii)));
                }
                case DEC: {
                    return s ? it : Dec.get(it.dec(ii).abs());
                }
                case ITR: {
                    return s ? it : Int.get(Math.abs(it.itr(ii)));
                }
            }
        }
        return ip.instanceOf(AtomType.ITR) ? Int.get(Math.abs(it.itr(ii))) : Dec.get(it.dec(ii).abs());
    }

    public static Item round(Item it, double d, long prec, boolean h2e, InputInfo ii) throws QueryException {
        Item num;
        Item item = num = it.type.isUntyped() ? Dbl.get(it.dbl(ii)) : it;
        if (num.type == AtomType.DEC && prec >= 0L) {
            BigDecimal bd = num.dec(ii);
            int m = h2e ? 6 : (bd.signum() > 0 ? 4 : 5);
            return Dec.get(prec > Integer.MAX_VALUE ? bd : bd.setScale((int)prec, m));
        }
        double c = d;
        if (!Double.isNaN(c) && !Double.isInfinite(c) && prec < 32L) {
            long i;
            double p = 1.0;
            for (i = prec; i > 0L; --i) {
                p *= 10.0;
            }
            for (i = prec; i < 0L; ++i) {
                p /= 10.0;
            }
            if (h2e) {
                double r;
                c *= p;
                if (d < 0.0) {
                    c = -c;
                }
                c += (r = c % 1.0) == 0.5 ? (c % 2.0 == 1.5 ? 0.5 : -0.5) : (r > 0.5 ? 1.0 - r : -r);
                c /= p;
                if (d < 0.0) {
                    c = -c;
                }
            } else if (c >= -9.223372036854776E18 && c < 9.223372036854776E18) {
                double dp = d * p;
                c = (dp >= -0.5 && dp < 0.0 ? -0.0 : (double)StrictMath.round(dp)) / p;
            }
        }
        return FNNum.num(it, d, c);
    }

    private static Item num(Item it, double n, double d) {
        Item i;
        Type ip = it.type;
        Item item = i = ip.isUntyped() ? Dbl.get(n) : it;
        if (n == d) {
            return i;
        }
        if (ip instanceof AtomType) {
            switch ((AtomType)ip) {
                case DEC: {
                    return Dec.get(d);
                }
                case DBL: {
                    return Dbl.get(d);
                }
                case FLT: {
                    return Flt.get((float)d);
                }
                case ITR: {
                    return Int.get((long)d);
                }
            }
        }
        return Dbl.get(d);
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.X30 && this.sig == Function.ROUND && this.expr.length == 2 || super.has(flag);
    }
}

