/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Ann;
import org.basex.query.util.Compare;
import org.basex.query.util.Err;
import org.basex.query.util.unit.Suite;
import org.basex.query.util.unit.Unit;
import org.basex.query.util.unit.UnitException;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNUnit
extends StandardFunc {
    public FNUnit(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _UNIT_ASSERT: {
                return this.assrt(ctx);
            }
            case _UNIT_ASSERT_EQUALS: {
                return this.assertEquals(ctx);
            }
            case _UNIT_FAIL: {
                return this.fail(ctx);
            }
            case _UNIT_TEST: {
                return this.test(ctx);
            }
            case _UNIT_TEST_URIS: {
                return this.testUris(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    Expr opt(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.sig == Function._UNIT_TEST_URIS || this.sig == Function._UNIT_TEST && this.expr.length == 0) {
            block0: for (StaticFunc fn : ctx.funcs.funcs()) {
                if (fn.compiled()) continue;
                Ann ann = fn.ann;
                int i = ann.size();
                while (--i >= 0) {
                    if (!Token.eq(ann.names[i].uri(), QueryText.UNITURI)) continue;
                    fn.compile(ctx);
                    continue block0;
                }
            }
        }
        return super.opt(ctx, scp);
    }

    private Item assrt(QueryContext ctx) throws QueryException {
        byte[] str;
        byte[] byArray = str = this.expr.length < 2 ? null : this.checkStr(this.expr[1], ctx);
        if (this.expr[0].ebv(ctx, this.info).bool(this.info)) {
            return null;
        }
        throw str == null ? Err.UNIT_ASSERT.get(this.info, new Object[0]) : Err.UNIT_MESSAGE.get(this.info, new Object[]{str});
    }

    private Item assertEquals(QueryContext ctx) throws QueryException {
        Item it2;
        Item it1;
        byte[] str = this.expr.length < 3 ? null : this.checkStr(this.expr[2], ctx);
        Iter iter1 = ctx.iter(this.expr[0]);
        Iter iter2 = ctx.iter(this.expr[1]);
        Compare comp = new Compare(this.info);
        int c = 1;
        while (true) {
            boolean empty2;
            it1 = iter1.next();
            it2 = iter2.next();
            boolean empty1 = it1 == null;
            boolean bl = empty2 = it2 == null;
            if (empty1 && empty2) {
                return null;
            }
            if (empty1 || empty2 || !comp.deep(it1.iter(), it2.iter())) break;
            ++c;
        }
        if (str != null) {
            throw Err.UNIT_MESSAGE.get(this.info, new Object[]{str});
        }
        throw new UnitException(this.info, Err.UNIT_ASSERT_EQUALS, it1, it2, c);
    }

    private Item fail(QueryContext ctx) throws QueryException {
        throw Err.UNIT_MESSAGE.get(this.info, new Object[]{this.checkStr(this.expr[0], ctx)});
    }

    private Item test(QueryContext ctx) throws QueryException {
        Item it;
        Unit unit = new Unit(ctx, this.info);
        if (this.expr.length == 0) {
            return unit.test(this.sc);
        }
        ArrayList<StaticFunc> funcs = new ArrayList<StaticFunc>();
        Iter ir = ctx.iter(this.expr[0]);
        while ((it = ir.next()) != null) {
            StaticFunc sf;
            FItem fi = this.checkFunc(it, ctx);
            if (fi.funcName() == null || (sf = ctx.funcs.get(fi.funcName(), fi.arity(), null, true)) == null) continue;
            funcs.add(sf);
        }
        return unit.test(this.sc, funcs);
    }

    private Item testUris(QueryContext ctx) throws QueryException {
        Item it;
        this.checkCreate(ctx);
        ArrayList<IO> inputs = new ArrayList<IO>();
        Iter ir = ctx.iter(this.expr[0]);
        while ((it = ir.next()) != null) {
            inputs.add(this.checkPath(it, ctx));
        }
        return new Suite(ctx, this.info).test(inputs);
    }
}

