/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.core.BaseXException;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.path.NodeTest;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.options.Options;

public final class FuncOptions {
    public static final QNm Q_SPARAM = QNm.get("serialization-parameters", QueryText.OUTPUTURI);
    private static final String VALUE = "value";
    private final QNm root;
    private final NodeTest test;
    private final InputInfo info;

    public FuncOptions(QNm name, InputInfo ii) {
        this.test = new NodeTest(name);
        this.root = name;
        this.info = ii;
    }

    public void parse(Item it, Options options) throws QueryException {
        this.parse(it, options, Err.INVALIDOPT);
    }

    void parse(Item item, Options options, Err error) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        if (item != null) {
            try {
                if (!(item instanceof Map) && !this.test.eq(item)) {
                    throw Err.ELMMAPTYPE.get(this.info, this.root, item.type);
                }
                options.parse(tb.add(this.optString(item)).toString());
            }
            catch (BaseXException ex) {
                throw error.get(this.info, ex);
            }
        }
    }

    private String optString(Item item) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        if (item instanceof Map) {
            Map map = (Map)item;
            for (Item it : map.keys()) {
                if (!(it instanceof AStr)) {
                    throw Err.FUNCMP.get(this.info, map.description(), AtomType.STR, it.type);
                }
                tb.add(it.string(this.info)).add(61);
                Value val = map.get(it, this.info);
                if (!val.isItem()) {
                    throw Err.FUNCMP.get(this.info, map.description(), AtomType.ITEM, val);
                }
                tb.add(this.optString((Item)val).replace(",", ",,")).add(44);
            }
        } else if (item.type == NodeType.ELM) {
            for (ANode node : ((ANode)item).children()) {
                byte[] v;
                QNm qn;
                if (node.type != NodeType.ELM || !Token.eq((qn = node.qname()).uri(), this.root.uri())) continue;
                if (FuncOptions.hasElements(node)) {
                    v = Token.token(this.optString(node));
                } else {
                    v = node.attribute(VALUE);
                    if (v == null) {
                        v = node.string();
                    }
                }
                tb.add(Token.string(qn.local())).add(61).add(this.optString(Str.get(v)).replace(",", ",,")).add(44);
            }
        } else {
            tb.add(item.string(this.info));
        }
        return tb.toString();
    }

    private static boolean hasElements(ANode node) {
        for (ANode n : node.children()) {
            if (n.type != NodeType.ELM) continue;
            return true;
        }
        return false;
    }

    public static SerializerOptions serializer(Item it, InputInfo info) throws QueryException {
        return FuncOptions.serializer(it, new SerializerOptions(), info);
    }

    public static SerializerOptions serializer(Item it, SerializerOptions sopts, InputInfo info) throws QueryException {
        new FuncOptions(Q_SPARAM, info).parse(it, sopts, Err.SEROPT);
        return sopts;
    }
}

