/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.gflwor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.FNInfo;
import org.basex.query.gflwor.Count;
import org.basex.query.gflwor.For;
import org.basex.query.gflwor.Let;
import org.basex.query.gflwor.Where;
import org.basex.query.gflwor.Window;
import org.basex.query.iter.Iter;
import org.basex.query.path.AxisPath;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class GFLWOR
extends ParseExpr {
    private Expr ret;
    private final LinkedList<Clause> clauses;

    public GFLWOR(InputInfo ii, LinkedList<Clause> cls, Expr rt) {
        super(ii);
        this.clauses = cls;
        this.ret = rt;
    }

    @Override
    public Iter iter(final QueryContext ctx) {
        Eval e = new Eval(){
            private boolean first = true;

            @Override
            public boolean next(QueryContext c) {
                if (!this.first) {
                    return false;
                }
                this.first = false;
                return true;
            }
        };
        for (Clause cls : this.clauses) {
            e = cls.eval(e);
        }
        final Eval ev = e;
        return new Iter(){
            private Iter sub = Empty.ITER;
            private boolean drained;

            @Override
            public Item next() throws QueryException {
                if (this.drained) {
                    return null;
                }
                while (true) {
                    Item it = this.sub.next();
                    ctx.checkStop();
                    if (it != null) {
                        return it;
                    }
                    if (!ev.next(ctx)) {
                        this.drained = true;
                        return null;
                    }
                    this.sub = GFLWOR.this.ret.iter(ctx);
                }
            }
        };
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        int i = 0;
        try {
            for (Clause c : this.clauses) {
                c.compile(ctx, scp);
                ++i;
            }
            this.ret = this.ret.compile(ctx, scp);
        }
        catch (QueryException qe) {
            this.clauseError(qe, i);
        }
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        boolean changed;
        Where wh;
        ListIterator<Where> iter = this.clauses.listIterator();
        while (iter.hasNext()) {
            Clause c = (Clause)iter.next();
            if (!(c instanceof Where)) continue;
            wh = (Where)c;
            if (!(wh.pred instanceof And)) continue;
            iter.remove();
            for (Expr e : ((Arr)wh.pred).expr) {
                iter.add(new Where(e, wh.info));
            }
        }
        do {
            TypeCheck tc;
            GFLWOR sub;
            GFLWOR sub2;
            changed = this.forToLet(ctx);
            changed |= this.slideLetsOut(ctx);
            changed |= this.inlineLets(ctx, scp);
            changed |= this.cleanDeadVars(ctx);
            changed |= this.unnestFLWR(ctx, scp);
            changed |= this.optimizeWhere(ctx, scp);
            if (this.clauses.isEmpty()) {
                ctx.compInfo("simplifying flwor expression", this);
                return this.ret;
            }
            if (this.clauses.getLast() instanceof For && this.ret instanceof VarRef) {
                For last = (For)this.clauses.getLast();
                if (!last.var.checksType() && last.var.is(((VarRef)this.ret).var)) {
                    this.clauses.removeLast();
                    this.ret = last.expr;
                    changed = true;
                }
            }
            if (!this.clauses.isEmpty() && this.clauses.getFirst() instanceof For) {
                For fst = (For)this.clauses.getFirst();
                if (!fst.empty) {
                    if (fst.expr instanceof GFLWOR) {
                        ctx.compInfo("flattening %", fst);
                        sub2 = (GFLWOR)fst.expr;
                        this.clauses.set(0, new For(fst.var, null, fst.score, sub2.ret, false, fst.info));
                        if (fst.pos != null) {
                            this.clauses.add(1, new Count(fst.pos, fst.info));
                        }
                        this.clauses.addAll(0, sub2.clauses);
                        changed = true;
                    } else if (this.clauses.size() > 1 && this.clauses.get(1) instanceof Count) {
                        Count cnt = (Count)this.clauses.get(1);
                        if (fst.pos != null) {
                            Let lt = new Let(cnt.count, new VarRef(cnt.info, fst.pos).optimize(ctx, scp), false, cnt.info);
                            this.clauses.set(1, lt.optimize(ctx, scp));
                        } else {
                            this.clauses.set(0, new For(fst.var, cnt.count, fst.score, fst.expr, false, fst.info).optimize(ctx, scp));
                            this.clauses.remove(1);
                        }
                        changed = true;
                    }
                }
            }
            if (this.clauses.isEmpty()) continue;
            if (this.ret instanceof GFLWOR && (sub = (GFLWOR)this.ret).isFLWR()) {
                ctx.compInfo("flattening %", this);
                this.clauses.addAll(sub.clauses);
                this.ret = sub.ret;
                changed = true;
            }
            TypeCheck typeCheck = tc = this.ret instanceof TypeCheck ? (TypeCheck)this.ret : null;
            if (!(this.ret instanceof GFLWOR) && (tc == null || !(tc.expr instanceof GFLWOR))) continue;
            sub2 = (GFLWOR)(tc == null ? this.ret : tc.expr);
            if (!(sub2.clauses.getFirst() instanceof Let)) continue;
            ctx.compInfo("flattening %", this);
            LinkedList<Clause> cls = sub2.clauses;
            do {
                this.clauses.add(cls.removeFirst());
            } while (!cls.isEmpty() && cls.getFirst() instanceof Let);
            if (tc != null) {
                tc.expr = sub2.optimize(ctx, scp);
            }
            this.ret = this.ret.optimize(ctx, scp);
            changed = true;
        } while (changed);
        this.mergeWheres();
        this.size = this.calcSize();
        if (this.size == 0L && !this.has(Expr.Flag.NDT) && !this.has(Expr.Flag.UPD)) {
            ctx.compInfo("rewriting %", this);
            return Empty.SEQ;
        }
        this.type = SeqType.get(this.ret.type().type, this.size);
        if (this.clauses.getFirst() instanceof Where) {
            wh = (Where)this.clauses.removeFirst();
            return new If(this.info, wh.pred, this.clauses.isEmpty() ? this.ret : this, (Expr)Empty.SEQ);
        }
        return this;
    }

    private long calcSize() {
        Clause c;
        long output = this.ret.size();
        if (output == 0L) {
            return 0L;
        }
        long tuples = 1L;
        Iterator i$ = this.clauses.iterator();
        while (i$.hasNext() && (tuples = (c = (Clause)i$.next()).calcSize(tuples)) > 0L) {
        }
        return tuples == 0L ? 0L : (output < 0L || tuples < 0L ? -1L : tuples * output);
    }

    private boolean forToLet(QueryContext ctx) {
        boolean change = false;
        int i = this.clauses.size();
        while (--i >= 0) {
            Clause c = this.clauses.get(i);
            if (!(c instanceof For) || !((For)c).asLet(this.clauses, i)) continue;
            ctx.compInfo("rewriting singleton for to let", new Object[0]);
            change = true;
        }
        return change;
    }

    private boolean inlineLets(QueryContext ctx, VarScope scp) throws QueryException {
        boolean thisRound;
        boolean change = false;
        block0: do {
            thisRound = false;
            ListIterator iter = this.clauses.listIterator();
            while (iter.hasNext()) {
                Clause c = (Clause)iter.next();
                int next = iter.nextIndex();
                if (!(c instanceof Let)) continue;
                Let lt = (Let)c;
                Expr expr = lt.expr;
                if (expr.has(Expr.Flag.NDT)) continue;
                lt.var.checkType(expr, lt.info);
                VarUsage use = this.count(lt.var, next);
                if (use == VarUsage.NEVER) {
                    ctx.compInfo("removing variable %", lt.var);
                    iter.remove();
                    change = true;
                    thisRound = true;
                    continue;
                }
                if (!(expr.isValue() || expr instanceof VarRef && !lt.var.checksType() || use == VarUsage.ONCE && !expr.has(Expr.Flag.CTX) && !expr.has(Expr.Flag.CNS)) && (!(expr instanceof AxisPath) || !((AxisPath)expr).cheap())) continue;
                ctx.compInfo("inlining %", lt);
                this.inline(ctx, scp, lt.var, lt.inlineExpr(ctx, scp), next);
                iter.remove();
                change = true;
                thisRound = true;
                continue block0;
            }
        } while (thisRound);
        return change;
    }

    private boolean unnestFLWR(QueryContext ctx, VarScope scp) throws QueryException {
        boolean thisRound;
        boolean change = false;
        do {
            thisRound = false;
            ListIterator<Clause> iter = this.clauses.listIterator();
            while (iter.hasNext()) {
                Expr rest;
                Expr e;
                GFLWOR fl;
                Clause cl = (Clause)iter.next();
                boolean isFor = cl instanceof For;
                boolean isLet = cl instanceof Let;
                if (isFor) {
                    For fr = (For)cl;
                    if (!fr.empty && fr.pos == null && fr.expr instanceof GFLWOR && (fl = (GFLWOR)fr.expr).isFLWR()) {
                        ctx.compInfo("flattening %", this);
                        iter.remove();
                        for (Clause c : fl.clauses) {
                            iter.add(c);
                        }
                        fr.expr = fl.ret;
                        iter.add(fr);
                        change = true;
                        thisRound = true;
                    }
                }
                if (thisRound || !isFor && !isLet || !((e = isFor ? ((For)cl).expr : ((Let)cl).expr) instanceof GFLWOR)) continue;
                fl = (GFLWOR)e;
                LinkedList<Clause> cls = fl.clauses;
                if (!(cls.getFirst() instanceof Let)) continue;
                iter.remove();
                do {
                    iter.add(cls.removeFirst());
                } while (!cls.isEmpty() && cls.getFirst() instanceof Let);
                Expr expr = rest = fl.clauses.isEmpty() ? fl.ret : fl.optimize(ctx, scp);
                if (isFor) {
                    ((For)cl).expr = rest;
                } else {
                    ((Let)cl).expr = rest;
                }
                iter.add(cl);
                change = true;
                thisRound = true;
            }
        } while (thisRound);
        return change;
    }

    private boolean cleanDeadVars(QueryContext ctx) {
        final IntObjMap<Var> decl = new IntObjMap<Var>();
        final BitArray used = new BitArray();
        for (Clause cl : this.clauses) {
            for (Var v : cl.vars()) {
                decl.put(v.id, v);
            }
        }
        ASTVisitor marker = new ASTVisitor(){

            @Override
            public boolean used(VarRef ref) {
                int id = ref.var.id;
                if (decl.get(id) != null) {
                    used.set(id);
                }
                return true;
            }
        };
        this.ret.accept(marker);
        boolean change = false;
        int i = this.clauses.size();
        while (--i >= 0) {
            Clause curr = this.clauses.get(i);
            change |= curr.clean(ctx, decl, used);
            curr.accept(marker);
            for (Var v : curr.vars()) {
                used.clear(v.id);
            }
        }
        return change;
    }

    private boolean slideLetsOut(QueryContext ctx) {
        boolean change = false;
        for (int i = 1; i < this.clauses.size(); ++i) {
            Clause curr;
            Clause l = this.clauses.get(i);
            if (!(l instanceof Let) || l.has(Expr.Flag.NDT) || l.has(Expr.Flag.CNS)) continue;
            Let let = (Let)l;
            int insert = -1;
            int j = i;
            while (--j >= 0 && (curr = this.clauses.get(j)).skippable(let)) {
                if (!(curr instanceof For) && !(curr instanceof Window)) continue;
                insert = j;
            }
            if (insert < 0) continue;
            this.clauses.add(insert, this.clauses.remove(i));
            if (!change) {
                ctx.compInfo("moving for/let clauses", new Object[0]);
            }
            change = true;
        }
        return change;
    }

    private boolean optimizeWhere(QueryContext ctx, VarScope scp) throws QueryException {
        boolean change = false;
        block0: for (int i = 0; i < this.clauses.size(); ++i) {
            int newPos;
            Clause curr;
            Clause c = this.clauses.get(i);
            if (!(c instanceof Where) || c.has(Expr.Flag.NDT)) continue;
            Where wh = (Where)c;
            if (wh.pred.isValue()) {
                if (!(wh.pred instanceof Bln)) {
                    wh.pred = Bln.get(wh.pred.ebv(ctx, wh.info).bool(wh.info));
                }
                if (!((Item)wh.pred).bool(null)) break;
                this.clauses.remove(i--);
                change = true;
                continue;
            }
            int insert = -1;
            int j = i;
            while (--j >= 0 && (curr = this.clauses.get(j)).skippable(wh)) {
                if (curr instanceof Where) continue;
                insert = j;
            }
            if (insert >= 0) {
                this.clauses.add(insert, this.clauses.remove(i));
                change = true;
            }
            int b4 = newPos = insert < 0 ? i : insert;
            while (--b4 >= 0) {
                Clause before = this.clauses.get(b4);
                if (before instanceof For && ((For)before).toPred(ctx, scp, wh.pred)) {
                    this.clauses.remove(newPos);
                    --i;
                    change = true;
                    continue block0;
                }
                if (before instanceof Where) continue;
            }
        }
        if (change) {
            ctx.compInfo("rewriting where clause(s)", new Object[0]);
        }
        return change;
    }

    private void mergeWheres() {
        Where before = null;
        Iterator iter = this.clauses.iterator();
        while (iter.hasNext()) {
            Clause cl = (Clause)iter.next();
            if (cl instanceof Where) {
                Where wh = (Where)cl;
                if (wh.pred == Bln.FALSE) {
                    return;
                }
                if (before != null) {
                    iter.remove();
                    Expr e = before.pred;
                    if (e instanceof And) {
                        And and = (And)e;
                        and.expr = Array.add(and.expr, wh.pred);
                        continue;
                    }
                    before.pred = new And(before.info, e, wh.pred);
                    continue;
                }
                before = wh;
                continue;
            }
            before = null;
        }
    }

    @Override
    public boolean isVacuous() {
        return this.ret.isVacuous();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        for (Clause cls : this.clauses) {
            if (!cls.has(flag)) continue;
            return true;
        }
        return this.ret.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        for (Clause cl : this.clauses) {
            if (cl.removable(v)) continue;
            return false;
        }
        return this.ret.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.count(v, 0);
    }

    private VarUsage count(Var v, int p) {
        long c = 1L;
        VarUsage uses = VarUsage.NEVER;
        ListIterator<Clause> iter = this.clauses.listIterator(p);
        while (iter.hasNext()) {
            Clause cl = iter.next();
            uses = uses.plus(cl.count(v).times(c));
            c = cl.calcSize(c);
        }
        return uses.plus(this.ret.count(v).times(c));
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        return this.inline(ctx, scp, v, e, 0) ? this.optimize(ctx, scp) : null;
    }

    private boolean inline(QueryContext ctx, VarScope scp, Var v, Expr e, int p) throws QueryException {
        boolean change = false;
        ListIterator<Clause> iter = this.clauses.listIterator(p);
        while (iter.hasNext()) {
            Clause cl = iter.next();
            try {
                Clause c = cl.inline(ctx, scp, v, e);
                if (c == null) continue;
                change = true;
                iter.set(c);
            }
            catch (QueryException qe) {
                return this.clauseError(qe, iter.previousIndex() + 1);
            }
        }
        try {
            Expr rt = this.ret.inline(ctx, scp, v, e);
            if (rt != null) {
                change = true;
                this.ret = rt;
            }
        }
        catch (QueryException qe) {
            return this.clauseError(qe, this.clauses.size());
        }
        return change;
    }

    private boolean clauseError(QueryException qe, int idx) throws QueryException {
        ListIterator<Clause> iter = this.clauses.listIterator(idx);
        while (iter.hasPrevious()) {
            Clause b4 = iter.previous();
            if (!(b4 instanceof For) && !(b4 instanceof Window) && !(b4 instanceof Where)) continue;
            iter.next();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
            this.ret = FNInfo.error(qe, this.ret.type());
            return true;
        }
        throw qe;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        LinkedList<Clause> cls = new LinkedList<Clause>();
        for (Clause cl : this.clauses) {
            cls.add((Clause)cl.copy(ctx, scp, (IntObjMap)vs));
        }
        return this.copyType(new GFLWOR(this.info, cls, this.ret.copy(ctx, scp, vs)));
    }

    private boolean isFLWR() {
        for (Clause cl : this.clauses) {
            if (cl instanceof For || cl instanceof Let || cl instanceof Where) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Clause cl : this.clauses) {
            if (cl.accept(visitor)) continue;
            return false;
        }
        return this.ret.accept(visitor);
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(new Object[0]);
        for (Clause cl : this.clauses) {
            cl.plan(e);
        }
        this.ret.plan(e);
        plan.add(e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Clause cl : this.clauses) {
            sb.append(cl).append(' ');
        }
        return sb.append("return").append(' ').append(this.ret).toString();
    }

    @Override
    public void checkUp() throws QueryException {
        for (Clause cl : this.clauses) {
            cl.checkUp();
        }
        this.ret.checkUp();
    }

    @Override
    public void markTailCalls(QueryContext ctx) {
        long n = 1L;
        for (Clause c : this.clauses) {
            n = c.calcSize(n);
            if (n == 1L) continue;
            return;
        }
        this.ret.markTailCalls(ctx);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (Clause cl : this.clauses) {
            sz += cl.exprSize();
        }
        return this.ret.exprSize() + sz;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, QueryContext ctx, VarScope scp) throws QueryException {
        if (tc.type.occ != SeqType.Occ.ZERO_MORE) {
            return null;
        }
        this.ret = tc.check(this.ret, ctx, scp);
        return this.optimize(ctx, scp);
    }

    public static abstract class Clause
    extends ParseExpr {
        final Var[] vars;

        Clause(InputInfo ii, Var ... vs) {
            super(ii);
            this.vars = vs;
        }

        boolean clean(QueryContext ctx, IntObjMap<Var> decl, BitArray used) {
            return false;
        }

        abstract Eval eval(Eval var1);

        @Override
        public abstract Clause compile(QueryContext var1, VarScope var2) throws QueryException;

        @Override
        public abstract Clause optimize(QueryContext var1, VarScope var2) throws QueryException;

        @Override
        public abstract Clause inline(QueryContext var1, VarScope var2, Var var3, Expr var4) throws QueryException;

        @Override
        @Deprecated
        public Iter iter(QueryContext ctx) throws QueryException {
            throw Util.notExpected(new Object[0]);
        }

        @Override
        @Deprecated
        public Value value(QueryContext ctx) throws QueryException {
            throw Util.notExpected(new Object[0]);
        }

        @Override
        @Deprecated
        public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
            throw Util.notExpected(new Object[0]);
        }

        @Override
        public abstract Clause copy(QueryContext var1, VarScope var2, IntObjMap<Var> var3);

        boolean skippable(Clause cl) {
            return cl.accept(new ASTVisitor(){

                @Override
                public boolean used(VarRef ref) {
                    for (Var v : Clause.this.vars) {
                        if (!v.is(ref.var)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        public final Var[] vars() {
            return this.vars;
        }

        public final boolean declares(Var v) {
            for (Var decl : this.vars) {
                if (!v.is(decl)) continue;
                return true;
            }
            return false;
        }

        abstract long calcSize(long var1);
    }

    static interface Eval {
        public boolean next(QueryContext var1) throws QueryException;
    }
}

