/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.data.ExprInfo;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.index.stats.Stats;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Preds;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisStep;
import org.basex.query.path.IterPosStep;
import org.basex.query.path.IterStep;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class Step
extends Preds {
    Axis axis;
    public Test test;

    public static Step get(InputInfo ii, Axis a, Test t, Expr ... p) {
        boolean num = false;
        for (Expr pr : p) {
            num |= pr.type().mayBeNumber() || pr.has(Expr.Flag.FCS);
        }
        return num ? new AxisStep(ii, a, t, p) : new IterStep(ii, a, t, p);
    }

    Step(InputInfo ii, Axis a, Test t, Expr ... p) {
        super(ii, p);
        this.axis = a;
        this.test = t;
        this.type = SeqType.NOD_ZM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        if (!this.test.compile(ctx)) {
            return Empty.SEQ;
        }
        Type ct = ctx.value != null ? ctx.value.type : null;
        boolean leaf = ctx.leaf;
        ctx.leaf = false;
        try {
            Expr e;
            Data data = ctx.data();
            if (data != null && this.test.mode == Test.Mode.LN && this.test.type != NodeType.ATT && this.axis.down && data.meta.uptodate && data.nspaces.size() == 0) {
                Stats s = data.tagindex.stat(data.tagindex.id(((NameTest)this.test).ln));
                boolean bl = ctx.leaf = s != null && s.isLeaf();
            }
            if (ct == NodeType.DOC) {
                ctx.value.type = NodeType.NOD;
            }
            if ((e = super.compile(ctx, scp)) != this || e instanceof IterStep) {
                Expr expr = e;
                return expr;
            }
        }
        finally {
            if (ct == NodeType.DOC) {
                ctx.value.type = NodeType.DOC;
            }
            ctx.leaf = leaf;
        }
        if (!this.has(Expr.Flag.FCS)) {
            return new IterStep(this.info, this.axis, this.test, this.preds);
        }
        return this instanceof IterPosStep || !this.posIterator() ? this : new IterPosStep(this);
    }

    @Override
    public abstract Step copy(QueryContext var1, VarScope var2, IntObjMap<Var> var3);

    public final boolean simple(Axis ax, boolean name) {
        return this.axis == ax && this.preds.length == 0 && (name ? this.test.mode == Test.Mode.LN : this.test == Test.NOD);
    }

    final ArrayList<PathNode> nodes(ArrayList<PathNode> nodes, Data data) {
        if (this.preds.length != 0 || data.nspaces.globalNS() == null) {
            return null;
        }
        byte kind = -1;
        int name = 0;
        if (this.test.type != null) {
            kind = ANode.kind(this.test.type);
            if (kind == 5) {
                return null;
            }
            if (this.test.mode == Test.Mode.LN) {
                Names names = kind == 3 ? data.atnindex : data.tagindex;
                name = names.id(((NameTest)this.test).ln);
            } else if (this.test.mode != null && this.test.mode != Test.Mode.ALL) {
                return null;
            }
        }
        if (this.axis != Axis.ATTR && this.axis != Axis.CHILD && this.axis != Axis.DESC && this.axis != Axis.DESCORSELF && this.axis != Axis.SELF) {
            return null;
        }
        ArrayList<PathNode> tmp = new ArrayList<PathNode>();
        for (PathNode n : nodes) {
            if (!(this.axis != Axis.SELF && this.axis != Axis.DESCORSELF || kind != -1 && (kind != n.kind || name != 0 && name != n.name) || tmp.contains(n))) {
                tmp.add(n);
            }
            if (this.axis == Axis.SELF) continue;
            this.add(n, tmp, name, kind);
        }
        return tmp;
    }

    private void add(PathNode node, ArrayList<PathNode> nodes, int name, int kind) {
        for (PathNode n : node.ch) {
            if (this.axis == Axis.DESC || this.axis == Axis.DESCORSELF) {
                this.add(n, nodes, name, kind);
            }
            if ((kind != -1 || !(n.kind != 3 ^ this.axis == Axis.ATTR)) && (kind != n.kind || name != 0 && name != n.name) || nodes.contains(n)) continue;
            nodes.add(n);
        }
    }

    final Step addPreds(Expr ... prds) {
        for (Expr p : prds) {
            this.preds = Array.add(this.preds, p);
        }
        return Step.get(this.info, this.axis, this.test, this.preds);
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Step)) {
            return false;
        }
        Step st = (Step)cmp;
        if (this.preds.length != st.preds.length || this.axis != st.axis || !this.test.sameAs(st.test)) {
            return false;
        }
        for (int p = 0; p < this.preds.length; ++p) {
            if (this.preds[p].sameAs(st.preds[p])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Type ct = ctx.value != null ? ctx.value.type : null;
        boolean leaf = ctx.leaf;
        ctx.leaf = false;
        try {
            if (ct == NodeType.DOC) {
                ctx.value.type = NodeType.NOD;
            }
            Expr expr = super.inline(ctx, scp, v, e);
            return expr;
        }
        finally {
            if (ct == NodeType.DOC) {
                ctx.value.type = NodeType.DOC;
            }
            ctx.leaf = leaf;
        }
    }

    @Override
    public final void plan(FElem plan) {
        FElem el = this.planElem(QueryText.AXIS, this.axis.name, QueryText.TEST, this.test);
        this.addPlan(plan, el, new ExprInfo[0]);
        super.plan(el);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.test == Test.NOD) {
            if (this.axis == Axis.PARENT) {
                sb.append("..");
            }
            if (this.axis == Axis.SELF) {
                sb.append('.');
            }
        }
        if (sb.length() == 0) {
            if (this.axis == Axis.ATTR && this.test instanceof NameTest) {
                sb.append('@');
            } else if (this.axis != Axis.CHILD) {
                sb.append((Object)this.axis).append("::");
            }
            sb.append(this.test);
        }
        return sb.append(super.toString()).toString();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Expr e : this.preds) {
            visitor.enterFocus();
            if (!e.accept(visitor)) {
                return false;
            }
            visitor.exitFocus();
        }
        return true;
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (Expr e : this.preds) {
            sz += e.exprSize();
        }
        return sz;
    }
}

