/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.DataUpdates;
import org.basex.query.up.NameUpdates;
import org.basex.query.up.primitives.DataUpdate;
import org.basex.query.up.primitives.NameUpdate;
import org.basex.query.up.primitives.Update;
import org.basex.query.util.Err;
import org.basex.util.list.StringList;

public abstract class ContextModifier {
    private final Map<Data, DataUpdates> dbUpdates = new HashMap<Data, DataUpdates>();
    private final Map<String, NameUpdates> nameUpdates = new HashMap<String, NameUpdates>();
    private MemData tmp;

    abstract void add(Update var1, QueryContext var2) throws QueryException;

    protected final void add(Update up) throws QueryException {
        if (up instanceof DataUpdate) {
            DataUpdate dataUp = (DataUpdate)up;
            Data data = dataUp.data();
            DataUpdates ups = this.dbUpdates.get(data);
            if (ups == null) {
                ups = new DataUpdates(data);
                this.dbUpdates.put(data, ups);
            }
            if (this.tmp == null) {
                this.tmp = new MemData(data.meta.options);
            }
            ups.add(dataUp, this.tmp);
        } else {
            NameUpdate nameUp = (NameUpdate)up;
            String name = nameUp.name();
            NameUpdates ups = this.nameUpdates.get(name);
            if (ups == null) {
                ups = new NameUpdates();
                this.nameUpdates.put(name, ups);
            }
            ups.add(nameUp);
        }
    }

    void databases(StringList db) {
        for (Data data : this.dbUpdates.keySet()) {
            if (data.inMemory()) continue;
            db.add(data.meta.name);
        }
        for (NameUpdates up : this.nameUpdates.values()) {
            up.databases(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final void apply() throws QueryException {
        for (DataUpdates dataUpdates : this.dbUpdates.values()) {
            if (this.tmp == null) {
                this.tmp = new MemData(dataUpdates.data().meta.options);
            }
            dataUpdates.prepare(this.tmp);
        }
        for (NameUpdates nameUpdates : this.nameUpdates.values()) {
            nameUpdates.prepare();
        }
        for (NameUpdates nameUpdates : this.nameUpdates.values()) {
            nameUpdates.apply(true);
        }
        HashSet<Data> datas = new HashSet<Data>();
        for (Data data : this.dbUpdates.keySet()) {
            datas.add(data);
        }
        boolean bl = false;
        try {
            for (Data data : datas) {
                void var2_9;
                if (!data.startUpdate()) {
                    throw Err.BXDB_OPENED.get(null, data.meta.name);
                }
                ++var2_9;
            }
            for (DataUpdates c : this.dbUpdates.values()) {
                c.apply();
            }
        }
        finally {
            for (Data data : datas) {
                void var2_10;
                if (--var2_10 <= 0) continue;
                data.finishUpdate();
            }
        }
        for (NameUpdates up : this.nameUpdates.values()) {
            up.apply(false);
        }
    }

    final int size() {
        int s = 0;
        for (DataUpdates dataUpdates : this.dbUpdates.values()) {
            s += dataUpdates.size();
        }
        for (NameUpdates nameUpdates : this.nameUpdates.values()) {
            s += nameUpdates.size();
        }
        return s;
    }
}

