/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.atomic.DataClip;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBNew;
import org.basex.query.up.primitives.DBUpdate;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class DBAdd
extends DBUpdate {
    private final DBNew add;
    private int size;

    public DBAdd(Data data, NewInput input, QueryContext qc, InputInfo info) {
        super(UpdateType.DBADD, data, info);
        ArrayList<NewInput> docs = new ArrayList<NewInput>();
        docs.add(input);
        this.add = new DBNew(qc, docs, info);
    }

    @Override
    public void merge(Update up) {
        DBAdd a = (DBAdd)up;
        for (NewInput input : a.add.inputs) {
            this.add.inputs.add(input);
        }
    }

    @Override
    public void apply() {
        this.data.insert(this.data.meta.size, -1, new DataClip(this.add.md));
    }

    @Override
    public void prepare(MemData tmp) throws QueryException {
        this.size = this.add.inputs.size();
        this.add.addDocs(new MemData(tmp), this.data.meta.name);
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return Util.className(this) + '[' + this.add.inputs + ']';
    }
}

