/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import java.util.List;
import org.basex.build.Parser;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Optimize;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.atomic.DataClip;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBNew;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.NameUpdate;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.options.Options;

public final class DBCreate
extends NameUpdate {
    private final DBNew add;
    private final DBOptions updates;

    public DBCreate(InputInfo info, String name, List<NewInput> input, Options opts, QueryContext qc) throws QueryException {
        super(UpdateType.DBCREATE, name, info, qc);
        this.updates = new DBOptions(qc, opts.free(), info);
        this.add = new DBNew(qc, input, info);
        this.updates.check(true);
    }

    @Override
    public void prepare() throws QueryException {
        if (this.add.inputs != null && !this.add.inputs.isEmpty()) {
            this.add.addDocs(new MemData(this.updates.qc.context.options), this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() throws QueryException {
        this.close();
        this.updates.initOptions();
        this.updates.assignOptions();
        try {
            Data data = CreateDB.create(this.name, Parser.emptyParser(this.updates.qc.context.options), this.updates.qc.context);
            if (this.add.md != null) {
                if (!data.startUpdate()) {
                    throw Err.BXDB_OPENED.get(null, data.meta.name);
                }
                try {
                    data.insert(data.meta.size, -1, new DataClip(this.add.md));
                    Optimize.optimize(data, null);
                }
                finally {
                    data.finishUpdate();
                }
            }
            Close.close(data, this.qc.context);
        }
        catch (IOException ex) {
            throw Err.UPDBOPTERR.get(this.info, ex);
        }
        finally {
            this.updates.resetOptions();
        }
    }

    public String toString() {
        return Util.className(this) + '[' + this.add.inputs + ']';
    }

    @Override
    public String operation() {
        return "created";
    }
}

